<?php
//função para remover acentos desnecessários
function removerAcentos($str)
{

  $comAcentos = array('à', 'á', 'â', 'ã', 'ä', 'å', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ù', 'ü', 'ú', 'ÿ', 'À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'O', 'Ù', 'Ü', 'Ú');
  $semAcentos = array('a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'y', 'A', 'A', 'A', 'A', 'A', 'A', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U');

  return str_replace($comAcentos, $semAcentos, $str);
}

function formatarCNS($numeroCNS)
{
  return substr($numeroCNS, 0, 3) . ' ' . substr($numeroCNS, 3, 4) . ' ' . substr($numeroCNS, 7, 4) . ' ' . substr($numeroCNS, 10, 4);
}

function receberIPCliente()
{
  $ipaddress = '';
  if (getenv('HTTP_CLIENT_IP'))
    $ipaddress = getenv('HTTP_CLIENT_IP');
  else if (getenv('HTTP_X_FORWARDED_FOR'))
    $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
  else if (getenv('HTTP_X_FORWARDED'))
    $ipaddress = getenv('HTTP_X_FORWARDED');
  else if (getenv('HTTP_FORWARDED_FOR'))
    $ipaddress = getenv('HTTP_FORWARDED_FOR');
  else if (getenv('HTTP_FORWARDED'))
    $ipaddress = getenv('HTTP_FORWARDED');
  else if (getenv('REMOTE_ADDR'))
    $ipaddress = getenv('REMOTE_ADDR');
  else
    $ipaddress = 'UNKNOWN';

  return $ipaddress;
}

$gerarNomeMes = array(
  '01' => 'JANEIRO',
  '02' => 'FEVEREIRO',
  '03' => 'MARÇO',
  '04' => 'ABRIL',
  '05' => 'MAIO',
  '06' => 'JUNHO',
  '07' => 'JULHO',
  '08' => 'AGOSTO',
  '09' => 'SETEMBRO',
  '10' => 'OUTUBRO',
  '11' => 'NOVEMBRO',
  '12' => 'DEZEMBRO'
);

$converterStatusAgenda = array(
  'A' => 'ATIVA',
  'I' => 'INATIVA',
  'E' => 'EXPIRADA'
);

$diaPortugues  = array('Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado');

function traduzirDiaSemanaAgendamento($opcaoNomeDia, $stringTraducao){

  $diaIngles = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
  switch($opcaoNomeDia){
    case "retorna-nome-completo":
      $diaPortugues  = array('Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado');
    break;
    case "retorna-nome-abreviado":
      $diaPortugues  = array('Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb');
    break;
  }
  return str_replace($diaIngles,$diaPortugues, $stringTraducao);
  
}

function traduzirCalendario($stringTabela){
  $diaIngles    = array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
  $diaPortugues  = array('Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado');
  return str_replace($diaIngles, $diaPortugues, $stringTabela);
}

function nomeDoDiaDaSemana(string $data): string{
  // Cria um objeto DateTime a partir da data fornecida, especificando o locale 'pt_BR'
  $data = new DateTime($data, new DateTimeZone('America/Bahia')); // Ajusta o fuso horário se necessário
  $data->setTimezone(new DateTimeZone('America/Bahia')); // Define o fuso horário para garantir a exibição correta

  // Formata a data para obter o nome completo do dia da semana em português do Brasil
  $nomeDia = $data->format('l');

  // Retorna o nome do dia
    return $nomeDia;
}

function traduzDiaDaSemana(string $data): strin{
  $diasDaSemana = ['Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado'];
  $diaDaSemana = date('w', strtotime($data)); // Obtém o dia da semana como um número (0-6)
  return $diasDaSemana[$diaDaSemana];
}

function traduzirDiaDaSemana($nomeDia){
  $parteDia     = array('Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado');
  $diasDaSemana = array('Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado');
  return str_replace($parteDia, $diasDaSemana, $nomeDia);
}


function dataHoraPorExtenso(string $data): string { 
  $formatter = new IntlDateFormatter(
	'pt_BR',
	IntlDateFormatter::FULL,
	IntlDateFormatter::FULL,
	'America/Sao_Paulo', // Fuso horário, ajuste conforme sua necessidade
	IntlDateFormatter::GREGORIAN
  );
  /*setlocale(LC_ALL,'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
  date_default_timezone_set('America/Sao_Paulo');
  return strftime('%A, %d de %B de %Y', strtotime($data));*/
  $formatter->setPattern("EEEE, d 'de' MMMM 'de' yyyy");
  return $formatter->format($data);
}

function getNomeDoDiaDaSemana(string $data): string
{
    // Cria um objeto DateTime a partir da data fornecida, especificando o locale 'pt_BR'
    $data = new DateTime($data, new DateTimeZone('America/Sao_Paulo')); // Ajusta o fuso horário se necessário
    $data->setTimezone(new DateTimeZone('America/Sao_Paulo')); // Define o fuso horário para garantir a exibição correta

    // Formata a data para obter o nome completo do dia da semana em português do Brasil
    $nomeDia = $data->format('l');

    // Retorna o nome do dia
    return $nomeDia;
}

; // Saída: quarta-feira