<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header-clean.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");
require("include/funcoes_gsaudereg.php");

$idAgendamento	= $_GET['ida'];


/****************CARREGAR DADOS DO PACIENTE*********************/
$sqlAgendamentoPaciente = "SELECT nome_paciente, cns_paciente, date_format(tb_paciente.datanasc,'%d/%m/%Y') as dataNascimento FROM tb_paciente 
INNER JOIN reg_tb_agendamentos ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente) WHERE reg_tb_agendamentos.id_agendamento='$idAgendamento'";

$stmDadosPaciente = $rsConexao->prepare($sqlAgendamentoPaciente);
$stmDadosPaciente->execute();
$rsDadosPaciebte  = $stmDadosPaciente->fetch(PDO::FETCH_OBJ);

$nomePaciente		= mb_strtoupper($rsDadosPaciebte->nome_paciente);
$cnsPaciente		= formatarCNS($rsDadosPaciebte->cns_paciente);
$dataNascimento	= $rsDadosPaciebte->dataNascimento;


/****************CARREGAR DADOS DO AGENDAMENTO*******************/
$formatarOrigem = array(
	'lista_unica' => 'LISTA ÚNICA',
	'policlinica' => 'POLICLÍNICA',
	'sisreg' => 'SISREG',
	'sistema_vida' => 'VIDA+',
);
$sqlAgendamento = "SELECT tb_usuario.nome_usuario, date_format(data_atendimento,'%d/%m/%Y') AS dataAtendimento, date_format(data_retirada,'%d/%m/%Y') AS prazoRetirada ,  reg_tb_agendamentos.numero_solicitacao, reg_tb_agendamentos.observacoes_demanda, reg_tb_agendamentos.origem_agendamento FROM reg_tb_agendamentos INNER JOIN tb_usuario ON (reg_tb_agendamentos.id_usuario_cadastrou=tb_usuario.id_usuario) WHERE reg_tb_agendamentos.id_agendamento='$idAgendamento'";

$stmAgendamento = $rsConexao->prepare($sqlAgendamento);
$stmAgendamento->execute();
$rsAgendamento  = $stmAgendamento->fetch(PDO::FETCH_OBJ);

$nomeOperadorAgendamento	= mb_strtoupper($rsAgendamento->nome_usuario);
$dataAtendimento					= $rsAgendamento->dataAtendimento;
$prazoRetirada						= $rsAgendamento->prazoRetirada;
$numeroSolicitacao				= $rsAgendamento->numero_solicitacao;
$observacoesAgendam				= mb_strtoupper($rsAgendamento->observacoes_demanda);
$origemAgendamento				= $formatarOrigem[$rsAgendamento->origem_agendamento];

/****************CARREGAR DADOS DA COMUNICAÇÃO*******************/
$sqlComunicacao = "SELECT tb_usuario.nome_usuario, date_format(reg_tb_agendamentos.dataregistro_comunicacao,'%d/%m/%Y') as dataContato, date_format(reg_tb_agendamentos.datahora_cadastro,'%d/%m/%Y') as dataCadastro, reg_tb_agendamentos.meio_comunicacao, reg_tb_agendamentos.observacoes_comunicacao, reg_tb_agendamentos.status_agendamento,reg_tb_agendamentos.dataregistro_comunicacao FROM tb_usuario RIGHT OUTER JOIN reg_tb_agendamentos ON (tb_usuario.id_usuario=reg_tb_agendamentos.idusuario_comunicacao) WHERE reg_tb_agendamentos.id_agendamento='$idAgendamento'";

$stmComunicacao = $rsConexao->prepare($sqlComunicacao);
$stmComunicacao->execute();
$rsComunicacao  = $stmComunicacao->fetch(PDO::FETCH_OBJ);

$nomeOperadorComunicacao	= mb_strtoupper($rsComunicacao->nome_usuario);
$dataComunicacao					= $rsComunicacao->dataregistro_comunicacao != "" ? $rsComunicacao->dataContato : $rsComunicacao->dataCadastro;
$meioComunicacao					= $rsComunicacao->meio_comunicacao == "ligacao_telefonica" ? "TELEFONE" : "WHATSAPP";
$statusAgendamento				= mb_strtoupper($rsComunicacao->status_agendamento);
$observacoesComunicacao		= mb_strtoupper($rsComunicacao->observacoes_comunicacao);


/****************CARREGAR DADOS DA SETOR ENTREGA*******************/
$sqlEntrega = "SELECT tb_usuario.nome_usuario, date_format(reg_tb_agendamentos.data_usuario_registrouentrega,'%d/%m/%Y') AS dataSetorEntrega FROM tb_usuario RIGHT OUTER JOIN reg_tb_agendamentos ON (tb_usuario.id_usuario = reg_tb_agendamentos.id_usuario_entregou) WHERE reg_tb_agendamentos.id_agendamento='$idAgendamento'";

$stmEntrega = $rsConexao->prepare($sqlEntrega);
$stmEntrega->execute();
$rsEntrega  = $stmEntrega->fetch(PDO::FETCH_OBJ);

$nomeOperadorEntrega	= mb_strtoupper($rsEntrega->nome_usuario);
$dataEntrega					= $rsEntrega->dataSetorEntrega;


?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-info-square" style='margin-top:-15px !important'></i>&nbsp;Informação sobre Movimentação de Agendamento
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" id="formularioConsumo">
									<div class="form-body" style='margin-top:-15px'>
										<h4 class="form-section"><i class="icofont icofont-user"></i> <b>Dados do Paciente:</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-6">
												<div class="form-group">
													<label for="nomePacienteLigacao">Nome do Paciente:</label>
													<input type="text" id="nomePacienteLigacao" class="form-control" readonly value="<?php echo $nomePaciente; ?>">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="cnsPaciente">CNS:</label>
													<input type="text" id="cnsPacienteLigacao" class="form-control text-center cns-inputmask" readonly value="<?php echo $cnsPaciente; ?>">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataEntrega">Data Nascimento:</label>
													<input type="text" id="dataEntrega" class="form-control text-center" value="<?php echo $dataNascimento; ?>" disabled>
												</div>
											</div>
										</div>
									</div>
									<div class="form-body" style='margin-top:-15px'>
										<h4 class="form-section bs-callout-blue callout-square callout-bordered mt-1"><i class="fa fa-stack-overflow"></i> <b>Registros do Agendamento:</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-4">
												<div class="form-group">
													<label for="operadorAgendamento">Nome do Operador:</label>
													<input type="text" id="operadorAgendamento" class="form-control" readonly value="<?php echo $nomeOperadorAgendamento; ?>">
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="dataAtendimento">Data Atendimento:</label>
													<input type="text" id="dataAtendimento" class="form-control text-center" readonly value="<?php echo $dataAtendimento; ?>">
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="prazoRetirada">Prazo Retirada:</label>
													<input type="text" id="prazoRetirada" class="form-control text-center" readonly value="<?php echo $prazoRetirada; ?>">
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="numeroSolicitacao">Nº Solicitação:</label>
													<input type="text" id="numeroSolicitacao" class="form-control text-center" readonly value="<?php echo $numeroSolicitacao; ?>">
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="origemAgendamento">Origem:</label>
													<input type="text" id="origemAgendamento" class="form-control text-center" readonly value="<?php echo $origemAgendamento; ?>">
												</div>
											</div>
											<div class="col-md-12" style='margin-top:-20px'>
												<div class="form-group">
													<label for="observacaoDemanda">Observações no Agendamento:</label>
													<input type="text" id="observacaoDemanda" class="form-control" readonly value="<?php echo $observacoesAgendam; ?>">
												</div>
											</div>
										</div>
									</div>
									<div class="form-body" style='margin-top:-15px'>
										<h4 class="form-section bs-callout-warning callout-square callout-bordered mt-1"><i class="icofont icofont-ui-contact-list"></i> <b>Registros da Comunicação:</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-4">
												<div class="form-group">
													<label for="operadorComunicacao">Nome do Operador:</label>
													<input type="text" id="operadorComunicacao" class="form-control" readonly value="<?php echo $nomeOperadorComunicacao; ?>">
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="dataComunicacao">Data Contato:</label>
													<input type="text" id="dataComunicacao" class="form-control text-center" readonly value="<?php echo $dataComunicacao; ?>">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="meioComunicacao">Meio de Contato:</label>
													<input type="text" id="meioComunicacao" class="form-control text-center" readonly value="<?php echo $meioComunicacao; ?>">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="statusRegistradoComunicacao">Status Informado:</label>
													<input type="text" id="statusRegistradoComunicacao" class="form-control text-center" readonly value="<?php echo $statusAgendamento; ?>">
												</div>
											</div>
											<div class="col-md-12" style='margin-top:-20px'>
												<div class="form-group">
													<label for="observacoesComunicacao">Observações no Agendamento:</label>
													<input type="text" id="observacoesComunicacao" class="form-control" readonly value="<?php echo $observacoesComunicacao; ?>">
												</div>
											</div>
										</div>
									</div>
									<div class="form-body" style='margin-top:-15px'>
										<h4 class="form-section bs-callout-green callout-square callout-bordered mt-1"><i class="icofont icofont-files"></i> <b>Registros no Setor de Entrega:</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-4">
												<div class="form-group">
													<label for="operadorEntrega">Nome do Operador:</label>
													<input type="text" id="operadorEntrega" class="form-control" readonly value="<?php echo $nomeOperadorEntrega; ?>">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataRegistro">Data do Registro:</label>
													<input type="text" id="dataRegistro" class="form-control text-center" readonly value="<?php echo $dataEntrega; ?>">
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group" style='padding-top:27px'>
													<button type="button" class="btn btn-danger" id="botao_modal_info" onclick="fecharAba()"><i class="ft-log-out botaoOk"></i><b>&nbsp;Fechar</b></button>
												</div>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	/* atualizar status do agendamento*/
	function fecharAba(opcaoFecharAba) {
		window.close();
	}

	/* atualizar status do agendamento*/
	function atualizarStatus(idAgendamento, valorStatus) {

		$.ajax({
			url: 'action/gravar_atualizacaostatus',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoAtualizacao': 'status-entrega',
				'idAgendamento': idAgendamento,
				'valorStatus': valorStatus,
				'tokenEntrega': $("#tokenEntrega").val(),
			}
		}).done(function(resultadoRetorno) {});

	}

	$("#pacienteEPortador").change(function() {

		if (this.checked) {
			$("#nomePortador").val('');
			$("#rgPortador").val('');
			$("#telefonePortador").val('');
			$("#nomePortador").prop('disabled', true);
			$("#telefonePortador").prop('disabled', true);
			$("#rgPortador").prop('disabled', true);
		} else {
			$("#nomePortador").prop('disabled', false);
			$("#nomePortador").focus();
			$("#rgPortador").prop('disabled', false);
			$("#telefonePortador").prop('disabled', false);
		}
	})


	function confirmarEntregaMarcacao() {

		var pacientePortador = document.getElementById('pacienteEPortador').checked == true ? "S" : "N";

		if (pacientePortador == "N") {
			if ($("#dataEntrega").val() == "" || $("#nomePortador").val() == "" || $("#rgPortador").val() == "") {
				swal("Dados Obrigatórios", "Dados do portador devem ser preenchidos.", "error");
				return false;
			}
		}

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'action/gravar_entregamarcacao',
			type: 'post',
			dataType: 'html',
			data: {
				'IdPaciente': $("#idPacienteEntrega").val(),
				'dataEntrega': $("#dataEntrega").val(),
				'nomePortador': $("#nomePortador").val(),
				'rgPortador': $("#rgPortador").val(),
				'telefonePortador': $("#telefonePortador").val(),
				'observacoesEntrega': $("#observacoesEntrega").val(),
				'pacientePortador': pacientePortador,
				'tokenEntrega': $("#tokenEntrega").val()
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			swal("Entrega Registrada", "Dados da entrega registrados com sucesso.", "success");
		});

	}
</script>