const cron = require('node-cron');
const { exec } = require('child_process');

function executeTask() {
    console.log(`Início da execução: ${new Date().toLocaleTimeString()}`);

    exec('node importa_solicitacao_esus.js', (error, stdout, stderr) => {
        if (error) {
            console.error(`Erro na execução do importa_solicitacao_esus.js: ${error.message}`);
            return;
        }
        if (stderr) {
            console.error(`Erro de saída do importa_solicitacao_esus.js: ${stderr}`);
        }
        console.log(`Importação dos encaminhamentos finalizado:\n${stdout}`);

        
        exec('node processa_importacao_esus.js', (error2, stdout2, stderr2) => {
            if (error2) {
                console.error(`Erro na execução do processa_importacao_esus.js: ${error2.message}`);
                return;
            }
            if (stderr2) {
                console.error(`Erro de saída do processa_importacao_esus.js: ${stderr2}`);
            }
            console.log(`Processamento interno finalizado:\n${stdout2}`);
            console.log(`Execução completa em: ${new Date().toLocaleTimeString()}`);
        });
    });
}


cron.schedule('0 21 * * *', () => {
    executeTask();
});

console.log('Cron rodando...');
