const fs = require('fs');
const path = require('path');
const mysql = require('mysql2');
const axios = require('axios');
const https = require('https');
const dotenv = require('dotenv');
const envData = fs.readFileSync('conecta.env', 'utf8');
const envVariables = dotenv.parse(envData);
dotenv.config();

const certFilePath = path.join(__dirname, 'certificado.pem');
const keyFilePath = path.join(__dirname, 'chave.pem');
const passphrase = '130203';
const tokenFilePath = path.join(__dirname, 'token.txt');

let quantidadeEnviada = 0;
let quantidadeErro = 0;
const {
  DB_MYSQL_SERVER,
  DB_MYSQL_USERNAME,
  DB_MYSQL_PASSWORD,
  DB_MYSQL_NAME,
} = envVariables;

function getToken() {
    try {
        const data = fs.readFileSync(tokenFilePath, 'utf8');
        const match = data.match(/TOKEN:\s*(.+)/);
        if (match && match[1]) {
            return match[1].trim();
        } else {
            throw new Error('Token não encontrado no arquivo.');
        }
    } catch (err) {
        console.error('Erro ao ler o token:', err.message);
        return null;
    }
}

const connection = mysql.createConnection({
  host: DB_MYSQL_SERVER,
  user: DB_MYSQL_USERNAME,
  password: DB_MYSQL_PASSWORD,
  database: DB_MYSQL_NAME,
});

function fetchData() {
  return new Promise((resolve, reject) => {
    const query = `select * from ztemp_rnds_delete WHERE (deletado_rnds='N')`
    connection.query(query, (error, results) => {
      if (error) {
        reject(error);
      } else {
        resolve(results);
      }
    });
  });
}

  async function sendBundle(item) {
    const token = getToken();
    if (!token) {
        console.error('Token não disponível. Não é possível enviar o bundle.');
        return;
    }

    try {
        const httpsAgent = new https.Agent({
            cert: fs.readFileSync(certFilePath),
            key: fs.readFileSync(keyFilePath),
            passphrase: passphrase,
            rejectUnauthorized: true
        });

        const response = await axios.delete(
            'https://ba-ehr-services.saude.gov.br/api/fhir/r4/Bundle/'+item.id_doc_rnds,
            {
                headers: {
                    'Content-Type': 'application/json',
                    'X-Authorization-Server': `Bearer ${token}`,
                    'Authorization': String('67848257568')
                },
                httpsAgent: httpsAgent
            }
        );
		console.log('SUCESSO:', response.data);
        quantidadeEnviada++;
        
        connection.query(
            `UPDATE ztemp_rnds_delete SET deletado_rnds='S' WHERE id_doc_rnds=?`,
            [item.id_doc_rnds],
            (error) => {
                if (error) {
                    console.error('Erro ao atualizar enviado_rnds_delete:', error.message);
                }
            }
        );



	} catch (error) {
        if (error.response) {
            const diagnosticsData = (error.response.data.issue && error.response.data.issue.length > 0)
                ? error.response.data.issue[0].diagnostics
                : null;

            let extractedDiagnostics = null;
            if (diagnosticsData) {
                extractedDiagnostics = diagnosticsData; 
            }

            if (diagnosticsData && diagnosticsData.includes('EDS-MSG006')) {
                console.log('O ID RNDS foi excluído:', diagnosticsData);
                
                connection.query(
                    `UPDATE ztemp_rnds_delete SET deletado_rnds='S' WHERE id_doc_rnds=?`,
                    [item.id_doc_rnds],
                    (error) => {
                        if (error) {
                            console.error('Erro ao atualizar enviado_rnds_delete:', error.message);
                        }
                    }
                );
                quantidadeEnviada++; 
            } else {
                quantidadeErro++;
                console.error('Request failed:', error.response.status);
                console.error('Response:', error.response.data);

                connection.query(
                    `UPDATE ztemp_rnds_delete SET deletado_rnds='N' WHERE id_doc_rnds=?`,
                    [item.id_doc_rnds],
                    (error) => {
                        if (error) {
                            console.error('Erro ao excluri registro na rnds:', error.message);
                        }
                    }
                );
            }

        } else {
            console.error('Request failed:', error.message);
        }
    }
}

async function process() {

    try {
        const data = await fetchData();
        for (const item of data) {
            await sendBundle(item);
        }

    } catch (err) {
        console.error('Erro ao processar dados:', err.message);
    } finally {
        connection.end();
    }
}
process();
