
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function () {
    
            carregarDados();
            setInterval(carregarDados, 5000); 

            $('#botaoQrCode').on('click', gerarQrCode);
            $('#botaoAtualizarQrCode').on('click', gerarQrCode);
            $('#botaoDesconectar').on('click', desconectar);
          
            
        });

        const instanciaNome = 'GSaudeCandeias'; //Colocar o nome da instancia aqui e ja foi 

        function chamarAPI(operacao, instancia = '') {
            return $.ajax({
                url: 'apibusca.php',
                method: 'POST',
                data: { operacao, instancia },
                dataType: 'json'
            });
        }

        function carregarDados() {
        chamarAPI('fetchInstances').done(function (dados) {
           
            const instancia = dados.find(item => item.name === instanciaNome) || {};
            const statusDiv = $('#status');
            const detalhesDiv = $('#detalhes');

            if (instancia.connectionStatus === 'open') {
                // Conectado
                statusDiv.removeClass('status-desconectado').addClass('status-conectado').text('Conectado');
                detalhesDiv.show();
                $('#fotoPerfil').attr('src', instancia.profilePicUrl || 'https://via.placeholder.com/150');
                $('#telefoneDono').text(instancia.ownerJid?.split('@')[0] || 'Não disponível');
                $('#nomePerfil').text(instancia.profileName || 'Não disponível');
                $('#botaoDesconectar').show();
                $('#botaoQrCode').hide();
            } else {
                // Desconectado
                statusDiv.removeClass('status-conectado').addClass('status-desconectado').text('Desconectado');
                detalhesDiv.hide();
                $('#botaoDesconectar').hide();
                $('#botaoQrCode').show();
            }
        });
    }


        function gerarQrCode() {
           
            $('#loadingGif').show();
            $('#imagemQrCode').hide();

            chamarAPI('connect', instanciaNome).done(function (dados) {
                
                $('#imagemQrCode').attr('src', dados.base64 || '').show();
                $('#loadingGif').hide(); 

                $('#modalQrCode').modal('show');

                
                const intervaloConexao = setInterval(function () {
                    chamarAPI('fetchInstances').done(function (dados) {
                        const instancia = dados.find(item => item.name === instanciaNome) || {};
                        if (instancia.connectionStatus === 'open') {
                            clearInterval(intervaloConexao);
                            $('#botaoAtualizarQrCode').prop('disabled', true); 
                            $('#modalQrCode').modal('hide'); 
                        }
                    });
                }, 5000); 
            });
        }
       
   
        function desconectar() {
            chamarAPI('logout', instanciaNome).done(function () {
                alert('Desconectado com sucesso!');
                carregarDados();
            });
        }

        $(document).ready(function () {
            carregarDados();
            $('#botaoQrCode').on('click', gerarQrCode);
            $('#botaoAtualizarQrCode').on('click', gerarQrCode);
            $('#botaoDesconectar').on('click', desconectar);
        });
    </script>
