//função para limpar caracteres de uma string

//Função para selecionar os tipos de buscar do cadastro do cidadão.
function selecionaBuscaPaciente(selOpcao) {

  $("#opcaoPesquisa").val(selOpcao);

  switch (selOpcao) {
    case "radio-cns":
      $('#pesquisaCNS').prop('disabled', false);
      $('#pesquisaCPF').prop('disabled', true);
      $('#pesquisaNome').prop('disabled', true);
      $('#pesquisaDataNascimento').prop('disabled', true);
      $('#pesquisaNomeMae').prop('disabled', true);
      $('#historicoDataInicial').prop('disabled', true);
      $('#historicoDataFinal').prop('disabled', true);
      $('#pesquisaCNS').focus();

      $('#pesquisaCPF').val('');
      $('#pesquisaNome').val('');
      $('#pesquisaDataNascimento').val('');
      $('#pesquisaNomeMae').val('');
      $('#historicoDataInicial').val('');
      $('#historicoDataFinal').val('');
      break;

    case "radio-cpf":
      $('#pesquisaCPF').prop('disabled', false);
      $('#pesquisaCNS').prop('disabled', true);
      $('#pesquisaNome').prop('disabled', true);
      $('#pesquisaDataNascimento').prop('disabled', true);
      $('#pesquisaNomeMae').prop('disabled', true);
      $('#historicoDataInicial').prop('disabled', true);
      $('#historicoDataFinal').prop('disabled', true);
      $('#pesquisaCPF').focus();

      $('#pesquisaCNS').val('');
      $('#pesquisaNome').val('');
      $('#pesquisaDataNascimento').val('');
      $('#pesquisaNomeMae').val('');
      $('#historicoDataInicial').val('');
      $('#historicoDataFinal').val('');
      break;

    case "radio-nome":
      $('#pesquisaNome').prop('disabled', false);
      $('#pesquisaDataNascimento').prop('disabled', false);
      $('#pesquisaNomeMae').prop('disabled', false);
      $('#pesquisaCPF').prop('disabled', true);
      $('#pesquisaCNS').prop('disabled', true);
      $('#historicoDataInicial').prop('disabled', true);
      $('#historicoDataFinal').prop('disabled', true);
      $('#pesquisaNome').focus();

      $('#pesquisaCNS').val('');
      $('#pesquisaCPF').val('');
      $('#historicoDataInicial').val('');
      $('#historicoDataFinal').val('');
      break;

    case "radio-periodo":
      $('#historicoDataInicial').prop('disabled', false);
      $('#historicoDataFinal').prop('disabled', false);
      $('#pesquisaDataNascimento').prop('disabled', true);
      $('#pesquisaNomeMae').prop('disabled', true);
      $('#pesquisaNome').prop('disabled', true);
      $('#pesquisaCPF').prop('disabled', true);
      $('#pesquisaCNS').prop('disabled', true);

      $('#historicoDataInicial').focus();

      $('#pesquisaCPF').val('');
      $('#pesquisaCNS').val('');
      $('#pesquisaNome').val('');
      $('#pesquisaDataNascimento').val('');
      $('#pesquisaNomeMae').val('');
      break;
  }

}


//Função para buscar de endereços pelo CEP digitado
function PesquisaCEP(getCEP, campoEndereco, campoBairro, campoCidade, campoIBGE, campoUF) {

  var limpaCEP = getCEP.replace("_", "");
  limpaCEP = limpaCEP.replace("__", "");
  limpaCEP = limpaCEP.replace("___", "");
  limpaCEP = limpaCEP.replace("____", "");
  limpaCEP = limpaCEP.replace("_____", "");
  limpaCEP = limpaCEP.replace("-", "");

  if (limpaCEP.length < 8 && limpaCEP != "") {
    $("#" + campoEndereco).val('');
    $("#" + campoBairro).val('');
    $("#" + campoCidade).val('');
    $("#" + campoIBGE).val('');
    $("#box_informa_body").html("CEP inválido!");
    $("#box_informa").modal();
    return false;
  } else {
    if (limpaCEP != "") {
      $("#embacado").css("display", "block");
      var urlBuscaCEP = "action/buscacep/buscacep?cep=" + getCEP;
      $.get(urlBuscaCEP, function (resultadoRetorno) {
        var retornoCEP = resultadoRetorno.split("#");
        $("#" + campoEndereco).val(retornoCEP[0]);
        $("#" + campoBairro).val(retornoCEP[1]);
        $("#" + campoCidade).val(retornoCEP[2] + '-' + retornoCEP[3]);
        $("#" + campoIBGE).val(retornoCEP[4]);
        $("#embacado").css("display", "none");
        $("#enderecoPaciente").focus();
      });
    } else {
      $("#" + campoEndereco).val('');
      $("#" + campoBairro).val('');
      $("#" + campoCidade).val('');
      $("#" + campoIBGE).val('');
    }
  }
}

function validaCNS(vlrCNS) {

  var cnsLimpo = vlrCNS.replace(/[^a-z0-9]/gi, '');
  tamanhoCNS = cnsLimpo.length;


  if (cnsLimpo != "") {

    if (tamanhoCNS < 15) {
      $("#box_informa_body").html("Número do cartão SUS inválido.");
      $("#box_informa").modal();
      return false;
    }
    inicalCNS = cnsLimpo.substr(0, 1);
    if (inicalCNS == "1" || inicalCNS == "2") {
      var soma = new Number;
      var resto = new Number;
      var dv = new Number;
      var pis = new String;
      var resultado = new String;
      var tamCNS = cnsLimpo.length;

      if ((tamCNS) != 15) {
        $("#box_informa_body").html("Número do cartão SUS inválido.");
        $("#box_informa").modal();
        return false;
      }
      pis = cnsLimpo.substring(0, 11);
      soma = (((Number(pis.substring(0, 1))) * 15) +
        ((Number(pis.substring(1, 2))) * 14) +
        ((Number(pis.substring(2, 3))) * 13) +
        ((Number(pis.substring(3, 4))) * 12) +
        ((Number(pis.substring(4, 5))) * 11) +
        ((Number(pis.substring(5, 6))) * 10) +
        ((Number(pis.substring(6, 7))) * 9) +
        ((Number(pis.substring(7, 8))) * 8) +
        ((Number(pis.substring(8, 9))) * 7) +
        ((Number(pis.substring(9, 10))) * 6) +
        ((Number(pis.substring(10, 11))) * 5));
      resto = soma % 11;
      dv = 11 - resto;
      if (dv == 11) {
        dv = 0;
      }
      if (dv == 10) {
        soma = (((Number(pis.substring(0, 1))) * 15) +
          ((Number(pis.substring(1, 2))) * 14) +
          ((Number(pis.substring(2, 3))) * 13) +
          ((Number(pis.substring(3, 4))) * 12) +
          ((Number(pis.substring(4, 5))) * 11) +
          ((Number(pis.substring(5, 6))) * 10) +
          ((Number(pis.substring(6, 7))) * 9) +
          ((Number(pis.substring(7, 8))) * 8) +
          ((Number(pis.substring(8, 9))) * 7) +
          ((Number(pis.substring(9, 10))) * 6) +
          ((Number(pis.substring(10, 11))) * 5) + 2);
        resto = soma % 11;
        dv = 11 - resto;
        resultado = pis + "001" + String(dv);
      } else {
        resultado = pis + "000" + String(dv);
      }
      if (cnsLimpo != resultado) {
        $("#box_informa_body").html("Número do cartão SUS inválido.");
        $("#box_informa").modal();
        return false;
      } else {
        return true;
      }

    } else if (inicalCNS == "7" || inicalCNS == "8" || inicalCNS == "9") {
      var pis;
      var resto;
      var dv;
      var soma;
      var resultado;
      var result;
      result = 0;

      pis = cnsLimpo

      if (pis == "") {
        return false
      }

      soma = ((parseInt(pis.substring(0, 1), 10)) * 15)
        + ((parseInt(pis.substring(1, 2), 10)) * 14)
        + ((parseInt(pis.substring(2, 3), 10)) * 13)
        + ((parseInt(pis.substring(3, 4), 10)) * 12)
        + ((parseInt(pis.substring(4, 5), 10)) * 11)
        + ((parseInt(pis.substring(5, 6), 10)) * 10)
        + ((parseInt(pis.substring(6, 7), 10)) * 9)
        + ((parseInt(pis.substring(7, 8), 10)) * 8)
        + ((parseInt(pis.substring(8, 9), 10)) * 7)
        + ((parseInt(pis.substring(9, 10), 10)) * 6)
        + ((parseInt(pis.substring(10, 11), 10)) * 5)
        + ((parseInt(pis.substring(11, 12), 10)) * 4)
        + ((parseInt(pis.substring(12, 13), 10)) * 3)
        + ((parseInt(pis.substring(13, 14), 10)) * 2)
        + ((parseInt(pis.substring(14, 15), 10)) * 1);

      resto = soma % 11;

      if (resto == 0) {
        return true;
      } else {
        $("#box_informa_body").html("Número do cartão SUS inválido.");
        $("#box_informa").modal();
        return false;
      }

    }
  } else {
    return true;
  }
}

//Função para validar CPF
function validaCPF(numeroCPF) {


  var numeros, digitos, soma, i, resultado, digitos_iguais;
  digitos_iguais = 1;

  var cpfLimpo = numeroCPF.replace(/[^a-z0-9]/gi, '');

  if (cpfLimpo != "") {
    for (i = 0; i < cpfLimpo.length - 1; i++)
      if (cpfLimpo.charAt(i) != cpfLimpo.charAt(i + 1)) {
        digitos_iguais = 0;
        break;
      }
    if (!digitos_iguais) {
      numeros = cpfLimpo.substring(0, 9);
      digitos = cpfLimpo.substring(9);
      soma = 0;
      for (i = 10; i > 1; i--)
        soma += numeros.charAt(10 - i) * i;
      resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
      if (resultado != digitos.charAt(0)) {
        $("#box_informa_body").html("Número do CPF inválido.");
        $("#box_informa").modal();
        return false;
      }
      numeros = cpfLimpo.substring(0, 10);
      soma = 0;
      for (i = 11; i > 1; i--)
        soma += numeros.charAt(11 - i) * i;
      resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
      if (resultado != digitos.charAt(1)) {
        $("#box_informa_body").html("Número do CPF inválido.");
        $("#box_informa").modal();
        return false;
      } else {
        return true;
      }
    } else {
      $("#box_informa_body").html("Número do CPF inválido.");
      $("#box_informa").modal();
      return false;
    }
    return false;
  } else {
    return true;
  }
}


//Função para gravar dados do cidadão
function gravarPaciente() {

  if ($("#nomePaciente").val() == "") {
    $("#box_informa_body").html("Você deve informar o nome do cidadão.");
    $("#box_informa").modal();
    return false;
  } else if ($("#numeroCNS").val() == "" && $("#numeroCPF").val() == "") {
    $("#box_informa_body").html("Você deve informar cartão SUS ou CPF do cidadão.");
    $("#box_informa").modal();
    return false;
  } else if ($("#dataNascimento").val() == "") {
    $("#box_informa_body").html("A data de nascimento é obrigatória.");
    $("#box_informa").modal();
    return false;
  } else if ($("#sexoPaciente").val() == "") {
    $("#box_informa_body").html("Você deve preencher a informação de sexo.");
    $("#box_informa").modal();
    return false;
  } else if ($("#nomeMaePaciente").val() == "") {
    $("#box_informa_body").html("Preencha o nome da mãe ou responsável.");
    $("#box_informa").modal();
    return false;
  } else if ($("#racaCorPaciente").val() == "") {
    $("#box_informa_body").html("Preencha o campo Raça/Cor ou selecionar a opção NÃO INFORMADA.");
    $("#box_informa").modal();
    return false;
  } else if (!validaCNS($("#numeroCNS").val())) {
    $("#box_informa_body").html("Número do cartão SUS inválido. Digite um número válido!");
    $("#box_informa").modal();
    return false;
  } else if (!validaCPF($("#numeroCPF").val())) {
    $("#box_informa_body").html("Número do CPF. Digite um número válido!");
    $("#box_informa").modal();
    return false;
  }

  var telCelularWhatsapp;
  if (document.getElementById('telCelularWhatsapp').checked == true) {
    telCelularWhatsapp = "S";
  } else {
    telCelularWhatsapp = "N";
  }

  var telContatoWhatsapp;
  if (document.getElementById('telContatoWhatsapp').checked == true) {
    telContatoWhatsapp = "S";
  } else {
    telContatoWhatsapp = "N";
  }

  $("#processandoDados").html("Aguarde! Salvando dados...");
  $("#embacado").css("display", "block");
  $.ajax({
    url: 'action/gravar_paciente',
    type: 'post',
    dataType: 'html',
    data: {
      'idPaciente': $("#idPaciente").val(),
      'nomePaciente': $("#nomePaciente").val(),
      'numeroCNS': $("#numeroCNS").val(),
      'numeroCPF': $("#numeroCPF").val(),
      'dataNascimento': $("#dataNascimento").val(),
      'sexoPaciente': $("#sexoPaciente").val(),
      'nomeMaePaciente': $("#nomeMaePaciente").val(),
      'racaCorPaciente': $("#racaCorPaciente").val(),
      'cepPaciente': $("#cepPaciente").val(),
      'enderecoPaciente': $("#enderecoPaciente").val(),
      'numeroEnderecoPaciente': $("#numeroEnderecoPaciente").val(),
      'pontoRederencia': $("#pontoRederencia").val(),
      'bairroPaciente': $("#bairroPaciente").val(),
      'ibgeCidade': $("#ibgeCidade").val(),
      'telFixoPaciente': $("#telFixoPaciente").val(),
      'telCelularPaciente': $("#telCelularPaciente").val(),
      'telCelularWhatsapp': telCelularWhatsapp,
      'telTelefoneContatoPaciente': $("#telTelefoneContatoPaciente").val(),
      'telContatoWhatsapp': telContatoWhatsapp,
      'emailPaciente': $("#emailPaciente").val(),
      'observacaoPaciente': $("#observacaoPaciente").val()
    }
  }).done(function (data) {
    $("#embacado").css("display", "none");
    $("#box_informa_body").html(data);
    $("#box_informa").modal();
    setTimeout("window.location.href='registrosolicitacao'", 2000);
  });

}

//Função para adicionar cidadão à lista de atendimento
function adicionarFila() {
  $("#box_adicionafila").modal();
}

//Ação ao alterar valor do combo/select Tipo de Atendimento na janela de adicionar à fila

$("#tipoAtendimento").change(function () {

  $("#profissionalAtende").html("<option value=''>CARREGANDO...</option>");
  $.ajax({
    url: 'filtros/filtrar_profissional',
    type: 'post',
    dataType: 'html',
    data: {
      'dadosfiltro': this.value
    }
  }).done(function (data) {
    $("#profissionalAtende").html(data);
  });

  if (this.value == "medico") {
    $("#modal-body-addfila").css("height", "350px");
    $("#tr_linhaAdicional").css("display", "block");
  } else {
    $("#modal-body-addfila").css("height", "260px");
    $("#tr_linhaAdicional").css("display", "none");
  }
});

//Ação ao clicar no botão de confirmação para adicionar o cidadão à fila de espera
$("#confirmaLista").click(function () {
  if ($("#tipoAtendimento").val() == "" || $("#profissionalAtende").val() == "") {
    $("#box_informa_body").html("Você deve informar o tipo de atendimento e o profissional que realizará o atendimento. Lembre de verificar se é prioridade!");
    $("#box_informa").modal();
    return false;
  } else {
    var teveCovid = "";
    var estaGestante = "";
    if (document.getElementById('chkTeveCovid').checked == true) {
      teveCovid = "S";
    } else {
      teveCovid = "N";
    }

    $.ajax({
      url: 'action/gravar_nafila',
      type: 'post',
      dataType: 'html',
      data: {
        'idPaciente': $("#idPaciente").val(),
        'tipoAtendimento': $("#tipoAtendimento").val(),
        'profissionalAtende': $("#profissionalAtende").val(),
        'definePrioridade': $("#definePrioridade").val(),
        'chkTeveCovid': teveCovid
      }
    }).done(function (data) {
      $("#box_informa_body").html(data);
      $("#box_informa").modal();
      setTimeout(function () { window.location.href = "buscapaciente"; }, 3000);
    });
  }
});

function confirmaPesquisaBox(opcaoItemPesquisa, opcaoTelaPesquia) {

  if (opcaoTelaPesquia == "bureg_procedimento") {

    if ($("#nomeProcedimentopPesquisa").val() == "") {
      $("#box_informa_body").html("Você deve digitar pelo menos parte do nome do procedimento ou o seu código!");
      $("#box_informa").modal();
      return false;
    }
    $("#embacado_popup").css("display", "block");
    $.ajax({
      url: opcaoItemPesquisa,
      type: 'post',
      dataType: 'html',
      data: {
        'nomeProcedimento': $("#nomeProcedimentopPesquisa").val()
      }
    }).done(function (retornaDados) {
      $("#retornoResultadoProcedimento").html(retornaDados);
      $("#embacado_popup").css("display", "none");
    });
  }

}

function abrirFuncoesAtendimentoMedico(qOpcao) {

  var registroSalvo = $("#idAtendimentoMedico").val();

  if (registroSalvo == "") {
    $("#box_informa_body").html("Documento só pode ser emitido após finalizar o atendimento no sistema!");
    $("#box_informa").modal();
    return false;
  } else {
    $("#" + qOpcao).modal();
  }
}

//Ação ao clicar no botão de confirmação para adicionar o cidadão à fila de espera
function finalizaAtendimento(opcaoAtendimento) {


  if (opcaoAtendimento == "medico") {
    alert(opcaoAtendimento + ' 22222');
    var doencaHipertensao = document.getElementById('chkDoenca_Hipertensao').checked ? "S" : "N";
    var doencaDiabetes = document.getElementById('chkDoenca_Diabetes').checked ? "S" : "N";
    var doencaColuna = document.getElementById('chkDoenca_Coluna').checked ? "S" : "N";
    var doencaArtropatia = document.getElementById('chkDoenca_Artropatias').checked ? "S" : "N";
    var doencaCardiovascular = document.getElementById('chkDoenca_Cardio').checked ? "S" : "N";
    var doencaLer = document.getElementById('chkDoenca_Ler').checked ? "S" : "N";
    var doencaTendinite = document.getElementById('chkDoenca_Tendinite').checked ? "S" : "N";
    var doencaAbdominal = document.getElementById('chkDoenca_Abdominal').checked ? "S" : "N";
    var doencaAvc = document.getElementById('chkDoenca_Avc').checked ? "S" : "N";
    var doencaOutras = document.getElementById('chkDoenca_outra').checked ? "S" : "N";
    var habitoAlcoolismo = document.getElementById('chkHabito_Alcoolismo').checked ? "S" : "N";
    var habitoSedentarismo = document.getElementById('chkHabito_Sedentarismo').checked ? "S" : "N";
    var habitoTabagismo = document.getElementById('chkHabito_Tabagismo').checked ? "S" : "N";
    var habitoOutros = $("#chkHabito_Outros").val();
    var queixasPrincipais = nicEditors.findEditor('queixaPrincipal').getContent();
    var descricaoAnamnese = nicEditors.findEditor('descricaoAnamnese').getContent();
    var codigoCid = $("#suspeitaDiagnosticaID").val();
    var nomeCid = $("#suspeitaDiagnosticaString").val();
    var condutaCedica = nicEditors.findEditor('condutaMedica').getContent();

    if (queixasPrincipais == "" || codigoCid == "" || condutaCedica == "") {
      $("#box_informa_body").html("Você deve informar dados do atendimento. Três itens são importantes. 'Queixas Principais, Suspeita Dagnóstica e Conduta Médica.");
      $("#box_informa").modal();
      return false;
    }
    if (document.getElementById('embacado').style.display == "block") {
      return false;
    }
    document.getElementById('embacado').style.display = "block";
    $.ajax({
      url: 'action/gravar_atendimento_medico',
      type: 'post',
      dataType: 'html',
      data: {
        'id_atendimentomedico': $("#idAtendimentoMedico").val(),
        'id_paciente': $("#idPaciente").val(),
        'id_fila_espera': $("#idFilaAtendimento").val(),
        'doenca_hipertensao': doencaHipertensao,
        'doenca_diabetes': doencaDiabetes,
        'doenca_coluna': doencaColuna,
        'doenca_artropatia': doencaArtropatia,
        'doenca_cardiovascular': doencaCardiovascular,
        'doenca_ler': doencaLer,
        'doenca_tendinite': doencaTendinite,
        'doenca_abdominal': doencaAbdominal,
        'doenca_avc': doencaAvc,
        'doenca_outras': doencaOutras,
        'habito_alcoolismo': habitoAlcoolismo,
        'habito_sedentarismo': habitoSedentarismo,
        'habito_tabagismo': habitoTabagismo,
        'habito_outros': habitoOutros,
        'queixas_principais': queixasPrincipais,
        'descricao_anamnese': descricaoAnamnese,
        'codigo_cid': codigoCid,
        'nome_cid': nomeCid,
        'conduta_medica': condutaCedica
      }
    }).done(function (data) {
      $("#box_informa_body").html(data);
      $("#box_informa").modal();
      document.getElementById('embacado').style.display = "none";
    });

  }

  if (opcaoAtendimento == "juridico") {

    var questaoJuridico = nicEditors.findEditor('questaoJuridico').getContent();

    if (questaoJuridico == "") {
      $("#box_informa_body").html("Você deve ao menos descrever algo sobre o atendimento jurídico.");
      $("#box_informa").modal();
      return false;
    }
    if (document.getElementById('embacado').style.display == "block") {
      return false;
    }
    document.getElementById('embacado').style.display = "block";
    $.ajax({
      url: 'action/gravar_atendimento_juridico',
      type: 'post',
      dataType: 'html',
      data: {
        'id_atendimentojuridico': $("#idAtendimentoJuridico").val(),
        'id_paciente': $("#idPaciente").val(),
        'id_fila_espera': $("#idFilaAtendimento").val(),
        'questao_juridico': questaoJuridico
      }
    }).done(function (data) {
      $("#box_informa_body").html(data);
      $("#box_informa").modal();
      document.getElementById('embacado').style.display = "none";
    });

  }

}

$("#documentoProcessoArquivo").change(function () {
  var nome_arquivo = this.files[0].name;
  $("#documentoProcessoTexto").val(nome_arquivo);
})

//*função para anexar documento ao  atendimento
function incluirDocumentoLista(opcaoAtendimento) {

  if (opcaoAtendimento == "atendimento_juridico") {

    if ($('#documentoProcessoTexto').val() == "") {
      $("#box_informa_body").html("Você deve anexar o documento a ser incluído na lista");
      $("#box_informa").modal();
      return (false);
    }

    if (document.getElementById('embacado').style.display == "block") {
      return false;
    }
    $("#processandoDados").html("Aguarde! Enviando arquivo...");
    document.getElementById('embacado').style.display = "block";
    var formData = new FormData();
    formData.append('idAtendimentoJuridico', $('#idAtendimentoJuridico').val());
    formData.append('documentoProcessoJuridico', $('#documentoProcessoArquivo')[0].files[0]);
    formData.append('observacaoDocumento', $('#observacaoDocumento').val());

    var urlGravarDocumento = "action/gravar_documentojuridico";
    $.ajax({
      type: 'POST',
      url: urlGravarDocumento,
      data: formData,
      processData: false,
      contentType: false
    }).done(function (data) {
      $("#documentoProcessoTexto").val('');
      $("#observacaoDocumento").val('');
      $("#tbody_dados_documentos").html(data);
      $("#processandoDados").html("Aguarde! Processando dados...");
      document.getElementById('embacado').style.display = "none";
    });
  }

}

//exclusão de arquivos/documentos de uma lista
function excluirArquivo(opcaoExclusao, idRegistroArquivo, nomeArquivo, idFiltroBase) {
  $("#dadosConfirmacao").val(opcaoExclusao + "#" + idRegistroArquivo + "#" + nomeArquivo + "#" + idFiltroBase);
  $("#box_confirmacao_body").html("Confirma exclusão do arquivo " + nomeArquivo + " ?");
  $("#box_confirmacao").modal();
}

//função para excluões de cadastros
function excluirCadastro(opcaoExclusao, idRegistroExcluir, textRegistroExcluir) {
  $("#dadosConfirmacao").val(opcaoExclusao + "#" + idRegistroExcluir + "#" + textRegistroExcluir);
  $("#box_confirmacao_body").html("Confirma " + opcaoExclusao + " " + textRegistroExcluir + " ?");
  $("#box_confirmacao").modal();
}


//função para mover foco para o campo principal do popup de pesquisa
function setFoco(nomCampo) {

  setTimeout(function () { $('#' + nomCampo).focus(); }, 1000);

}

function gerarNovaSenha(opcaoGeraSenha, idSelecionado, nomeSelecionado) {

  //Gerar senha aleatória
  if (opcaoGeraSenha == "nova_senha_aleatoria") {

    $("#processandoDados").html("Aguarde! Gerando nova senha para o acesso...");

    Swal.fire({
      title: "Gerar Nova Senha",
      html: "<p style='text-align:justify'><font style='font-weight: bold; color: #a00404ff;'>ATENÇÃO!</font> Esta ação irá gerar uma senha aleatória de acesso para [<b>" + nomeSelecionado + "</b>] <b>Confirma?</b></p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function (retornoComando) {
      if (retornoComando.value) {
        $.ajax({
          url: 'action/alterar_senha',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoSenha': opcaoGeraSenha,
            'idRegistroAlteracao': idSelecionado
          }
        }).done(function (resultadoRetorno) {
          document.getElementById('embacado').style.display = "none";
          swal("Nova Senha Gerada", resultadoRetorno, "success");
        });
      }
    });

  }

}

//função para sair do sistema / deslogar
function sairSistema() {

  Swal.fire({
    title: "Sair do Sistema?",
    text: "Será necessário informar email e senha novamente. Confirma?",
    type: "question",
    showCancelButton: !0,
    confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
    confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
    cancelButtonText: "<i class='fa fa-times'></i> Não",
    cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
    buttonsStyling: !1,
  }).then(function (retornoComando) {
    if (retornoComando.value) {
      window.location.href = 'sair';
    }
  });

}


//função para listar o histórico de atendimentos
function listarHistoricoAtendimento() {

  var opcaoListarHistorico = $("#opcaoPesquisa").val();


  switch (opcaoListarHistorico) {

    case "radio-cns":

      if ($('#pesquisaCNS').val() == "") {
        $("#box_informa_body").html("Informe o número do cartão SUS que deseja pesquisar!");
        $("#box_informa").modal();
        return false;
      } else {
        var conteudoPesquisa = $('#pesquisaCNS').val();
      }
      break;

    case "radio-cpf":

      if ($('#pesquisaCPF').val() == "") {
        $("#box_informa_body").html("Informe o número do CPF que deseja pesquisar!");
        $("#box_informa").modal();
        return false;
      } else {
        var conteudoPesquisa = $('#pesquisaCPF').val();
      }
      break;

    case "radio-nome":

      if ($('#pesquisaNome').val() == "") {
        $("#box_informa_body").html("Informe o nome ou pelo menos para do nome que deseja pesquisar!");
        $("#box_informa").modal();
        return false;
      } else {
        var conteudoPesquisa = $('#pesquisaNome').val();
      }
      break;

    case "radio-periodo":

      if ($('#historicoDataInicial').val() == "" || $('#historicoDataFinal').val() == "") {
        $("#box_informa_body").html("Você precisa informar data inicial e data final do período que deseja pesquisar!");
        $("#box_informa").modal();
        return false;
      } else {
        var conteudoPesquisa = $('#historicoDataInicial').val() + '#' + $('#historicoDataFinal').val();
      }
      break;
  }
  document.getElementById('embacado').style.display = "block";
  $.ajax({
    url: 'filtros/filtrar_historico_atendimento',
    type: 'post',
    dataType: 'html',
    data: {
      'opcaoListarHistorico': opcaoListarHistorico,
      'conteudoPesquisa': conteudoPesquisa,
      'tipoAtendimento': $("#historicoTipoAtendimento").val()
    }
  }).done(function (data) {
    $('#dados_historico').DataTable().destroy();
    $('#dados_historico tbody').empty().append(data);
    $('#dados_historico').DataTable();
    document.getElementById('embacado').style.display = "none";
  });

}

//função que gerar o contador de pessoas na fila para mostrar no menu
function contadorMenuFila() {

  $.ajax({
    url: 'filtros/filtrar_pendentesfila',
    type: 'post',
    dataType: 'html',
    data: {
      'totalRegistros': "totalRegistros"
    }
  }).done(function (data) {
    $("#contadorFilaMenu").html(data);
  });

  setInterval(function () {
    $.ajax({
      url: 'filtros/filtrar_pendentesfila',
      type: 'post',
      dataType: 'html',
      data: {
        'totalRegistros': "totalRegistros"
      }
    }).done(function (data) {
      $("#contadorFilaMenu").html(data);
    });
  }, 30000);

}

//função para a abrir os relatórios do sistema
function visualizarRelatorio(opcapRelatorio) {
  let dataHoje = new Date();
  var dataInicial = new Date($("#relatorioDataInicial").val());
  var dataFinal = new Date($("#relatorioDataFinal").val());

  if (($("#relatorioDataInicial").val() == "" || $("#relatorioDataFinal").val() == "") && (opcapRelatorio != "pacientesnascimento")) {
    $("#box_informa_body").html("Você deve informar o período completo para análise do relatório.");
    $("#box_informa").modal();
    return false;
  } else if ((dataInicial > dataHoje) && (opcapRelatorio != "pacientesnascimento")) {
    $("#box_informa_body").html("A data inicial não pode ser maior que a data de hoje.");
    $("#box_informa").modal();
    return false;
  } else if ((dataFinal > dataHoje) && (opcapRelatorio != "pacientesnascimento")) {
    $("#box_informa_body").html("A data final não pode ser maior que a data de hoje.");
    $("#box_informa").modal();
    return false;
  } else if ((dataInicial > dataFinal) && (opcapRelatorio != "pacientesnascimento")) {
    $("#box_informa_body").html("A data inicial não pode ser maior que a final.");
    $("#box_informa").modal();
    return false;
  }

  switch (opcapRelatorio) {

    case "atendimentobairro":
      relatorioConsolidado = document.getElementById('relatorio_consolidado').checked ? "S" : "N";
      relatorioBairro = $("#relatorioBairro").val();
      relatorioTipoAtendimento = $("#relatorioTipoAtendimento").val();
      document.getElementById('embacado').style.display = "block";
      $.ajax({
        url: 'relatorios/processa_relatorio',
        type: 'post',
        dataType: 'html',
        data: {
          'opcapRelatorio': 'atendimentobairro',
          'relatorioConsolidado': relatorioConsolidado,
          'relatorioBairro': relatorioBairro,
          'relatorioTipoAtendimento': relatorioTipoAtendimento,
          'relatorioDataInicial': $("#relatorioDataInicial").val(),
          'relatorioDataFinal': $("#relatorioDataFinal").val()
        }
      }).done(function (data) {
        document.getElementById('embacado').style.display = "none";
        window.open('relatorios/atendimentobairro');
      });
      break

    case "atendimentodoenca":
      relatorioConsolidado = document.getElementById('relatorio_consolidado').checked ? "S" : "N";
      relatorioBairro = $("#relatorioBairro").val();
      relatorioTipoDoenca = $("#relatorioTipoDoenca").val();

      if (relatorioTipoDoenca == "") {
        $("#box_informa_body").html("Você deve selecionar um tipo de doença para extrair o relatório.");
        $("#box_informa").modal();
        return false
      }

      document.getElementById('embacado').style.display = "block";
      $.ajax({
        url: 'relatorios/processa_relatorio',
        type: 'post',
        dataType: 'html',
        data: {
          'opcapRelatorio': 'atendimentodoenca',
          'relatorioConsolidado': relatorioConsolidado,
          'relatorioBairro': relatorioBairro,
          'relatorioTipoDoenca': relatorioTipoDoenca,
          'relatorioDataInicial': $("#relatorioDataInicial").val(),
          'relatorioDataFinal': $("#relatorioDataFinal").val()
        }
      }).done(function (data) {
        document.getElementById('embacado').style.display = "none";
        window.open('relatorios/atendimentodoenca');
      });
      break

    case "acientesnascimento":

      if ($("#relatorioMesNascimento").val() == "" && $("#relatorioDataInicial").val() == "" && $("#relatorioDataFinal").val() == "") {
        $("#box_informa_body").html("Você deve informar o período de nascimento ou escolher um mês específico.");
        $("#box_informa").modal();
        return false;
      } else {
        if (dataInicial > dataHoje) {
          $("#box_informa_body").html("A data inicial não pode ser maoir que a data de hoje.");
          $("#box_informa").modal();
          return false;
        } else if (dataFinal > dataHoje) {
          $("#box_informa_body").html("A data final não pode ser maoir que a data de hoje.");
          $("#box_informa").modal();
          return false;
        } else if (dataInicial > dataFinal) {
          $("#box_informa_body").html("A data inicial não pode ser maoir que a final.");
          $("#box_informa").modal();
          return false;
        }
      }

      relatorioMesNascimento = $("#relatorioMesNascimento").val();
      relatorioBairro = $("#relatorioBairro").val();

      document.getElementById('embacado').style.display = "block";
      $.ajax({
        url: 'relatorios/processa_relatorio',
        type: 'post',
        dataType: 'html',
        data: {
          'opcapRelatorio': 'pacientesnascimento',
          'relatorioConsolidado': '',
          'relatorioBairro': relatorioBairro,
          'relatorioDataInicial': $("#relatorioDataInicial").val(),
          'relatorioDataFinal': $("#relatorioDataFinal").val(),
          'relatorioMesNascimento': relatorioMesNascimento
        }
      }).done(function (data) {
        document.getElementById('embacado').style.display = "none";
        window.open('relatorios/nascimentopacientes');
      });
      break
  }

}

function gerarCalendarioAgenda(opcaoCalendario, mesSelecionado, anoSelecionado, procedimSelecionado, informaSedacao = "nulo") {

  if (opcaoCalendario == "criaragenda") {

    if (mesSelecionado != "" && anoSelecionado != "" && procedimSelecionado != "") {
      $.ajax({
        url: 'action/gerar_calendarioagenda',
        type: 'post',
        dataType: 'html',
        data: {
          'mesSelecionado': mesSelecionado,
          'anoSelecionado': anoSelecionado,
          'procedimSelecionado': procedimSelecionado
        }
      }).done(function (data) {
        $("#dvCalendarioAgenda").html(data);
      });
    } else {
      $("#dvCalendarioAgenda").html("");
    }
  }

  if (opcaoCalendario == "agendamento") {

    if (mesSelecionado != "" && anoSelecionado != "" && procedimSelecionado != "") {
      $.ajax({
        url: 'action/gerar_calendarioagendamento',
        type: 'post',
        dataType: 'html',
        data: {
          'mesSelecionado': mesSelecionado,
          'anoSelecionado': anoSelecionado,
          'procedimSelecionado': procedimSelecionado
        }
      }).done(function (data) {
        $("#dvCalendarioAgendamento").html(data);
      });

    } else {
      $("#dvCalendarioAgendamento").html("");
    }
  }

}

function excluirAgenda() {
  var procedimentoAgenda = $("#procedimentoAgenda").val();
  var mesAgenda = $("#mesAgenda").val();
  var anoAgenda = $("#anoAgenda").val();

  if (procedimentoAgenda == "" || mesAgenda == "" || anoAgenda == "") {
    $("#box_informa_body").html("Não existe nenhuma agenda selecionada.");
    $("#box_informa").modal();
    return false;
  }
  $("#dadosConfirmacao").val("excluir_agenda#" + procedimentoAgenda + "#" + mesAgenda + "#" + anoAgenda);
  $("#box_confirmacao_body").html("Confirma exclusão desta agenda ?");
  $("#box_confirmacao").modal();

}

//Função para realizar busca do cadastro do cidadão no ato do agendamento
function buscarAgendamentoPaciente(idPaciente, idAgendamento) {
  $.ajax({
    url: 'filtros/filtrar_agendamentos_paciente',
    type: 'post',
    dataType: 'html',
    data: {
      'idPaciente': idPaciente,
      'idAgendamento': idAgendamento
    }
  }).done(function (resultadoRetorno) {
    $('#dados_agendamento_paciente').DataTable().destroy();
    $('#dados_agendamento_paciente tbody').empty().append(resultadoRetorno);
    $('#dados_agendamento_paciente').DataTable();
    $("#embacado").css('display', 'none');
  });

}

//Função para realizar busca do cadastro do cidadão.
function buscarAgendamento(idAgendamento) {

  if (document.getElementById('progresso_pesquisa').style.display == "block") {
    return false;
  }

  var dataInicial = new Date($("#pesquisaDataInicial").val());
  var dataFinal = new Date($("#pesquisaDataFinal").val());

  if (dataInicial > dataFinal) {
    $("#box_informa_body").html("A data inicial não pode ser maior que a final.");
    $("#box_informa").modal();
    return false;
  }

  if (($("#pesquisaDataInicial").val() != '' && $("#pesquisaDataFinal").val() == '') || ($("#pesquisaDataFinal").val() != '' && $("#pesquisaDataInicial").val() == '') || ($("#pesquisaDataFinal").val() == '' && $("#pesquisaDataInicial").val() == '')) {
    $("#box_informa_body").html("Para usar a opção de período você deve informar tanto a data inicial quanto a data final.");
    $("#box_informa").modal();
    return false;
  }

  document.getElementById('progresso_pesquisa').style.display = "block";

  $.ajax({
    url: 'filtros/filtrar_agendamentos',
    type: 'post',
    dataType: 'html',
    data: {
      'idAgendamento': idAgendamento,
      'pesquisaProcedimento': $("#pesquisaProcedimento").val(),
      'pesquisaDataInicial': $("#pesquisaDataInicial").val(),
      'pesquisaDataFinal': $("#pesquisaDataFinal").val(),
      'pesquisaCNS': $("#pesquisaCNS").val(),
      'pesquisaCPF': $("#pesquisaCPF").val(),
      'pesquisaStatus': $("#pesquisaStatus").val()
    }
  }).done(function (resultadoRetorno) {
    $("#progresso_pesquisa").css("display", "none");
    $('#dados_agendamento').DataTable().destroy();
    $('#dados_agendamento tbody').empty().append(resultadoRetorno);
    $('#dados_agendamento').DataTable();
    $("#box_confirma_atendimento").modal('hide');
  });

}

function abrirCaixaProcura(registro_solicitacao) {
  $("#" + registro_solicitacao).modal();
}


function limparFormulario(idFormulario) {
  $('#' + idFormulario).each(function () {
    this.reset();
  });
  $('#btnCancelar').prop('disabled', true);
}

function ajustarTamanhoCard() {
  var alturaTela = window.innerHeight;
  $("#card-tela").css("height", alturaTela - 160);
}

function setClassTable(idTabelaRecebeClass) {

  var larguraTela = window.screen.width;

  var totalColunasTabela = jQuery("#" + idTabelaRecebeClass + " thead th").length;
  if (larguraTela < 1900) {
    if (totalColunasTabela >= 6) {
      $("#" + idTabelaRecebeClass).addClass("table-responsive-" + larguraTela);
    }
  } else {
    $("#" + idTabelaRecebeClass).addClass("table-responsive-xl");
  }
}


function setConfigDatatables() {
  //Tradução para o datatable
  const DATATABLE_PTBR = {
    "sEmptyTable": "Nenhum registro encontrado",
    "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
    "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
    "sInfoPostFix": "",
    "sInfoThousands": ".",
    "sLengthMenu": "_MENU_ resultados por página",
    "sLoadingRecords": "Carregando...",
    "sProcessing": "Processando...",
    "sZeroRecords": "Nenhum registro encontrado",
    "sSearch": "Pesquisar",
    "oPaginate": {
      "sNext": "Próximo",
      "sPrevious": "Anterior",
      "sFirst": "Primeiro",
      "sLast": "Último"
    },
    "oAria": {
      "sSortAscending": ": Ordenar colunas de forma ascendente",
      "sSortDescending": ": Ordenar colunas de forma descendente"
    },
    "select": {
      "rows": {
        "_": "Selecionado %d linhas",
        "0": "Nenhuma linha selecionada",
        "1": "Selecionado 1 linha"
      }
    }
  }

  $('.listagem-resultado').DataTable({
    "oLanguage": DATATABLE_PTBR,
    "defererRender": true,
    "processing": true,
    "responsive": true,
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false,
    "ordering": false,
    "pagingType": $(window).width() < 768 ? "simple" : "simple_numbers",
  });
}