<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");
include_once("include/funcoes_gsaudereg.php");
?>

<div class="app-content content" style='background-color:#e1e9e7;'>
  <div class="content-wrapper" style='padding:10px;'>
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style='border:gray 1px solid;' id="card-tela">

            <div class="card-header titulo-telas">
              <i class="icofont icofont-ui-note" style='margin-top:-15px !important'></i>&nbsp;Laudo Médico de T.F.D
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>

            <div class="card-content collapse show">
              <div class="card-body">

                <form class="form" style='margin-top:-10px'>
                  <div class="form-body">

                    <h4 class="form-section">
                      <i class="icofont icofont-edit"></i><b>Informações do Laudo Médico de Tratamento Fora do Domicílio</b>
                      <input type="hidden" id="idLaudoTfd" />
                    </h4>

                    <!-- PACIENTE -->
                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-9">
                        <div class="form-group">
                          <label for="pacienteNome">Nome do Paciente:</label>
                          <input type="text" id="pacienteNome" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="pacienteDocIdent">Doc. Ident:</label>
                          <input type="text" id="pacienteDocIdent" class="form-control" />
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="pacienteResidencia">Residência:</label>
                          <input type="text" id="pacienteResidencia" class="form-control" />
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="pacienteTelefone">Telefone:</label>
                          <input type="text" id="pacienteTelefone" class="form-control text-center" />
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="pacienteOcupacao">Ocupação:</label>
                          <input type="text" id="pacienteOcupacao" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="pacienteDataNascimento">Data de Nascimento:</label>
                          <input type="date" id="pacienteDataNascimento" class="form-control text-center" />
                        </div>
                      </div>
                    </div>

                    <!-- ACOMPANHANTE -->
                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-9">
                        <div class="form-group">
                          <label for="acompanhanteNome">Nome do Acompanhante:</label>
                          <input type="text" id="acompanhanteNome" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="acompanhanteDocIdent">Doc. Ident:</label>
                          <input type="text" id="acompanhanteDocIdent" class="form-control" />
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="acompanhanteResidencia">Residência:</label>
                          <input type="text" id="acompanhanteResidencia" class="form-control" />
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="acompanhanteTelefone">Telefone:</label>
                          <input type="text" id="acompanhanteTelefone" class="form-control text-center" />
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="acompanhanteParentesco">Parentesco:</label>
                          <input type="text" id="acompanhanteParentesco" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="acompanhanteDataNascimento">Data de Nascimento:</label>
                          <input type="date" id="acompanhanteDataNascimento" class="form-control text-center" />
                        </div>
                      </div>
                    </div>

                    <!-- ITENS DO LAUDO -->
                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="historicoDoencaAtual">1 – Histórico da Doença atual:</label>
                          <textarea id="historicoDoencaAtual" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="examesFisicos">2 – Exames Físicos:</label>
                          <textarea id="examesFisicos" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-9">
                        <div class="form-group">
                          <label for="diagnosticoProvavel">3 – Diagnóstico provável:</label>
                          <input type="text" id="diagnosticoProvavel" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="diagnosticoCid">CID:</label>
                          <input type="text" id="diagnosticoCid" class="form-control text-center" />
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="examesComplementares">4 – Exames Complementares realizados (Anexar Cópias):</label>
                          <textarea id="examesComplementares" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="tratamentosRealizados">5 – Tratamento(s) Realizado(s):</label>
                          <textarea id="tratamentosRealizados" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="tratamentosIndicados">6 – Tratamento/Exames Indicados:</label>
                          <textarea id="tratamentosIndicados" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="duracaoTratamento">7 – Duração Provável do tratamento:</label>
                          <input type="text" id="duracaoTratamento" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="duracaoPaciente">Paciente:</label>
                          <select id="duracaoPaciente" class="form-control">
                            <option value="">SELECIONE...</option>
                            <option value="S">SIM</option>
                            <option value="N">NÃO</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="duracaoAcompanhante">Acompanhante:</label>
                          <select id="duracaoAcompanhante" class="form-control">
                            <option value="">SELECIONE...</option>
                            <option value="S">SIM</option>
                            <option value="N">NÃO</option>
                          </select>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="anexoPedido">Anexo ao Pedido:</label>
                          <input type="file" id="anexoPedido" class="form-control" multiple />
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="justificativaImpossibilidade">8 – Justificar as razões que impossibilitam a realização do tratamento/exame no município:</label>
                          <textarea id="justificativaImpossibilidade" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="justificativaUrgencia">9 – Justificar em caso de necessidade de encaminhamento urgente:</label>
                          <textarea id="justificativaUrgencia" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="justificativaAcompanhante">10 – Justificar em caso de necessidade de acompanhante:</label>
                          <textarea id="justificativaAcompanhante" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="transporteRecomendavel">11 – Transporte Recomendável (justificar):</label>
                          <textarea id="transporteRecomendavel" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="outrasAnotacoes">12 – Outras Anotações:</label>
                          <textarea id="outrasAnotacoes" class="form-control" rows="3"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="obidosDataMedico">Óbidos (data):</label>
                          <input type="date" id="obidosDataMedico" class="form-control text-center" />
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="medicoAssistente">Médico – Assistente:</label>
                          <input type="text" id="medicoAssistente" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="juntaMedicaCrm">Junta Médica – Carimbo CRM:</label>
                          <input type="text" id="juntaMedicaCrm" class="form-control text-center" />
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="parecerDivisao">13 – Parecer de Divisão/Serviço local de Medicina Social/Serv. de Med. Social:</label>
                          <textarea id="parecerDivisao" class="form-control" rows="4"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="obidosDataParecer">Óbidos (data):</label>
                          <input type="date" id="obidosDataParecer" class="form-control text-center" />
                        </div>
                      </div>
                      <div class="col-md-8">
                        <div class="form-group">
                          <label for="assinaturaMatricula">Assinatura/Carimbo/Matrícula:</label>
                          <input type="text" id="assinaturaMatricula" class="form-control" />
                        </div>
                      </div>
                    </div>

                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <button type="button" class="btn btn-success" id="btnSalvarLaudoTfd" style="width:120px" onClick="salvarLaudoTfd()">
                            <i class="icofont icofont-checked"></i> Confirmar
                          </button>
                          <button type="button" class="btn btn-danger" id="btnCancelarLaudoTfd" style="width:120px" disabled>
                            <i class="fa fa-times"></i> Cancelar
                          </button>
                        </div>
                      </div>
                    </div>

                  </div>
                  <div class="form-actions" style="margin-top:-15px !important"></div>
                </form>

              </div>
            </div>

          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  // Máscaras (mantendo o mesmo padrão do seu arquivo original)
  $(document).ready(function() {
    try {
      $("#pacienteTelefone").inputmask("(99) 99999-9999");
      $("#acompanhanteTelefone").inputmask("(99) 99999-9999");
      $("#diagnosticoCid").inputmask("A99.9", { placeholder: " " }); // formato genérico para CID
    } catch (e) {
      // se inputmask não estiver disponível por algum motivo, não quebra a tela
      console.log(e);
    }
  });

  function salvarLaudoTfd() {
    // TODO: implemente seu AJAX aqui no mesmo padrão das suas telas (ex.: $.ajax(...))
    swal("Salvar Laudo", "Função salvarLaudoTfd() ainda não foi implementada.", "info");
  }
</script>
