<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");
$dataHoje = date("Y-m-d");
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
  <div class="content-wrapper" style='padding:10px;'>
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style='border:gray 1px solid;' id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-brand-whatsapp" style='margin-top:-15px !important'></i>&nbsp;Registro de Comunicação de Agendamentos
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body" style="border-top:1px dotted gray; margin-top:-5px">
                    <h4 class="form-section">
                      <i class="ft-list"></i> <b>Lista de agendamentos cadastrados</b>
                      <button type="button" class="btn btn-green" onClick="filtrarAgendamentos()" style='margin-left:15px'>
                        <i class="icofont icofont-download-alt"></i> Atualizar Lista
                      </button>
                    </h4>
                </form>
              </div>
            </div>
            <div class="card-content collapse show" style="margin-top:-60px !important">
              <div class="card-body card-dashboard">
                <table class="table table-striped table-bordered default-ordering" id='dados_agendamentos'>
                  <thead>

                    <th style='text-align:center' width='100px'>&nbsp;OPÇÕES&nbsp;</th>
                    <th style='text-align:center' width='100px'>PRAZO DE RETIRADA</th>
                    <th>NOME DO PACIENTE</th>
                    <th style='text-align:center' width='100px'>CNS DO PACIENTE</th>
                    </tr>
                  </thead>
                  <tbody style="background-color:#ececec">
                    <?php
                    $htmlRetorno = "";
                    # -- pegar agendamentos da fila -- #
                    $sqlSolicitacao  = "SELECT reg_tb_solicitacoes.id_paciente, reg_tb_solicitacoes.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente 
																FROM reg_tb_solicitacoes INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente=tb_paciente.id_paciente)
																INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento) 
																WHERE id_statussolicitacao='3' 
																AND em_comunicacao='N' 
																AND encaminhado_ligacao='N' 
																AND dataprazo_retirada>='$dataHoje' 
																AND status_comunicacao is null
																GROUP BY tb_paciente.nome_paciente, reg_tb_solicitacoes.dataprazo_retirada, tb_paciente.cns_paciente ORDER BY dataprazo_retirada, nome_paciente";
                    $stmSolicitacao    = $rsConexao->prepare($sqlSolicitacao);
                    $stmSolicitacao->execute();
                    $rsSolicitacao      = $stmSolicitacao->fetchAll(PDO::FETCH_ASSOC);

                    if ($stmSolicitacao->rowCount() > 0) {
                      foreach ($rsSolicitacao as $fieldSolicitacao) {
                        $idPaciente        = $fieldSolicitacao['id_paciente'];
                        $dataRetirada      = $fieldSolicitacao['dataRetirada'];
                        $nomePaciente      = $fieldSolicitacao['nome_paciente'];
                        $cnsPaciente      = $fieldSolicitacao['cns_paciente'];
                        $dataretiradaEnc  = $fieldSolicitacao['dataprazo_retirada'];

                        $atualizarRegistrosComunicacao  = '"atualizarRegistrosComunicacao(' . "'$idPaciente','$dataretiradaEnc')" . '"';
                        $linkRegistrarComunicaco        = '"window.open(' . "'registracomunicacao?idp=$idPaciente&opc=wp')" . '"';
                        $htmlRetorno .= "<tr>
																			<td style='text-align:center'>
																			<i class='icofont icofont-ui-contact-list nova_fonte_blue' title='Encaminhar para tela de ligações.' onclick=$atualizarRegistrosComunicacao></i>&nbsp;
																				<i class='icofont icofont-social-whatsapp nova_fonte' title='Registrar contrato com o paciente.' onclick=$linkRegistrarComunicaco></i>&nbsp;
																			</td>
																			<td style='text-align:center'>$dataRetirada</td>
																			<td>$nomePaciente</td>
																			<td style='text-align:center'>$cnsPaciente</td>
																		</tr>";
                      }
                    }

                    # -- pegar agendamentos avulso -- #
                    $sqlSolicitacao  = "SELECT reg_tb_agendamentos.id_paciente, reg_tb_agendamentos.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente 
																FROM reg_tb_agendamentos INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente)
																INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) 
																WHERE status_agendamento='A'
																AND origem_agendamento!='S-FG' 
																AND em_comunicacao='N'
																AND encaminhado_ligacao='N' 
																AND dataprazo_retirada>='$dataHoje' 
																AND status_comunicacao is null
																GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.dataprazo_retirada, tb_paciente.cns_paciente 
																ORDER BY dataprazo_retirada, nome_paciente";
                    $stmSolicitacao    = $rsConexao->prepare($sqlSolicitacao);
                    $stmSolicitacao->execute();
                    $rsSolicitacao      = $stmSolicitacao->fetchAll(PDO::FETCH_ASSOC);

                    if ($stmSolicitacao->rowCount() > 0) {
                      foreach ($rsSolicitacao as $fieldSolicitacao) {
                        $idPaciente        = $fieldSolicitacao['id_paciente'];
                        $dataRetirada      = $fieldSolicitacao['dataRetirada'];
                        $nomePaciente      = $fieldSolicitacao['nome_paciente'];
                        $cnsPaciente      = $fieldSolicitacao['cns_paciente'];
                        $dataretiradaEnc  = $fieldSolicitacao['dataprazo_retirada'];

                        $atualizarRegistrosComunicacao  = '"atualizarRegistrosComunicacao(' . "'$idPaciente','$dataretiradaEnc')" . '"';
                        $linkRegistrarComunicaco        = '"window.open(' . "'registracomunicacao?idp=$idPaciente&opc=wp')" . '"';
                        $htmlRetorno .= "<tr>
																			<td style='text-align:center'>
																			<i class='icofont icofont-ui-contact-list nova_fonte_blue' title='Encaminhar para tela de ligações.' onclick=$atualizarRegistrosComunicacao></i>&nbsp;
																				<i class='icofont icofont-social-whatsapp nova_fonte' title='Registrar contrato com o paciente.' onclick=$linkRegistrarComunicaco></i>&nbsp;
																			</td>
																			<td style='text-align:center'>$dataRetirada</td>
																			<td>$nomePaciente</td>
																			<td style='text-align:center'>$cnsPaciente</td>
																		</tr>";
                      }
                    }
                    echo $htmlRetorno;
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </section>
  </div>
</div>

<?php
include_once("footer.php");
include_once("include/box_regitra_comunicacao.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liRegistroComunicacao").attr('class', 'active');
  $("#liRegistroComunicacao").css("border-bottom", "2px solid #c4c8ca");

  $('#dados_agendamentos').DataTable({
    "ordering": false
  });

  /***********************************/
  function filtrarAgendamentos() {
    $("#embacado").css("display", "block");
    $.ajax({
      url: 'filtros/filtrar_solicitacoes',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoBusca': "comunicacao-pacientes-whatsapp"
      }
    }).done(function(resultadoRetorno) {
      $('#dados_agendamentos').DataTable().destroy();
      $('#dados_agendamentos tbody').empty().append(resultadoRetorno);
      $('#dados_agendamentos').DataTable();
      $("#embacado").css("display", "none");
    });

  }
  setInterval(function() {
    filtrarAgendamentos()
  }, 65000);
  /***********************************/

  /* atualizar status do agendamento*/
  function atualizarStatus(idAgendamento, valorStatus) {

    $.ajax({
      url: 'action/gravar_atualizacaostatus',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoAtualizacao': 'status-comunicacao',
        'idAgendamento': idAgendamento,
        'valorStatus': valorStatus
      }
    }).done(function(resultadoRetorno) {});

  }


  function atualizarRegistrosComunicacao(idPaciente, dataRetirada) {

    Swal.fire({
      title: "Encaminhamento",
      html: "<p style='text-align:justify'><font style='font-weight: bold; color: #a00404ff;'>ATENÇÃO!</font> O registro será encaminhado para a tela de ligações telefônicas. <b>Confirma?</b></p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $.ajax({
          url: 'action/gravar_solicitacao',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoGravacao': 'atualizacao-comunicacao-ligacoes',
            'idPaciente': idPaciente,
            'dataRetirada': dataRetirada,
            'idSolicitacao': null
          }
        }).done(function(resultadoRetorno) {
          filtrarAgendamentos();
          swal("Encaminhamento", "Registro encaminhado para tela de ligações telefônicas.", "success");
        });
      }
    });

  }
</script>