<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");

$dataHoje = date("Y-m-d");

$formatarOrigem = array(
	'lista_unica' => 'LISTA ÚNICA',
	'POLICLÍNICA' => 'POLICLÍNICA',
	'SISREG' => 'SISREG',
	'sistema_vida' => 'VIDA+',
);

?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-list" style='margin-top:-15px !important'></i>&nbsp;Lsitar Pacientes Contactados
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-10px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering table-responsive-xl2" id='dados_agendamentos'>
									<thead>

										<th style='text-align:center' width='60px'>&nbsp;OPÇÕES&nbsp;</th>
										<th style='text-align:center' width='100px'>Nº PROTOCOLO</th>
										<th style='text-align:center' width='100px'>PRAZO DE RETIRADA</th>
										<th>NOME DO PACIENTE</th>
										<th style='text-align:center' width='100px'>CNS DO PACIENTE</th>
										<th>PROCEDIMENTO</th>
										<th style='text-align:center' width='80px'>ORIGEM</th>
										<th>OBSERVAÇÕES</th>
										<th width='80px'>OPERADOR</th>
										</tr>
									</thead>
									<tbody style="background-color:#ececec">
										<?php

										if ($_SESSION['idPerfilLogado'] == '1') {
											$whereSQL = " WHERE status_comunicacao='Confirmado' AND encaminhado_ligacao='N' AND meio_comunicacao='whatsapp'";
										} else {
											$whereSQL = " WHERE status_comunicacao='Confirmado' AND idusuario_comunicacao='" . $_SESSION['idUsuarioLogado'] . "' AND encaminhado_ligacao='N' AND meio_comunicacao='whatsapp'";
										}
										$sqlSolicitacao	= "SELECT reg_tb_solicitacoes.id_solicitacao, reg_tb_solicitacoes.numero_procotolo, reg_tb_solicitacoes.id_paciente, 
																reg_tb_solicitacoes.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, 
																tb_paciente.nome_paciente, tb_paciente.cns_paciente, reg_tb_solicitacoes.status_agendamento, reg_tb_procedimento.nome_procedimento, 
																reg_tb_solicitacoes.origem_agendamento, reg_tb_solicitacoes.observacoes_comunicacao, reg_tb_usuario.nome_usuario AS operadorConfirmou FROM reg_tb_solicitacoes INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente=tb_paciente.id_paciente) 
																INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento) 
																LEFT OUTER JOIN  reg_tb_usuario ON (reg_tb_solicitacoes.idusuario_comunicacao=reg_tb_usuario.id_usuario)
																$whereSQL 
																GROUP BY tb_paciente.nome_paciente, reg_tb_solicitacoes.dataprazo_retirada, tb_paciente.cns_paciente 
																ORDER BY dataprazo_retirada, nome_paciente";

										$stmSolicitacao	= $rsConexao->prepare($sqlSolicitacao);
										$stmSolicitacao->execute();
										$rsSolicitacao	= $stmSolicitacao->fetchAll(PDO::FETCH_ASSOC);

										if ($stmSolicitacao->rowCount() > 0) {
											$contadorOrdemData		= 0;
											foreach ($rsSolicitacao as $fieldSolicitacao) {
												$contadorOrdemData	= $contadorOrdemData + 1;
												$idSolicitacao    	= $fieldSolicitacao['id_solicitacao'];
												$idPaciente					= $fieldSolicitacao['id_paciente'];
												$numeroProtocolo		= $fieldSolicitacao['numero_procotolo'];
												$dataRetirada				= $fieldSolicitacao['dataRetirada'];
												$nomePaciente				= $fieldSolicitacao['nome_paciente'];
												$cnsPaciente				= $fieldSolicitacao['cns_paciente'];
												$nomeProcedimento 	= $fieldSolicitacao['nome_procedimento'];
												$dataretiradaEnc  	= $fieldSolicitacao['dataprazo_retirada'];
												$origemAgendamento	= $formatarOrigem[$fieldSolicitacao['origem_agendamento']];
												$obsSoliciacao			= mb_strtoupper($fieldSolicitacao['observacoes_comunicacao']);
												$statusAgengamentoX = mb_strtoupper($fieldSolicitacao['status_agendamento']);
												$operadorConfirmou	= mb_strtoupper($fieldSolicitacao['operadorConfirmou']);

												if ($dataHoje > $dataretiradaEnc && $obsSoliciacao == "") {
													$obsSoliciacao	= "PRAZO VENCIDO PARA RETIRADA, OU SEM OBSERVAÇÃO";
												} else {
													$obsSoliciacao = $obsSoliciacao;
												}

												$encaminharParaLigacao	= '"encaminharParaLigacao(' . "'$idSolicitacao')" . '"';

												echo "<tr style='font-size:9pt !important'>
																			<td style='text-align:center'>
																				<i class='icofont icofont-ui-contact-list nova_fonte_blue' title='Encaminhar para tela de ligações.' onclick=$encaminharParaLigacao></i>&nbsp;
																			</td>
																			<td style='text-align:center'>$numeroProtocolo</td>
																			<td style='text-align:center'><font style='font-size:0.1px'>$contadorOrdemData</font>$dataRetirada</td>
																			<td>$nomePaciente</td>
																			<td style='text-align:center'>$cnsPaciente</td>
																			<td>$nomeProcedimento</td>
																			<td>$origemAgendamento</td>
																			<td>$obsSoliciacao</td>
																			<td>$operadorConfirmou</td>
																		</tr>";
											}
										}
										?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
include_once("include/box_regitra_ligacao.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liRegistroContactados").attr('class', 'active');
	$("#liRegistroContactados").css("border-bottom", "2px solid #c4c8ca");

	/***********************************/
	function filtrarAgendamentos() {
		$.ajax({
			url: 'filtros/filtrar_agendamentos',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoListagem': "comunicacao-pacientes-confirmados"
			}
		}).done(function(resultadoRetorno) {
			$('#dados_agendamentos').DataTable().destroy();
			$('#dados_agendamentos tbody').empty().append(resultadoRetorno);
			$('#dados_agendamentos').DataTable();
			$("#embacado").css("display", "none");
			swal("Encaminhamento", "Agendamento encaminhado para tela de ligações telefônicas.", "success");
		});

	}
	/***********************************/
	function encaminharParaLigacao(idAgendamento) {

    Swal.fire({
      title: "Encaminhamento",
      html: "<p style='text-align:justify'><font style='font-weight: bold; color: #a00404ff;'>ATENÇÃO!</font> O registro será encaminhado para a tela de ligações telefônicas. <b>Confirma?</b></p>",      
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
				$.ajax({
					url: 'action/atualizar_comunicacao',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoAtualizacao': 'atualizacao-comunicacao-confirmado-ligacoes',
						'idAgendamento': idAgendamento
					}
				}).done(function(resultadoRetorno) {
					swal("Encaminhamento", "Registro encaminhado para tela de ligações telefônicas.", "success");
					setTimeout(function() {
						location.reload();
					}, 2000);
				});
      }
    });
	}
</script>