<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado']) || ($_SESSION['idPerfilLogado'] != 20 && $_SESSION['idPerfilLogado'] != 1)) {
  header("location: ./");
}
include_once("header-clean.php");
$dataHoje   = date("Y-m-d");
$idPaciente     = $_GET['idp'];
$idSolicitacao  = $_GET['ids'];

$sqlOciPaciente = "SELECT tb_paciente.id_paciente,
tb_paciente.nome_paciente,
timestampdiff(year,tb_paciente.datanasc,curdate()) AS idadePaciente,
tb_paciente.sexo,
tb_paciente.cpf_paciente,
tb_paciente.cns_paciente,
tb_paciente.celular1,
tb_paciente.celular2,
tb_paciente.celular3,
reg_tb_solicitacoes.id_solicitacao,
reg_tb_solicitacoes.id_statussolicitacao,
reg_tb_solicitacoes.id_grupo_procedimento,
reg_tb_solicitacoes.id_procedimento,
ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
reg_tb_procedimento.codigo_sus,
tb_profissional.cpf_profissional,
tb_profissional.nome_profissional,
tb_estabelecimento.nfantasia_estabelecimento,
reg_tb_solicitacoes.cid_solicitacao,
rl_cid.descricao_cid,
date_format(reg_tb_solicitacoes.datahora_cadastro,'%d/%m/%Y %H:%i') dataHoraSolicitacao,
date_format(reg_tb_solicitacoes.data_atendimento,'%d/%m/%Y') As dataAtendimento,
reg_tb_solicitacoes.data_atendimento AS dataRecerenciaAtendimento,
reg_tb_solicitacoes.observacoes_solicitacao,
reg_tb_solicitacoes.observacao_agendamento_oci,
reg_tb_solicitacoes.numeroini_solicitante,
reg_tb_solicitacoes.nomeequipe_solicitante
FROM reg_tb_solicitacoes
INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente = tb_paciente.id_paciente)
INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento)
INNER JOIN tb_estabelecimento ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_solicitacoes.id_unidade_cadastrou)
LEFT OUTER JOIN tb_profissional ON (tb_profissional.codigoprofissional_cnes = reg_tb_solicitacoes.codigoprofissional_cnes)
LEFT OUTER JOIN rl_cid ON (rl_cid.codigo_cid = reg_tb_solicitacoes.cid_solicitacao)
WHERE (reg_tb_solicitacoes.id_solicitacao='$idSolicitacao')";

$stmPaciente  =  $rsConexao->prepare($sqlOciPaciente);
$stmPaciente->execute();
$rsPaciente     = $stmPaciente->fetch(PDO::FETCH_OBJ);
$nomePaciente   = $rsPaciente->nome_paciente;
$idadePaciente  = $rsPaciente->idadePaciente;
$sexoPaciente   = $rsPaciente->sexo == "F" ? "FEMININO" : "MASCULINO";
$cpfPaciente    = $rsPaciente->cpf_paciente;
$cnsPaciente    = $rsPaciente->cns_paciente;
$telefonePaciente1 = $rsPaciente->celular1;
$telefonePaciente2 = $rsPaciente->celular2;
$telefonePaciente3 = $rsPaciente->celular3;
$nomeProcedimento = $rsPaciente->codigo_sus . ' - ' . $rsPaciente->nomeProcedimento;
$profissionalSolicitante = $rsPaciente->nome_profissional!="" ? rtrim($rsPaciente->nome_profissional) . " - CPF: " . $rsPaciente->cpf_profissional : "PROFISSIONAL NÃO LISTADO (OU SOLICITAÇÃO EXTERNA)";
$unidadeSolicitante = $rsPaciente->nfantasia_estabelecimento;
$cidSolicitacao = $rsPaciente->descricao_cid != "" ? $rsPaciente->cid_solicitacao . ' - ' . $rsPaciente->descricao_cid : " NÃO INFORMADO";
$dataHoraSolicitacao  = $rsPaciente->dataHoraSolicitacao;
$idProcedimentoOCI  = $rsPaciente->id_procedimento;
$observacaoJustificativaSolicitacao = $rsPaciente->observacoes_solicitacao;
$observacaoAgendamentoOCI = $rsPaciente->observacao_agendamento_oci;
$nomeEquipeESF = $rsPaciente->numeroini_solicitante != "" ? $rsPaciente->numeroini_solicitante . ' - ' . $rsPaciente->nomeequipe_solicitante : $rsPaciente->nomeequipe_solicitante;
$dataRecerenciaAtendimento = $rsPaciente->dataRecerenciaAtendimento;
$dataAtendimento = $rsPaciente->dataAtendimento;
# --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --#

# ----Definição da mensagem de início do ciclo da OCI #
if ($rsPaciente->id_statussolicitacao == 2) {
  $cicloCuidadoCuidado = "Ciclo do cuidado não iniciado";
} else if ($rsPaciente->id_statussolicitacao == 5) {
  $cicloCuidadoCuidado = "Solicitação de OCI cancelada";
} else {
  # -- calcular prazo para faturar -- #
  $dataCalculoPrazo = new DateTime("$dataRecerenciaAtendimento");
  $explodeDataReferencia = explode("-", $dataRecerenciaAtendimento);
  $mesAtendimento = $explodeDataReferencia[1];
  $anoAtendimento = $explodeDataReferencia[0];
  $ultimoDiaMesAtendimento   = new DateTime("last day of $anoAtendimento-$mesAtendimento");
  $diferencaDias  = $dataCalculoPrazo->diff($ultimoDiaMesAtendimento);
  $diasRestantes  = (int)$diferencaDias->days;
  $dataLimiteMesSeguinte = (clone $ultimoDiaMesAtendimento)->modify('+29 days');
  $dataFaturarLimite     = $dataLimiteMesSeguinte->format('d/m/Y');
  # -- --------------------------- -- #
  if ($dataRecerenciaAtendimento <= date('Y-m-d') && $dataAtendimento != '') {
    $textoCiclo = "Ciclo do cuidado iniciado em: $dataAtendimento; Concluir até $dataFaturarLimite para faturar.";
  } else {
    $textoCiclo = "Ciclo do cuidado a iniciar em: $dataAtendimento; Concluir até $dataFaturarLimite para faturar.";
  }
  $cicloCuidadoCuidado = "$textoCiclo";
}


# -- Verificar se a OCI já foi iniciar com atendimento
$sqlOCIIniciada = "SELECT id_agendamento_oci FROM reg_tb_agendamentos_oci 
WHERE (id_paciente='$idPaciente') AND (id_solicitacao='$idSolicitacao') AND (id_procedimento_oci='$idProcedimentoOCI')";
$stmOCIIniciada = $rsConexao->prepare($sqlOCIIniciada);
$stmOCIIniciada->execute();
if ($stmOCIIniciada->rowCount() > 0) {
  $ociJaIniciada = "S";
} else {
  $ociJaIniciada = "N";
}

?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-nurse-alt" style='margin-top:-15px !important'></i>&nbsp;NGC - Acompanhar andamento do cuidado
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section" style='margin-top:-10px'>
                      <i class="ft-user"></i>
                      <b>Dados do Paciente e Solicitação</b>
                    </h4>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="nomePaciente">Nome do Paciente:</label>
                          <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="idadePaciente">Idade:</label>
                          <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="sexoPaciente">Sexo:</label>
                          <input type="text" id="sexoPaciente" class="form-control text-center" value="<?php echo $sexoPaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="cpfPaciente">CPF:</label>
                          <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="cnsPaciente">CNS:</label>
                          <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente; ?>" disabled />
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="telefonePaciente1">Telefone 1:</label>
                          <input type="text" id="telefonePaciente1" class="form-control text-center fonecelular-inputmask" value="<?php echo $telefonePaciente1; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="telefonePaciente2">Telefone 2:</label>
                          <input type="text" id="telefonePaciente1" class="form-control text-center fonecelular-inputmask" value="<?php echo $telefonePaciente2; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="telefonePaciente3">Telefone 2:</label>
                          <input type="text" id="telefonePaciente1" class="form-control text-center fonecelular-inputmask" value="<?php echo $telefonePaciente3; ?>" disabled />
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="ociSolicitada">OCI Solicitada:</label>
                          <input type="text" id="ociSolicitada" class="form-control form-control-novodisabled" value="<?php echo $nomeProcedimento; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="dataSolicitacao">Data da Solicitação:</label>
                          <input type="text" id="dataSolicitacao" class="form-control form-control-novodisabled" value="<?php echo $dataHoraSolicitacao; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="cidSolicitacao">CID da Solicitacao:</label>
                          <input type="text" id="cidSolicitacao" class="form-control form-control-novodisabled" value="<?php echo $cidSolicitacao; ?>" disabled />
                        </div>
                      </div>
                    </div>
                    <div class="row" style='margin-top:-15px'>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="profissionalSolicitante">Profissional Solicitante:</label>
                          <input type="text" id="profissionalSolicitante" class="form-control form-control-novodisabled" value="<?php echo $profissionalSolicitante; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="unidadeSolicitante">Unidade Solicitante:</label>
                          <input type="text" id="unidadeSolicitante" class="form-control form-control-novodisabled" value="<?php echo $unidadeSolicitante; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="unidadeSolicitante">Equipe (<b>se veio do PEC</b>):</label>
                          <input type="text" id="unidadeSolicitante" class="form-control form-control-novodisabled" value="<?php echo $nomeEquipeESF; ?>" disabled />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row" style='margin-top:-15px'>
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="observacaoJustificativaSolicitacao">Observação/Justificativa da Solicitação:</label>
                        <input type="text" id="cidSolicitacao" class="form-control" value="<?php echo $observacaoJustificativaSolicitacao; ?>" disabled />
                      </div>
                    </div>
                  </div>
                  <div class="row" style='margin-top:-15px'>
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="diasParaFaturar">Informações sobre início e conclusão para faturamento:</label>
                        <input type="text" id="diasParaFaturar" class="form-control form-control-novodisabled" style='background-color: #bff3b8  !important; color:black' value="<?php echo $cicloCuidadoCuidado; ?>" disabled />
                      </div>
                    </div>
                  </div>
                  <div class="row" style='margin-top:-25px'>
                    <div class="col-md-12">
                      <div class="form-group" style='padding-top:11px'>
                        <div class="bs-callout-danger callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                          <div class="media align-items-stretch">
                            <div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
                              <i class="icofont icofont-info-circle white font-medium-5"></i>
                            </div>
                            <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                              <b>Atenção!</b><br>Após o primeiro agendamento, o sistema calculará os dias restantes para conclusão da linha de cuidado e faturamento.
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <hr style='margin-top:-10px'>
                  <div class="row" style="margin-top:-15px;">
                    <div class="col-md-12">
                      <div class="form-group">
                        <input type="hidden" id="idUsuarioPerfil" class="form-control" disabled />
                        <table class="table table-striped table-bordered default-ordering" id="dados_paciente_oci" style="font-size: 9pt !important;">
                          <thead>
                            <tr style="background-repeat: repeat-x; height: 30px !important;">
                              <th style="text-align: center; width:5%">AGENDAR</th>
                              <th style='width:45%'>PROCEDIMENTO ASSOCIADO À OCI</th>
                              <th style='width:10% !important'>STATUS</th>
                              <th style='width:10% !important; text-align:center'>DATA ATENDIMENTO</th>
                              <th style='width:5%'>RESULTADO EXAME</th>
                              <th style='width:10% !important'>DATA DA MOVIMENTAÇÃO</th>
                            </tr>
                          </thead>
                          <tbody style="background-color: #f6f6f6;">
                            <?php
                            if ($ociJaIniciada == "S") {
                              $sqlProcedimentosOCI = "SELECT reg_tb_agendamentos_oci.id_agendamento_oci,
                                reg_tb_agendamentos_oci.id_registro_agendamento,
                                reg_tb_procedimento.id_grupo_procedimento,
                                reg_tb_procedimento.codigo_sus,
                                left(reg_tb_procedimento.codigo_sus,4) AS inicioCodigoSUS,
                                ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
                                reg_tb_agendamentos_oci.status_agendamento,
                                date_format(reg_tb_agendamentos_oci.data_atendimento,'%d/%m/%Y') AS dataAtendimento,
                                reg_tb_agendamentos_oci.resultado_exame,
                                reg_tb_agendamentos_oci.data_primeiro_agendamento,
                                date_format(reg_tb_agendamentos_oci.data_agendou,'%d/%m/%Y') AS dataMovimentacao,
                                reg_tb_agendamentos_oci.id_procedimento_associado,
                                reg_tb_agendamentos_oci.id_procedimento_oci,
                                reg_tb_agendamentos_oci.resultado_exame
                                FROM reg_tb_agendamentos_oci
                                INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos_oci.id_procedimento_associado = reg_tb_procedimento.id_procedimento)
                                WHERE (id_paciente='$idPaciente') AND (id_solicitacao='$idSolicitacao') AND (id_procedimento_oci='$idProcedimentoOCI')
                                ORDER BY reg_tb_agendamentos_oci.id_procedimento_associado";
                            } else {
                              $sqlProcedimentosOCI = "SELECT reg_tb_procedimentos_oci.id_procedimento_associado,
                                '' AS id_registro_agendamento,
                                reg_tb_procedimentos_oci.id_procedimento_oci,
                                reg_tb_procedimento.id_grupo_procedimento,
                                reg_tb_procedimento.codigo_sus,
                                left(reg_tb_procedimento.codigo_sus,4) AS inicioCodigoSUS,
                                ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
                                '' AS dataAtendimento,
                                '' AS dataMovimentacao,
                                '' AS status_agendamento,
                                '' AS resultado_exame
                                FROM reg_tb_procedimento
                                INNER JOIN reg_tb_procedimentos_oci ON (reg_tb_procedimento.id_procedimento = reg_tb_procedimentos_oci.id_procedimento_associado)
                                WHERE (reg_tb_procedimentos_oci.id_procedimento_oci='$idProcedimentoOCI')
                                ORDER BY reg_tb_procedimentos_oci.id_procedimento_associado";
                            }
                            $stmProcedimentos = $rsConexao->prepare($sqlProcedimentosOCI);
                            $stmProcedimentos->execute();
                            $rsProcedimentos = $stmProcedimentos->fetchAll(PDO::FETCH_ASSOC);

                            $linhaRegistro = 0;
                            foreach ($rsProcedimentos as $fieldProcedimento) {
                              $linhaRegistro            = $ociJaIniciada == "S" ? $linhaRegistro = $fieldProcedimento['id_agendamento_oci'] : $linhaRegistro + 1;
                              $idProcedimentoAssociado  = $fieldProcedimento['id_procedimento_associado'];
                              $idGrupoAssociado         = $fieldProcedimento['id_grupo_procedimento'];
                              $nomeProcedimento         = $fieldProcedimento['codigo_sus'] . ' - ' . $fieldProcedimento['nomeProcedimento'];
                              $codigoSUS                = $fieldProcedimento['codigo_sus'];
                              $inicioCodigoSUS          = $fieldProcedimento['inicioCodigoSUS'];
                              $dataAtendimento          = $fieldProcedimento['dataAtendimento'];
                              $dataMovimentacao         = $fieldProcedimento['dataMovimentacao'];
                              $statusAgendamento        = $fieldProcedimento['status_agendamento'];
                              $idAgendamento            = $fieldProcedimento['id_registro_agendamento'];

                              $resultadoExame = $fieldProcedimento['resultado_exame'];
                              if ($resultadoExame == "S") {
                                $selecionaResultadoSim  = "selected";
                                $selecionaResultadoNao  = "";
                              } else {
                                $selecionaResultadoSim  = "";
                                $selecionaResultadoNao  = "selected";
                              }

                              if ($statusAgendamento == "AGENDADO") {
                                $selecionaAgendado  = "selected";
                                $selecionaPendente  = "";
                                $selecionaAtendido  = "";
                                $selecionaCancelado  = "";                                
                                $bloqueiaResultadoExame = "";
                              } else if ($statusAgendamento == "ATENDIDO") {
                                $selecionaAtendido  = "selected";
                                $selecionaAgendado  = "";
                                $selecionaPendente  = "";
                                $selecionaCancelado  = "";
                                $bloqueiaResultadoExame = "";
                              } else if ($statusAgendamento == "CANCELADO") {
                                $selecionaAtendido  = "";
                                $selecionaAgendado  = "";
                                $selecionaPendente  = "";
                                $selecionaCancelado  = "selected";
                                $bloqueiaResultadoExame = "disabled";
                              } else {
                                $selecionaAgendado  = "";
                                $selecionaAtendido  = "";
                                $selecionaCancelado = "";
                                $selecionaPendente  = "selected";
                                $bloqueiaResultadoExame = "disabled";
                              }

                              if($idAgendamento!="" && $statusAgendamento == "AGENDADO"){
                                $comandoImprimirAgendamento = 'onClick="window.open(' . "'direcionar?opdir=imp-agendamento&idagendamento=$idAgendamento&origem=S-FG')" . '"';
                                $botaoImprimirAgendamento   = "<i class='icofont icofont-printer nova_fonte_blue' style='font-size:13pt' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
                                $comandoCancelar = 'onClick="window.open(' . "'agendamento_cancelar?idpac=$idPaciente&idag=$idAgendamento')" . '"';
                                $botaoCancelarAgendamento   = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' title='Cancelar agendamento.' $comandoCancelar></i>&nbsp;";                              
                              }else{
                                $botaoImprimirAgendamento = "";
                                $botaoCancelarAgendamento            = "";
                              }

                              if ($inicioCodigoSUS != "0202" && $rsPaciente->id_statussolicitacao != 5) {
                                $linkAtualizarStatus = 'onChange="atualizarStatusAgendamento(' . "'$idPaciente##$idSolicitacao##$idProcedimentoAssociado##$idProcedimentoOCI##$linhaRegistro##$codigoSUS',this.value)" . '"';
                                $comandoAgendarDireto  = 'onClick="window.open(' . "'agendamento_direto?idpac=$idPaciente&idpro=$idProcedimentoAssociado&idgrp=$idGrupoAssociado&op=aa&oci=sim&ids=$idSolicitacao&proci=$idProcedimentoOCI')" . '"';
                                $comandoAgendarDireto  = "<i class='icofont icofont-checked nova_fonte' title='Realizar agendamento.' $comandoAgendarDireto></i>";
                                $selectStatusAgendamento = "<select id='setStatusAgendamento$linhaRegistro' class='form-control-personalizado' $linkAtualizarStatus>
                                    <option value='AGENDADO' $selecionaAgendado>AGENDADO</option>
                                    <option value='ATENDIDO' $selecionaAtendido>ATENDIDO</option>
                                    <option value='CANCELADO' $selecionaCancelado>CANCELADO</option>
                                    <option value='PENDENTE' $selecionaPendente>PENDENTE</option>
                                  </select>";

                                if (strpos($nomeProcedimento, 'CONSULTA') !== false) {
                                  $selectResultaoExame = "&nbsp;&nbsp;&nbsp;NÃO SE APLICA";
                                  $linkAtualizarResultadoExame = "";
                                } else {
                                  $linkAtualizarResultadoExame = 'onChange="atualizarResoltadoExame(' . "'$idPaciente##$idSolicitacao##$idProcedimentoAssociado##$idProcedimentoOCI##$codigoSUS',this.value)" . '"';
                                  $selectResultaoExame = "<select id='setResultadoExame$linhaRegistro' class='form-control-personalizado' $linkAtualizarResultadoExame $bloqueiaResultadoExame>
                                    <option value='S' $selecionaResultadoSim>SIM</option>
                                    <option value='N' $selecionaResultadoNao>NÃO</option>
                                  </select>";
                                }
                              } else {
                                $comandoAgendarDireto = "";
                                $selectStatusAgendamento = "";
                                $selectResultaoExame = "";
                              }
                              if ($inicioCodigoSUS != "0202") {
                                echo "<tr>
                                  <td align='center' style='display:none'>
                                    $idProcedimentoAssociado
                                  </td>
                                  <td align='center'>
                                    $comandoAgendarDireto
                                    $botaoImprimirAgendamento
                                    $botaoCancelarAgendamento
                                  </td>
                                  <td>$nomeProcedimento</td>
                                  <td style='padding:1px !important; text-align:center'>$selectStatusAgendamento</td>
                                  <td align='center'>$dataAtendimento</td>
                                  <td style='padding:1px !important; text-align:center'>$selectResultaoExame</td>
                                  <td align='center'>$dataMovimentacao</td>
                                </tr>";
                              } else {
                                echo "<tr>
                                  <td align='center' style='display:none'>
                                    $idProcedimentoAssociado
                                    $botaoImprimirAgendamento
                                    $botaoCancelarAgendamento
                                  </td>
                                  <td align='center'>
                                    $comandoAgendarDireto
                                  </td>
                                  <td>$nomeProcedimento</td>
                                  <td colspan='4' style='background-color: #f3f5f6'>$selectStatusAgendamento</td>
                                </tr>";
                              }
                            }
                            ?>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                  <div class="row" style='margin-top:-15px'>
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="observacaoCuidado">Obsevações do Cuidado:</label>
                        <textarea type="text" id="observacaoCuidado" class="form-control" rows='5'></textarea>
                      </div>
                    </div>
                  </div><br><br>
              </div>
              </form>
            </div>
          </div>
        </div>
      </div>
  </div>
  </section>
</div>
</div>
<div class="barra-flutuante" style='margin-left:-20px'>
  <button type='button' class='btn btn-blue' id='btnSalvar' onClick='salvarAcompanhamento()' style='width:120px'>
    <i class='icofont icofont-checked'></i> Salvar
  </button>
  <button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
    <i class='icofont icofont-exit'></i> Fechar
  </button>
</div>
<?php
include_once("footer.php");
include_once("include/box_pesquisa_cbo_profissional.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  new nicEditor({
    buttonList: ['bold', 'italic', 'underline', 'left', 'center', 'right', 'indent', 'outdent', 'ol', 'ul', 'hr', 'forecolor']
  }).panelInstance('observacaoCuidado');


  function atualizarStatusAgendamento(conteudoDados, valorStatus) {

    var splitConteudo = conteudoDados.split("##");
    var idPaciente = splitConteudo[0];
    var idSolicitacao = splitConteudo[1];
    var idProcedimentoAssociado = splitConteudo[2]
    var idProcedimentoOCI = splitConteudo[3];
    var codigoSUS = splitConteudo[5];
    $.ajax({
      url: 'action/atualizar_registro_oci',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoAtualizacao': 'status-agendamento-oci',
        'idPaciente': idPaciente,
        'idSolicitacao': idSolicitacao,
        'idProcedimentoAssociado': idProcedimentoAssociado,
        'idProcedimentoOCI': idProcedimentoOCI,
        'codigoSUS': codigoSUS,
        'valorStatus': valorStatus
      }
    }).done(function(resultadoRetorno) {
      if (valorStatus == "AGENDADO" || valorStatus == "ATENDIDO") {
        $("#setResultadoExame" + splitConteudo[4]).prop('disabled', false);
      } else {
        $("#setResultadoExame" + splitConteudo[4]).prop('disabled', true);
      }
      location.reload();
    });
  }

  function atualizarResoltadoExame(conteudoDados, valorStatus) {

    var splitConteudo = conteudoDados.split("##");
    var idPaciente = splitConteudo[0];
    var idSolicitacao = splitConteudo[1];
    var idProcedimentoAssociado = splitConteudo[2]
    var idProcedimentoOCI = splitConteudo[3];
    var codigoSUS = splitConteudo[4];
    $.ajax({
      url: 'action/atualizar_registro_oci',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoAtualizacao': 'resultado-exame-oci',
        'idPaciente': idPaciente,
        'idSolicitacao': idSolicitacao,
        'idProcedimentoAssociado': idProcedimentoAssociado,
        'idProcedimentoOCI': idProcedimentoOCI,
        'codigoSUS': codigoSUS,
        'valorStatus': valorStatus
      }

    }).done(function(resultadoRetorno) {});
  }

  function salvarAcompanhamento() {
    var observacaoCuidado = nicEditors.findEditor('observacaoCuidado').getContent();
    var idSolicitacao = "<?php echo $idSolicitacao; ?>";

    $.ajax({
      url: 'action/atualizar_registro_oci',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoAtualizacao': 'observacao-cuidado-oci',
        'idSolicitacao': idSolicitacao,
        'observacaoCuidado': observacaoCuidado
      }
    }).done(function(resultadoRetorno) {
      swal("Acompanhamento OCI", "Registro salvo com sucesso", "success");
    });
  }

  /** bloquear o botão salvar de estiver com status cancelado **/
  var statusSolicitacao = "<?php echo $rsPaciente->id_statussolicitacao; ?>";
  $("#btnSalvar").prop("disabled", statusSolicitacao == 5 ? true : false);

  /** atribuir valor da observação da OCI**/
  nicEditors.findEditor('observacaoCuidado').setContent("<?php echo $observacaoAgendamentoOCI; ?>");
</script>