<?php
session_start();
if(!isset($_SESSION['idUsuarioLogado'])){
	header("location: ./");
}
include_once("header.php");

$opBuscaPaciente = $_GET['op'];
if ($opBuscaPaciente == "cs") {
	$liMenu = "liCadastroSolicitacao";
} else if ($opBuscaPaciente == "aa") {
	$liMenu = $_SESSION['agendaVisivel']=="G" ? "liAgendamentoAvulso" : "liSolicitacaoAgendar";
} else if ($opBuscaPaciente == "ps") {
	$liMenu = "liEmitirSenha";  
} else if ($opBuscaPaciente == "ald") {
	$liMenu = "liLaboratorioAgendarDireto";  
} else if ($opBuscaPaciente == "csl") {
	$liMenu = "liLaboratorioCadastrarSolicitacao";    
} else {
	$liMenu = "liCadastroDemanda";
}
?> 
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
        <div class="card" style='border:gray 1px solid;' id="card-tela">
            <div class="card-header titulo-telas">
							<i class="icofont icofont-search" style='margin-top:-15px !important'></i>&nbsp;Pesquisar Cadastro do Paciente
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i> <b>Informações para pesquisa</b></h4>
                    <div class="row">
                      <div class="col-md-6 col-sm-12">
                        <fieldset class="text-left">
                          <label for="radio-cpf">Por CPF</label>
                          <input type="radio" name="jui-radio-buttons" id="radio-cpf" class="jui-radio-buttons" checked onChange="selecionaBuscaPaciente(this.id)" />
                          <label for="radio-cns">Por CNS</label>
                          <input type="radio" name="jui-radio-buttons" id="radio-cns" class="jui-radio-buttons" onChange="selecionaBuscaPaciente(this.id)" />

                          <input type="hidden" id="opcaoPesquisa" class="form-control" value="radio-cpf" />
                        </fieldset>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="pesquisaCPF">Nº CPF:</label>
                          <input type="text" id="pesquisaCPF" class="form-control cpf-inputmask  text-center" autofocus/>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="pesquisaCNS">Nº Cartão SUS:</label>
                          <input type="text" id="pesquisaCNS" class="form-control cns-inputmask text-center" disabled/>
                        </div>
                      </div>                      
                      <div class="col-md-4">
                        <div class="form-group">
													<label>&nbsp;</label><br>
													<button type="button" class="btn btn-info" onClick="buscarPaciente(opcaoPesquisa.value)"><i class="fa fa-search"></i> Pesquisar</button>
												</div>
											</div>
                    </div>
                  </div>
                  <div class="form-actions" style="margin-top: -15px !important;"></div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<?php
include_once("footer.php");

?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>        
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
var liMenu = "<?php echo $liMenu;?>";
$("#"+liMenu). attr('class', 'active');
$("#"+liMenu).css("border-bottom", "2px solid #c4c8ca");	

function buscarPaciente(selOpcao){

  var	cnsPaciente			= $('#pesquisaCNS').val();
  var	cpfPaciente			= $('#pesquisaCPF').val();
	var	opcaoDocumento	= "";
	var numeroDocumento	= "";
	var tituloMensagem	= "";
	var textoMensagem		= "";

  switch (selOpcao){
    case "radio-cns":
			opcaoDocumento				= "cns";
			numeroDocumento				= cnsPaciente;
			tituloMensagem				= "Cartão SUS";
			textoMensagem					= "Informe o número do cartão SUS para pesquisa!";
			mensagemNãoEncontrato	= "Não foi encontrato nenhum paciente com o Cartão SUS informado.";
		break;
    case "radio-cpf":
			opcaoDocumento				= "cpf";
			numeroDocumento				= cpfPaciente;
			tituloMensagem				= "Número de CPF";
			textoMensagem					= "Informe o número do CPF para pesquisa!";
			mensagemNãoEncontrato	= "Não foi encontrato nenhum paciente com o CPF informado.";
		break;
	}
  
	if(numeroDocumento==""){
    swal(tituloMensagem, textoMensagem, "info");
		return false;
  }else{
		$("#embacado").css("display","block");
		$.ajax({				
			url: 'filtros/filtrar_paciente_ws',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoDocumento'	: opcaoDocumento,
				'numeroDocumento'	:	numeroDocumento
			}	   
		}).done(function(resultadoRetorno){ 
			$("#embacado").css("display","none");
			if(resultadoRetorno=="NaoEncontrado"){
				swal("Não Encontrado", mensagemNãoEncontrato, "error");
				return false;				
			}else{
				window.location.href='paciente_cadastrar?idp='+resultadoRetorno+"&op=<?php echo $_GET['op']?>";
			}
		});



	}
}
</script>