<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");
require("../database/dbConection.php");
$idPerfilLogado = $_SESSION['idPerfilLogado'];

$idPacienteGet  = $_GET['idpac'];

$sqlPaciente  = "SELECT tb_paciente.*, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente         = $rsPaciente->id_paciente;
$nomePaciente       = $rsPaciente->nome_paciente;
$idadePaciente      = $rsPaciente->idadePaciente;
$sexoPaciente       = ($rsPaciente->sexo == "M") ? "MASCULINO" : (($rsPaciente->sexo == "F") ? "FEMININO" : "NÃO INFORMADO");
$cnsPaciente        = $rsPaciente->cns_paciente;
$cpfPaciente        = $rsPaciente->cpf_paciente;
$bairroPaciente     = $rsPaciente->bairro_paciente;
$municipioPaciente  = $rsPaciente->nome_cidade;
$codigoCidade       = $rsPaciente->codigocidade;

$dataHoje = date('Y-m-d');
?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-paper" style='margin-top:-15px !important'></i>&nbsp;Emitir Senha de Atendimento
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <ul class="nav nav-tabs nav-topline">
                        <li class="nav-item">
                          <a class="nav-link active" id="base-dadosPaciente" data-toggle="tab" aria-controls="dadosPaciente" href="#dadosPaciente" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DO PACIENTE E SENHA&nbsp;&nbsp;</b></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="base-historicoPaciente" data-toggle="tab" aria-controls="historicoPaciente" href="#historicoPaciente" aria-expanded="true"><b><i class='icofont icofont-book-alt'></i> HISTÓRICO&nbsp;&nbsp;</b></a>
                        </li>
                      </ul>
                      <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                        <div role="tabpanel" class="tab-pane active" id="dadosPaciente" aria-expanded="true" aria-labelledby="base-dadosPaciente">
                          <form class="form">
                            <div class="form-body">
                              <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                                <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                              </h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-6">
                                  <div class="form-group">
                                    <label for="nomePaciente">Nome:</label>
                                    <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="cpfPaciente">CPF:</label>
                                    <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="cnsPaciente">Cartão SUS:</label>
                                    <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="idadePaciente">Idade:</label>
                                    <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="sexoPaciente">Sexo:</label>
                                    <input type="text" id="sexoPaciente" class="form-control text-center" value="<?php echo $sexoPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="bairroPaciente">Bairro de Residência:</label>
                                    <input type="text" id="bairroPaciente" class="form-control" value="<?php echo $bairroPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-5">
                                  <div class="form-group">
                                    <label for="cidadePaciente">Município de Residência:</label>
                                    <input type="text" id="cidadePaciente" class="form-control" value="<?php echo $municipioPaciente; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="form-body" style="margin-top: -15px;">
                              <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações para emitir senha</b></h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="dataCadastro">Data:</label>
                                    <input type='text' class="form-control text-center form-control-novodisabled" id="dataCadastro" value="<?php echo date('d/m/Y'); ?>" disabled>
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="horaCadastro">Hora:</label>
                                    <input type='text' class="form-control text-center form-control-novodisabled" id="horaCadastro" value="<?php echo date('H:i'); ?>" disabled>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="setorAtendimento">Setor de Atendimento:</label>
                                    <select class="form-control" id="setorAtendimento">
                                      <option value=''>SELECIONE...</option>
                                      <?php
                                      $unidadeLogada = $_SESSION['unidadeLogada'];
                                      $sqlSetorAtendimento  = "SELECT * FROM reg_tb_setoratendimento
                                        WHERE codigo_estabelecimento='$unidadeLogada'
                                        ORDER BY nome_setoratendimento";
                                      $stmSetorAtendimento  = $rsConexao->prepare($sqlSetorAtendimento);
                                      $stmSetorAtendimento->execute();
                                      if ($stmSetorAtendimento->rowCount() > 0) {
                                        $rsSetorAtendimento = $stmSetorAtendimento->fetchAll(PDO::FETCH_ASSOC);
                                        foreach ($rsSetorAtendimento as $fielSetorAtendimento) {
                                          $isSetor    = $fielSetorAtendimento['id_setoratendimento'];
                                          $nomeSetor  = $fielSetorAtendimento['nome_setoratendimento'];
                                          echo "<option value='$isSetor'>$nomeSetor</option>";
                                        }
                                      }
                                      ?>
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="tipoAtendimentoSenha">Tipo de Atendimento:</label>
                                    <select class="form-control" id="tipoAtendimentoSenha">
                                      <option value=''>SELECIONE...</option>
                                      <option value='N'>NORMAL</option>
                                      <option value='P'>PRIORIDADE</option>
                                    </select>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-15px'>
                                <div class='col-md-12'>
                                  <div class="form-group">
                                    <label for="observacaoAtendimento">Observação:</label>
                                    <input type='text' class="form-control" id="observacaoAtendimento">
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-20px'>
                                <div class='col-md-12'>
                                  <div class="form-group">
                                    <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="senhas_geradas" style='width:100%'>
                                      <thead>
                                        <tr>
                                          <th style='text-align: center; width:250px'>SENHA GERADA</th>
                                          <th style='text-align: center; width:100px'>HORA CADASTRO</th>
                                          <th width='20%'>SETOR/SALA</th>
                                          <th width='15%'>TIPO DE ATENDIMENTO</th>
                                          <th>OBSERVAÇÃO</th>
                                        </tr>
                                      </thead>
                                      <tbody style="background-color: #ececec;">
                                        <?php   
                                          $unidadeLogada = $_SESSION['unidadeLogada'];                                       
                                          $sqlSenhas = "SELECT reg_tb_painelchamada_senha.id_painelchamada_senha,
                                          reg_tb_painelchamada_senha.senha_atendimento,
                                          reg_tb_painelchamada_senha.tipo_atendimento,
                                          date_format(reg_tb_painelchamada_senha.datahora_cadastro,'%H:%i') AS horaCadastro,
                                          reg_tb_setoratendimento.nome_setoratendimento,
                                          reg_tb_painelchamada_senha.observacao
                                          FROM reg_tb_painelchamada_senha
                                          INNER JOIN reg_tb_setoratendimento ON (reg_tb_painelchamada_senha.id_setoratendimento = reg_tb_setoratendimento.id_setoratendimento)
                                          WHERE (reg_tb_painelchamada_senha.id_cidadaopaciente='$idPaciente')
                                          AND (date_format(datahora_cadastro,'%Y-%m-%d')='$dataHoje')
                                          AND (codigoestabelecimento_cadastro='$unidadeLogada')";
                                          $stmSenhas= $rsConexao->prepare($sqlSenhas);
                                          $stmSenhas->execute();
                                          if($stmSenhas->rowCount()>0){
                                            $rsSenhas = $stmSenhas->fetchAll(PDO::FETCH_ASSOC);
                                            foreach($rsSenhas AS $fieldSenhas){
                                              $idSenha      = $fieldSenhas['id_painelchamada_senha'];
                                              $senhaGerada  = $fieldSenhas['senha_atendimento'];
                                              $horaCadastro = $fieldSenhas['horaCadastro'];
                                              $setorSenha   = mb_strtoupper($fieldSenhas['nome_setoratendimento']);
                                              $tipoSenha    = $fieldSenhas['tipo_atendimento']=="N" ? "NORMAL" : "PRIORIDADE";
                                              $observaSenha = mb_strtoupper($fieldSenhas['observacao']);

                                              $comandoImprimirSenha   = 'onClick="window.open(' . "'imprimir_senhapainel?ids=$idSenha')" . '"';
                                              $botaoComandoImpressao  = "<i class='icofont icofont-printer nova_fonte_blue' title='Imprimir senha.' $comandoImprimirSenha></i>&nbsp;";                                              
                                              echo "<tr>
                                                <td align='center' style='padding:3px;'>
                                                  <table style='width:100%;'>
                                                    <tr>
                                                      <td style='width:10px;font-size:12pt !important;background-color:transparent !important; border:1px !important'>
                                                        $botaoComandoImpressao
                                                      </td>
                                                      <td style='background-color:transparent !important; border:1px !important;font-size:12pt'>
                                                        <b>$senhaGerada</b>
                                                      </td>
                                                    </tr>
                                                  </table>                                                  
                                                </td>
                                                <td align='center' style='font-size:10pt'>$horaCadastro</td>
                                                <td style='font-size:10pt'>$setorSenha</td>
                                                <td style='font-size:10pt'>$tipoSenha</td>
                                                <td>$observaSenha</td>
                                              </tr>";
                                            }
                                          }
                                        ?>
                                      </tbody>
                                    </table>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </form>
                        </div>
                        <div class="tab-pane" id="historicoPaciente" aria-labelledby="base-historicoPaciente">
                          <div class="row" style="margin-top:-10px !important">
                            <div class='col-md-12'>
                              <div class="bs-callout-warning callout-square callout-bordered mt-1">
                                <div class="media align-items-stretch">
                                  <div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
                                    <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                                  </div>
                                  <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important;font-family:Arial, Helvetica, sans-serif'>
                                    <strong>informação!</strong> <b>Este histórico mostra todos os registros onde o paciente compareceu para atendimento e foi emitida senha para o painel de chamadas.</b>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class='col-md-12'>
                              <div class="form-group">
                                <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="listagem_senha" style='width:100%'>
                                  <thead>
                                    <tr>
                                      <th style='text-align: center !important;'>DATA</th>
                                      <th style='text-align:center; width:100px'>HORA CADASTRO</th>
                                      <th style='text-align:center; width:100px'>INICIO DO ATENDIMENTO</th>
                                      <th style='text-align:center; width:100px'>FIM DO ATENDIMENTO</th>
                                      <th style='text-align:center; width:100px'>TEMPO</th>
                                      <th> SETOR ATENDIMENTO</th>
                                    </tr>
                                  </thead>
                                  <tbody style="background-color: #ececec;">
                                    <?php
                                    ?>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type="button" class="btn btn-blue" onClick="gerarSenha()"><i class="icofont icofont-checked"></i> Gerar Senha</button>
  <button type="button" class="btn btn-success" onClick="window.location.href='paciente_buscar?op=ps'"><i class="icofont icofont-paper"></i> Novo Cadastro</button>
  <button type="button" class="btn btn-danger" id="btnCancelar" onClick="window.location.href='painel'"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>
<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liEmitirSenha").attr('class', 'active');
  $("#liEmitirSenha").css("border-bottom", "2px solid #c4c8ca");

  $('#senhas_geradas').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  $('#listagem_senha').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });  
  
  function gerarSenha() {
    if ($("#setorAtendimento").val() == "" || $("#tipoAtendimentoSenha").val() == "") {
      swal("Dados Obrigatórios", "Você deve informar o setor e tipo de atendimento para gerar a senha", "error");
    }
    $('#embacado').css('display', 'block');
    $.ajax({
      url: 'action/gravar_painelchamada',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoCadastro': 'gerar-senha-atendimento',
        'idPaciente': $("#idPaciente").val(),
        'dataCadastro': $("#dataCadastro").val(),
        'horaCadastro': $("#horaCadastro").val(),
        'setorAtendimento': $("#setorAtendimento").val(),
        'tipoAtendimento': $("#tipoAtendimentoSenha").val(),
        'observacaoAtendimento': $("#observacaoAtendimento").val()
      }
    }).done(function(resultadoRetorno) {

      $("#embacado").css("display", "none");
      if (resultadoRetorno == "JaExiste") {
        swal("Senha Duplicada", "Você já gerou uma senha para este paciente no mesmo setor.", "error");
        return false;
      }
      $('#senhas_geradas').DataTable().destroy();
      $('#senhas_geradas tbody').empty().append(resultadoRetorno);
      $('#senhas_geradas').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
      $("#setorAtendimento").val('');
      $("#tipoAtendimentoSenha").val('');
      $("#observacaoAtendimento").val('');
    });
  }


  function exibirHoraAtual() {
    const agora = new Date();
    let horas = agora.getHours();
    let minutos = agora.getMinutes();

    horas = horas < 10 ? '0' + horas : horas;
    minutos = minutos < 10 ? '0' + minutos : minutos;

    const horaFormatada = horas + ':' + minutos;
    $('#horaCadastro').val(horaFormatada);
  }
  exibirHoraAtual();
  setInterval(exibirHoraAtual, 1000);
</script>