<?php
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");
$idUsuarioLogado  = $_SESSION['idUsuarioLogado'];
?>
<div class="app-content content" style="background-color: #e9e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <div class="content-body">
      <div class="row">
        <div class="col-12">
          <div class="card" style='margin-top:-5px'>
            <div class="card-content">
              <div class="card-body">
                <div class="form-body">
                  <h4 class="form-section h4-painel">
                    <i class="icofont icofont-calendar" style='font-size:16pt'></i><b>&nbsp;Atendimentos do Dia:</b>
                  </h4>
                </div>
                <div class="row">
                  <div class="col-lg-4 col-sm-12 border-right-blue-grey border-right-lighten-5">
                    <div class="pb-1">
                      <div class="clearfix mb-1" style='border-bottom: 2px solid #2196F3;'>
                        <i class="icofont icofont-edit font-large-1 blue float-left mt-1 novo-tamanho-icofont">
                          <font class='font-painel'>&nbsp;Cadastrados:</font>
                        </i>
                        <span class="font-large-2 text-bold-600 blue float-right" id='totalCadastrado'>&nbsp;</span>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-sm-12 border-right-warning border-right-lighten-5">
                    <div class="pb-1">
                      <div class="clearfix mb-1" style='border-bottom: 2px solid #FFC107;'>
                        <i class="icofont icofont-ui-clock font-large-1 warning float-left mt-1 novo-tamanho-icofont">
                          <font class='font-painel'>&nbsp;Aguardando:</font>
                        </i>
                        <span class="font-large-2 text-bold-600 warning float-right" id='totalAguardando'>&nbsp;</span>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-sm-12 border-right-success-grey border-right-lighten-5">
                    <div class="pb-1">
                      <div class="clearfix mb-1" style='border-bottom: 2px solid #37BC9B;'>
                        <i class="icofont icofont-architecture-alt font-large-1 success float-left mt-1 novo-tamanho-icofont">
                          <font class='font-painel'>&nbsp;Em Atendimento:</font>
                        </i>
                        <span class="font-large-2 text-bold-600 success float-right" id='totalAtendimento'>&nbsp;</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="card" style='margin-top:-20px'>
            <div class="card-content">
              <div class="card-body">
                <div class="form-body">
                  <h4 class="form-section h4-painel blue">
                    <i class="icofont icofont-architecture-alt" style='font-size:16pt'></i><b>&nbsp;Lista de Pacientes:</b>
                  </h4>
                  <div class="row" style='margin-top:-5px'>
                    <div class="col-md-12">
                      <div class="form-group">
                        <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id='pessoas_atendimento'>
                          <thead>
                            <tr>
                              <th style="text-align:center; width:80px">OPÇÕES</th>
                              <th>STATUS</th>
                              <th>NOME COMPLETO</th>
                              <th style="text-align:center; width:80px">CNS</th>
                              <th style="text-align:center; width:100px">TIPO</th>                              
                              <th style="text-align:center; width:40px">SENHA</th>
                              <th>SETOR DE ATENDIMENTO</th>
                              <th style="text-align:center; width:100px">HORÁRIO DO CADASTRO</th>
                            </tr>
                          </thead>
                          <tbody style="background-color:#ececec">
                            <?php
                            $unidadeLogada  = $_SESSION['unidadeLogada'];
                            $dataHoje       = date("Y-m-d");
                            $sqlSenhas = "SELECT reg_tb_painelchamada_senha.*,
                            date_format(reg_tb_painelchamada_senha.datahora_cadastro,'%H:%i') AS horaCadastro,
                            reg_tb_setoratendimento.nome_setoratendimento,
                            reg_tb_painelchamada_senha.observacao,
                            ucase(tb_paciente.nome_paciente) AS nomePaciente,
                            tb_paciente.cns_paciente,
                            tb_paciente.cpf_paciente
                            FROM reg_tb_painelchamada_senha
                            INNER JOIN reg_tb_setoratendimento ON (reg_tb_painelchamada_senha.id_setoratendimento = reg_tb_setoratendimento.id_setoratendimento)
                            INNER JOIN tb_paciente ON (reg_tb_painelchamada_senha.id_cidadaopaciente = tb_paciente.id_paciente)
                            WHERE (date_format(datahora_cadastro,'%Y-%m-%d')='$dataHoje')
                            AND (codigoestabelecimento_cadastro='$unidadeLogada')
                            ORDER BY tipo_atendimento DESC, datahora_cadastro ASC";
                            $stmSenhas = $rsConexao->prepare($sqlSenhas);
                            $stmSenhas->execute();
                            if ($stmSenhas->rowCount() > 0) {
                              $rsSenhas = $stmSenhas->fetchAll(PDO::FETCH_ASSOC);
                              foreach ($rsSenhas as $fieldSenhas) {
                                $idSenha      = $fieldSenhas['id_painelchamada_senha'];
                                $statusSenha  = ($fieldSenhas['status_senha'] == 'AG') ? "AGUARDANDO" : (($fieldSenhas['status_senha'] == "EA") ? "EM ATENDIMENTO" : (($fieldSenhas['status_senha'] == "AS") ? "AUSENTE" : (($fieldSenhas['status_senha'] == "CC") ? "CANCELADO" : "ATENDIDO")));
                                $senhaGerada  = $fieldSenhas['senha_atendimento'];
                                $nomePaciente = $fieldSenhas['nomePaciente'];
                                $cnsPaciente  = $fieldSenhas['cns_paciente'];
                                $cpfPaciente  = $fieldSenhas['cpf_paciente'];
                                $horaCadastro = $fieldSenhas['horaCadastro'];
                                $setorSenha   = mb_strtoupper($fieldSenhas['nome_setoratendimento']);
                                $tipoSenha    = $fieldSenhas['tipo_atendimento'] == "N" ? "NORMAL" : "PRIORIDADE";
                                $observaSenha = mb_strtoupper($fieldSenhas['observacao']);
                                $statusCor    = $fieldSenhas['status_senha'];

                                $comandoImprimirSenha   = 'onClick="window.open(' . "'imprimir_senhapainel?ids=$idSenha')" . '"';
                                $botaoComandoImpressao  = "<i class='icofont icofont-printer nova_fonte_blue' title='Imprimir senha.' $comandoImprimirSenha></i>&nbsp;";

                                if($statusCor=="AG"){
                                  $comandoCancelarSenha = 'onClick="cancelarSenha(' . "'$idSenha')" . '"';
                                  $botaoComandoCancelar  = "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Cancelar senha.' $comandoCancelarSenha></i>";
                                }else{
                                  $botaoComandoCancelar = "";
                                }
                                # -- cor do status -- #
                                if($statusCor=="EA"){ // em atendimento
                                  $corStatus = "style='background:#37BC9B'";
                                }else if($statusCor=="AG"){ // aguardando
                                  $corStatus = "style='background:#FFC107'";
                                }else if($statusCor=="AS"){ // ausente
                                  $corStatus = "style='background:#FFADAD'";
                                }else if($statusCor=="CC"){ // cancelado
                                  $corStatus = "style='background:#DA4453; color:#FFF'";
                                }else{
                                  $corStatus ="";
                                }

                                # -- cor tipo atendimento -- #
                                if($fieldSenhas['tipo_atendimento']=="N"){ // normal
                                  $corTipoAtendimento = "";
                                }else{
                                  $corTipoAtendimento ="style='background:#DA4453; color:#FFF'";
                                }
                                echo "<tr>
                                  <td align='center' style='padding:3px;'>
                                    $botaoComandoImpressao
                                    $botaoComandoCancelar
                                  </td>
                                  <td $corStatus>
                                    <b>$statusSenha</b>
                                  </td>
                                  <td>$nomePaciente</td>
                                  <td align='center'>$cnsPaciente</td>
                                  <td align='center' $corTipoAtendimento>$tipoSenha</td>
                                  <td align='center'>$senhaGerada</td>
                                  <td>$setorSenha</td>
                                  <td align='center'>$horaCadastro</td>
                                </tr>";
                              }
                            }
                            ?>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php
include_once("footer.php"); // Rodapé padrão de todoas as páginas
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  setClassTable("pessoas_atendimento");
  $('#pessoas_atendimento').DataTable({
    "lengthChange": false,
    "ordering": false
  });

  
  function carregarDadosPainel(opcaoPainel) {
    $.ajax({
      url: 'action/carregardados_painel',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPainel': opcaoPainel
      }
    }).done(function(resultadoRetorno) { 
      const dadosRetornados = JSON.parse(resultadoRetorno);
      $("#totalCadastrado").html(dadosRetornados.dadosPainelSenha.totalCadastrado);
      $("#totalAguardando").html(dadosRetornados.dadosPainelSenha.totalAguardando);
      $("#totalAtendimento").html(dadosRetornados.dadosPainelSenha.totalAtendimento);
    });

  }
  carregarDadosPainel('recepcao-senha');
</script>