<?php
function getUserIP()
{
  if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {

    $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
    $ip = trim($ips[0]);
  } elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {

    $ip = $_SERVER['HTTP_CLIENT_IP'];
  } else {

    $ip = $_SERVER['REMOTE_ADDR'];
  }

  return filter_var($ip, FILTER_VALIDATE_IP) ? $ip : 'IP inválido';
}

$ip_usuario = getUserIP();
$geo_info = @file_get_contents("http://ip-api.com/json/{$ip_usuario}");
$geo_data = $geo_info ? json_decode($geo_info, true) : null;
$geolocalizacao = ($geo_data && $geo_data['status'] === 'success')
  ? "{$geo_data['city']}, {$geo_data['regionName']}, {$geo_data['country']}"
  : "Desconhecido";
$navegador = $_SERVER['HTTP_USER_AGENT'] ?? 'Desconhecido';
$log_acao = 'login';
$_SESSION['ip_usuario'] = $ip_usuario;
$_SESSION['navegador_usuario'] = $navegador;
$_SESSION['geolocalizacao_usuario'] = $geolocalizacao;

echo "IP: " . $_SESSION['ip_usuario'] . "<br>";
echo "Navegador: " . $_SESSION['navegador_usuario'] . "<br>";
echo "Localização: " . $_SESSION['geolocalizacao_usuario'] . "<br>";
?>