<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php");
?>
<div id="embacado">
	<table align="center" class="tbEmbacado">
		<tr>
			<td align="center"><br>
				<img src="../app-assets/images/processando.gif" width="100px" height="100px">
				<div id="processandoDados" style="margin-top:20px;">Aguarde! Pesquisando pedidos registrados...</div>
			</td>
		</tr>
	</table>
</div>
<div class="app-content content">
	<div class="content-wrapper">
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-search" style='margin-top:-15px !important'></i>&nbsp;Pesquisar Registro de Pedidos
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section"><i class="ft-user"></i> <b>Informações para pesquisa</b></h4>
										<div class="row">
											<div class="col-md-2">
												<div class="form-group">
													<label for="pesquisaCNPJ">CNPJ da Empresa:</label>
													<input type="text" id="pesquisaCNPJ" class="form-control cnpj-inputmask" autofocus>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="pesquisaSolicitante">Nome do Solicitante:</label>
													<select id="pesquisaSolicitante" class="form-control">
														<option value="">SELECIONE...</option>
														<?php
														$stmSolicitante = $rsConexao->prepare("SELECT * FROM tb_solicitante_vigilancia WHERE ativo=1 ORDER BY nome_solicitante");
														$stmSolicitante->execute();
														$rsSolicitante		= $stmSolicitante->fetchAll(PDO::FETCH_ASSOC);
														foreach ($rsSolicitante as $fieldSolicitante) {
															$idSolicitante		= $fieldSolicitante['id_solicitante'];
															$nomeSolicitante	= $fieldSolicitante['nome_solicitante'];
															echo "<option value='$idSolicitante'>$nomeSolicitante</option>";
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="">&nbsp;</label><br>
													<button type="button" class="btn btn-info" onClick="buscarSolicitacao()">
														<i class="fa fa-search"></i> Pesquisar
													</button>
												</div>
											</div>
										</div>
									</div>
									<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table default-ordering table-striped table-bordered" id='dados_pedido'>
									<thead>
										<tr style="background: url(app-assets/images/bg-tr.png); background-repeat: repeat-x; height: 30px !important;">
											<th align='center' width='60px'>DT SOLICITAÇÃO</th>
											<th>NOME DA EMPRESA</th>
											<th>SOLICITANTE</th>
											<th>DESCRIÇÃO DO PEDIDO</th>
											<th align='center' width='180px'>STASUS</th>
										</tr>
									</thead>
									<tbody style="background-color:#dad8d8">
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
include_once("include/box_informa.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liPesquisaPedidos").attr('class', 'active');
	$("#liPesquisaPedidos").css("border-bottom", "2px solid #c4c8ca");

	function buscarSolicitacao() {

		var pesquisaCNPJ = $("#pesquisaCNPJ").val();
		var pesquisaSolicitante = $("#pesquisaSolicitante").val();

		if (pesquisaCNPJ == "" && pesquisaSolicitante == "") {
			$("#box_informa_body").html("Informe o CNPJ da empresa ou selecione o solicitante.");
			$("#box_informa").modal();
			return false;
		}

		$('#embacado').css('display', 'block');

		$.ajax({
			url: 'filtros/filtrar_pedido',
			type: 'post',
			dataType: 'html',
			data: {
				'numerocnpj': pesquisaCNPJ,
				'idSolicitante': pesquisaSolicitante
			}
		}).done(function(resultadoRetorno) {
			$('#embacado').css('display', 'none');

			var retornoResultado = resultadoRetorno.split("#");
			if (retornoResultado[0] == "sucesso") {
				$('#dados_pedido').DataTable().destroy();
				$('#dados_pedido tbody').empty().append(retornoResultado[1]);
				$('#dados_pedido').DataTable();
			} else {
				$("#box_informa_body").html(retornoResultado[0]);
				$("#box_informa").modal();
				return false;
			}
		});

	}


	//$('#dados_pedido').DataTable({"order": [[0, "asc" ]]});			
</script>