<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header-clean.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");

$idPaciente	= $_GET['idp'];

$sqlAgendamentoPaciente = "SELECT reg_tb_agendamentos.id_agendamento,
reg_tb_agendamentos.id_solicitacao,
reg_tb_agendamentos.protocolo_agendamento, 
tb_paciente.nome_paciente, 
tb_paciente.cns_paciente, 
tb_paciente.celular1, 
tb_paciente.celular1_whatsapp, 
tb_paciente.celular2, 
tb_paciente.celular2_whatsapp, 
tb_paciente.celular3, 
tb_paciente.celular3_whatsapp,
reg_tb_procedimento.id_procedimento, 
reg_tb_procedimento.nome_procedimento,
date_format(reg_tb_agendamentos.dataprazo_retirada, '%d/%m/%Y') AS dataRetirada, 
reg_tb_agendamentos.origem_agendamento, 
reg_tb_agendamentos.tipo_vagaocupada,
reg_rl_mensagem_padrao.mensagem, 
reg_rl_mensagem_padrao.mensagem
FROM reg_tb_agendamentos
INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente)
INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento)
INNER JOIN reg_rl_mensagem_padrao ON (reg_rl_mensagem_padrao.sistema_origem=reg_tb_agendamentos.sistema_origem)
WHERE (reg_tb_agendamentos.id_paciente='$idPaciente') 
AND (reg_tb_agendamentos.status_agendamento='A')
ORDER BY reg_tb_agendamentos.dataprazo_retirada ASC";

$stmDadosPaciente = $rsConexao->prepare($sqlAgendamentoPaciente);
$stmDadosPaciente->execute();
$rsDadosPaciebte  = $stmDadosPaciente->fetch(PDO::FETCH_OBJ);

/* dados do paciente */
$nomePaciente       = $rsDadosPaciebte->nome_paciente;
$cnsPaciente        = $rsDadosPaciebte->cns_paciente;
$telefone1          = $rsDadosPaciebte->celular1_whatsapp == "S" ? $rsDadosPaciebte->celular1 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular1;
$telefone2          = $rsDadosPaciebte->celular2_whatsapp == "S" ? $rsDadosPaciebte->celular2 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular2;
$telefone3          = $rsDadosPaciebte->celular3_whatsapp == "S" ? $rsDadosPaciebte->celular3 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular3;
$gerarDadosPaciente = "$nomePaciente##$cnsPaciente##$telefone1##$telefone2##$telefone3";

/* dados do agendamento */
$stmDadosAgendamento = $rsConexao->prepare($sqlAgendamentoPaciente);
$stmDadosAgendamento->execute();
$rsDadosAgendamento  = $stmDadosAgendamento->fetchAll(PDO::FETCH_ASSOC);
$htmlAgendamento     = "";
foreach ($rsDadosAgendamento as $fieldAgendamento) {
	$idAgendamento      = $fieldAgendamento['id_agendamento'];
	$idSolicitacao      = $fieldAgendamento['id_solicitacao'] != "" ? $fieldAgendamento['id_solicitacao'] : "0";
	$dataRetirada       = $fieldAgendamento['dataRetirada'];
	$nomeProcedimento   = mb_strtoupper($fieldAgendamento['nome_procedimento']);

	if ($fieldAgendamento['tipo_vagaocupada'] == "PVEZ" || $fieldAgendamento['tipo_vagaocupada'] == "RETORNO" || $fieldAgendamento['tipo_vagaocupada'] == "RESERVA") {
		$origemAgendamento	= $fieldAgendamento['tipo_vagaocupada'] == "PVEZ" ? "AGENDA (PRIMEIRA VEZ)" : "AGENDA (" . $fieldAgendamento['tipo_vagaocupada'] . ")";
	} else {
		$origemAgendamento	= $fieldAgendamento['tipo_vagaocupada'];
	}


	$linkAtualizarStatus = 'onChange="atualizarStatus(' . "'$idAgendamento##$idSolicitacao',this.value)" . '"';
	$comboStatus = "<select id='setStatus$idAgendamento' class='form-control' $linkAtualizarStatus>
		<option value=''>SELECIONE...</option>
		<option value='Confirmado'>CONFIRMADO</option>
		<option value='Cancelar'>CANCELAR</option>
	</select>";
	$htmlAgendamento .= "<tr>
		<td align='center' style='border: 1px solid gray; height: 30px;'>$dataRetirada</td>
		<td style='border: 1px solid gray'>&nbsp;$nomeProcedimento</td>
		<td style='border: 1px solid gray'>&nbsp;$origemAgendamento</td>
		<td style='border: 1px solid gray'>$comboStatus</td>
	</tr>";
}

/**** ATUALIAR AGENDAMENTOS DESSE PACIENTE COM STATUS DE QUE ESTÁ EM COMUNICAÇÃO ****/
$stmAtuaizaStatusComunicacao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_comunicacao='S', cancelar_comunicacao='S' WHERE id_statussolicitacao='3' AND id_paciente='$idPaciente'");
$stmAtuaizaStatusComunicacao->execute();
$stmAtuaizaStatusComunicacao = $rsConexao->prepare("UPDATE reg_tb_agendamentos SET em_comunicacao='S', cancelar_comunicacao='S' WHERE status_agendamento='A' AND id_paciente='$idPaciente'");
$stmAtuaizaStatusComunicacao->execute();
/************************************************************************************/

?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-phone" style='margin-top:-15px !important'></i>&nbsp;Registro de Comunicação com Paciente - Ligação
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" id="formularioConsumo">
									<div class="form-body" style='margin-top:-15px'>
										<h4 class="form-section"><i class="icofont icofont-user"></i> <b>Dados do Paciente:</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-7">
												<div class="form-group">
													<label for="nomePacienteLigacao">Nome do Paciente:</label>
													<input type="text" id="nomePacienteLigacao" class="form-control" readonly value="<?php echo $nomePaciente; ?>">
													<input type="hidden" id="idPacienteComunicacao" value="<?php echo $idPaciente; ?>">
												</div>
											</div>
											<div class="col-md-5">
												<div class="form-group">
													<label for="cnsPaciente">CNS:</label>
													<input type="text" id="cnsPacienteLigacao" class="form-control text-center" readonly value="<?php echo $cnsPaciente; ?>">
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12" style="margin-top:-20px">
												<div class="form-group">
													<label for="telefone1">Telefones de Contato:</label>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-4" style="margin-top:-25px">
												<div class="form-group">
													<label id="telefone1" class="form-control" style='background-color:#bdf2ff'><?php echo $telefone1; ?></label>
												</div>
											</div>
											<div class="col-md-4" style="margin-top:-25px">
												<div class="form-group">
													<label id="telefone2" class="form-control" style='background-color:#bdf2ff'><?php echo $telefone2; ?></label>
												</div>
											</div>
											<div class="col-md-4" style="margin-top:-25px">
												<div class="form-group">
													<label id="telefone3" class="form-control" style='background-color:#bdf2ff'><?php echo $telefone3; ?></label>
												</div>
											</div>
										</div>
										<div class="row" style='display:none'>
											<div class="col-md-12" style="margin-top:-15px">
												<div class="form-group">
													<label for="meioComunicacao">Meio de Comunicação:</label>
													<select type="text" id="meioComunicacao" class="form-control" disabled>
														<option value='whatsapp'>WHATSAPP</option>
														<option value='ligacao_telefonica' selected>LIGAÇÃO TELEFÔNICA</option>
														<option value='ambos'>AMBOS</option>
													</select>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12" style="margin-top:-15px">
												<div class="form-group">
													<label for="observacoesComunicacao">Observações/Justificativa:</label>
													<textarea id="observacoesComunicacao" class="form-control" rows='4' cols='40'></textarea>
												</div>
											</div>
										</div>
										<div class="form-body" style='margin-top:-15px'>
											<h4 class="form-section"></h4>
										</div>
										<div class="row" style='margin-top:-15px'>
											<div class="col-md-12">
												<div class="form-group">
													<table style='width:100%; border: 1px solid gray'>
														<thead>
															<tr style="background: url(css/images/bg-tr.png); background-repeat: repeat-x; height: 40px !important;">
																<th style='text-align:center; border: 1px solid gray' width='180px !important'>RETIRAR ATÉ</th>
																<th style='border: 1px solid gray'>&nbsp;PROCEDIMENTO</th>
																<th style='border: 1px solid gray'>&nbsp;ORIGEM</th>
																<th style='border: 1px solid gray; width:220px'> STATUS</th>
															</tr>
														</thead>
														<tbody id='dados_procedimentos_listados'>
															<?php echo $htmlAgendamento; ?>
														</tbody>
													</table>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-12">
												<div class="form-group">
													<table align="center">
														<tr>
															<td width="75px">
																<button type="button" class="btn btn-danger" id="botao_modal_info" onclick="fecharAbaComunicacao()"><i class="ft-log-out botaoOk"></i>
																	<b>&nbsp;Fechar</b>
																</button>
															</td>
														</tr>
													</table>
												</div>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	/* atualizar status do agendamento*/
	function fecharAbaComunicacao() {
		window.close();
	}

	/* atualizar status do agendamento*/
	function atualizarStatus(idReferencia, valorStatus) {

		var splitIdreferencia = idReferencia.split("##");
		if (valorStatus == "Cancelar" && $("#observacoesComunicacao").val() == "") {
			swal("Dados Obrigatórios", "Você primeiro preencher a justificativa da solicitação de cancelamento.", "error");
			$("#setStatus" + splitIdreferencia[0]).val("");
			return false;
		}

		$.ajax({
			url: 'action/gravar_solicitacao',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoGravacao': 'atualizar-status-comunicacao-ligacao',
				'idReferencia': idReferencia,
				'valorStatus': valorStatus,
				'observacoesComunicacao': $("#observacoesComunicacao").val(),
				'meioComunicacao': 'ligação'
			}
		}).done(function(resultadoRetorno) {
			swal("Comunicação Confirmada", "O registro da realização da comunicação foi confirmado com sucesso.", "success");
		});

	}

	/* confirmar registros da comunicação com o paciente */
	function confirComunicacaoPaciente() {
		var idPaciente = $("#idPacienteComunicacao").val();
		var meioComunicacao = $("#meioComunicacao").val();
		var observacoesComunicacao = $("#observacoesComunicacao").val();

		if (meioComunicacao == "") {
			swal("Dados Obrigatórios", "Você deve informar o meio de comunicação utilizado para contato com o paciente.", "error");
			return false;
		}

		$.ajax({
			url: 'action/gravar_atualizacaostatus',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoAtualizacao': 'confirmar-comunicacao-ligacao',
				'idPaciente': idPaciente,
				'meioComunicacao': meioComunicacao,
				'observacoesComunicacao': observacoesComunicacao
			}
		}).done(function(resultadoRetorno) {
			swal("Registro de Comuniação", "Registro de comunicação gravado com sucesso.", "success");
			filtrarAgendamentos();
			setInterval(function() {
				$("#box_regitra_ligacao").modal("hide");
			}, 2000);
		});

	}

	$(window).on("unload", function(e) {
		e.preventDefault();
		var idPaciente = "<?php echo $idPaciente; ?>";
		var idSolicitacao = "<?php echo $idSolicitacao; ?>";
		$.ajax({
			url: 'action/gravar_solicitacao',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoGravacao': 'solicitacao-statusligacao-não',
				'idPaciente': idPaciente,
				'idSolicitacao': idSolicitacao
			}
		}).done(function(resultadoRetorno) {});
	});
</script>