<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");

$dataHoje = date("Y-m-d");

$formatarOrigem = array(
	'lista_unica' => 'LISTA ÚNICA',
	'policlinica' => 'POLICLÍNICA',
	'sisreg' => 'SISREG',
	'sistema_vida' => 'VIDA+',
);

?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="fa fa-times" style='margin-top:-15px !important'></i>&nbsp;Registro de Cancelamento
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<div class="form-body" style="margin-top:-15px">
									<form class="form">
										<h4 class="form-section"><i class="ft-printer"></i><b>&nbsp;Filtros para Impressão:</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataInicial">Data Inicial:</label>
													<input type="date" id="dataInicial" class="form-control text-center" autofocus>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataFinal">Data Final:</label>
													<input type="date" id="dataFinal" class="form-control text-center">
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group" style="padding-top:26px">
													<table>
														<tr>
															<td>
																<button type="button" class="btn btn-blue" onClick="imprimirListaLigacao()">
																	<i class="icofont icofont-printer"></i> Imprimir Lista
																</button>
															</td>
															<td width='10px'></td>
															<td>
																<button type="button" class="btn btn-green" onClick="filtrarAgendamentos()">
																	<i class="icofont icofont-download-alt"></i> Atualizar Lista
																</button>
															</td>
														</tr>
													</table>
												</div>
											</div>
										</div>
									</form>
								</div>
								<div class="form-body" style="margin-top:-15px">
									<form class="form">
										<h4 class="form-section"><i class="ft-list"></i> <b>Lista de agendamentos a cancelar</b></h4>
										<div class="form-actions" style="margin-top:-15px !important"></div>
									</form>
								</div>
							</div>
						</div>


						<div class="card-content collapse show" style="margin-top:-60px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering table-responsive-xl2" id='dados_agendamentos'>
									<thead>

										<th style='text-align:center' width='100px'>&nbsp;OPÇÕES&nbsp;</th>
										<th style='text-align:center' width='100px'>Nº SOLICITAÇÃO</th>
										<th style='text-align:center' width='100px'>PRAZO DE RETIRADA</th>
										<th>NOME DO PACIENTE</th>
										<th style='text-align:center' width='100px'>CNS DO PACIENTE</th>
										<th>PROCEDIMENTO</th>
										<th style='text-align:center' width='80px'>ORIGEM</th>
										<th width='80px'>STATUS</th>
										<th>OBSERVAÇÕES</th>
										</tr>
									</thead>
									<tbody style="background-color:#ececec">
										<?php
										$sqlAgendamento	= "SELECT reg_tb_agendamentos.id_agendamento, reg_tb_agendamentos.numero_solicitacao, reg_tb_agendamentos.id_paciente, reg_tb_agendamentos.data_retirada, reg_tb_agendamentos.data_retirada, date_format(data_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente, reg_tb_agendamentos.status_agendamento, reg_tb_procedimento.nome_procedimento, reg_tb_agendamentos.origem_agendamento, reg_tb_agendamentos.observacoes_comunicacao  FROM reg_tb_agendamentos INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente) INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) WHERE status_agendamento='Cancelar' OR (data_retirada<'$dataHoje' AND status_agendamento!='Entregue' AND status_agendamento!='Cancelado' AND status_agendamento!='Devolvido') GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.data_retirada, tb_paciente.cns_paciente 
																ORDER BY data_retirada, nome_paciente";
										$stmAgendamento    = $rsConexao->prepare($sqlAgendamento);
										$stmAgendamento->execute();
										$rsAgendamento			= $stmAgendamento->fetchAll(PDO::FETCH_ASSOC);
										$totalAgendamentos	= $stmAgendamento->rowCount();


										if ($totalAgendamentos > 0) {
											$contadorOrdemData = 0;
											foreach ($rsAgendamento as $fieldAgendamento) {
												$contadorOrdemData	= $contadorOrdemData + 1;
												$idAgendamento    	= $fieldAgendamento['id_agendamento'];
												$idPaciente					= $fieldAgendamento['id_paciente'];
												$numeroSolicitacao	= $fieldAgendamento['numero_solicitacao'];
												$dataRetirada				= $fieldAgendamento['dataRetirada'];
												$nomePaciente				= $fieldAgendamento['nome_paciente'];
												$cnsPaciente				= $fieldAgendamento['cns_paciente'];
												$nomeProcedimento 	= $fieldAgendamento['nome_procedimento'];
												$dataretiradaEnc  	= $fieldAgendamento['data_retirada'];
												$origemAgendamento	= $formatarOrigem[$fieldAgendamento['origem_agendamento']];
												$obsAgendamento			= mb_strtoupper($fieldAgendamento['observacoes_comunicacao']);
												$statusAgengamentoX = mb_strtoupper($fieldAgendamento['status_agendamento']);

												$linkConfirmarCancelamento  = 'onclick="confirmarCancelamento(' . "'$idAgendamento')" . '"';
												$linkInformacao             = 'onclick="window.open(' . "'informacoesagendamento?ida=$idAgendamento')" . '"';

												if ($dataHoje > $dataretiradaEnc && $obsAgendamento == "") {
													$obsAgendamento	= "PRAZO VENCIDO PARA RETIRADA, OU SEM OBSERVAÇÃO";
												} else {
													$obsAgendamento = $obsAgendamento;
												}

												$devolverParaEntrega	= '"devolverParaEntrega(' . "'$idAgendamento')" . '"';

												echo "<tr style='font-size:9pt !important'>
																			<td style='text-align:center'>
																				<i class='icofont icofont-checked nova_fonte' title='Confirmar cancelamento de marcação.' $linkConfirmarCancelamento></i>
																				<i class='icofont icofont-info-square nova_fonte_blue' title='Visualizar informações sobre este agendamento.' $linkInformacao></i>
																				<i class='icofont icofont-curved-double-right nova_fonte_blue' style='color:#860000' title='Devolver para setor de entregas.' onclick=$devolverParaEntrega></i>
																			</td>
																			<td style='text-align:center'>$numeroSolicitacao</td>
																			<td style='text-align:center'><font style='font-size:0.1px'>$contadorOrdemData</font>$dataRetirada</td>
																			<td>$nomePaciente</td>
																			<td style='text-align:center'>$cnsPaciente</td>
																			<td>$nomeProcedimento</td>
																			<td>$origemAgendamento</td>
																			<td>$statusAgengamentoX</td>
																			<td>$obsAgendamento</td>
																		</tr>";
											}
										}
										?>
									</tbody>
								</table>
							</div>
						</div>




					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
include_once("include/box_regitra_ligacao.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liRegistroCancelamentos").attr('class', 'active');
	$("#liRegistroCancelamentos").css("border-bottom", "2px solid #c4c8ca");
	/***********************************/
	function filtrarAgendamentos() {
		$("#embacado").css("display", "block");
		$.ajax({
			url: 'filtros/filtrar_agendamentos',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoListagem': "comunicacao-pacientes-cancelar"
			}
		}).done(function(resultadoRetorno) {
			$('#dados_agendamentos').DataTable().destroy();
			$('#dados_agendamentos tbody').empty().append(resultadoRetorno);
			$('#dados_agendamentos').DataTable();
			$("#embacado").css("display", "none");
		});

	}
	/***********************************/

	function abrirRegistroComunicacao(idPaciente) {
		var larguraTela = window.screen.width;
		$("#modal-comunicacao").css("width", larguraTela / 2.5);

		$("#embacado").css("display", "block");

		$.ajax({

			url: 'filtros/buscar_dados_edicao',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoBusca': 'comunicacao-pacientes-ligacao',
				'idPaciente': idPaciente
			}

		}).done(function(resultadoRetorno) {
			var retornoResultado = resultadoRetorno.split("##");
			$("#idPacienteComunicacao").val(idPaciente);
			$("#nomePacienteLigacao").val(retornoResultado[0]);
			$("#cnsPacienteLigacao").val(retornoResultado[1]);
			$("#telefone1").html(retornoResultado[2]);
			$("#telefone2").html(retornoResultado[3]);
			$("#telefone3").html(retornoResultado[4]);
			$('#dados_procedimentos_listados').html(retornoResultado[5]);
			$("#embacado").css("display", "none");
			$("#box_regitra_ligacao").modal();


		});

	}

	/* confirmar registros da comunicação com o paciente */
	function confirComunicacaoPaciente() {
		var idPaciente = $("#idPacienteComunicacao").val();
		var meioComunicacao = $("#meioComunicacao").val();
		var observacoesComunicacao = $("#observacoesComunicacao").val();

		if (meioComunicacao == "") {
			swal("Dados Obrigatórios", "Você deve informar o meio de comunicação utilizado para contato com o paciente.", "error");
			return false;
		}

		$.ajax({
			url: 'action/gravar_atualizacaostatus',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoAtualizacao': 'confirmar-comunicacao-ligacao',
				'idPaciente': idPaciente,
				'meioComunicacao': meioComunicacao,
				'observacoesComunicacao': observacoesComunicacao
			}
		}).done(function(resultadoRetorno) {
			swal("Registro de Comuniação", "Registro de comunicação gravado com sucesso.", "success");
			filtrarAgendamentos();
			setInterval(function() {
				$("#box_regitra_ligacao").modal("hide");
			}, 2000);
		});

	}
	/* atualizar status do agendamento*/
	function atualizarStatus(idAgendamento, valorStatus) {

		$.ajax({
			url: 'action/gravar_atualizacaostatus',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoAtualizacao': 'status-comunicacao',
				'idAgendamento': idAgendamento,
				'valorStatus': valorStatus
			}
		}).done(function(resultadoRetorno) {});

	}

	/* atualizar status do agendamento*/
	function cancelarComunicacao() {
		$("#box_regitra_ligacao").modal("hide");
	}

	function confirmarCancelamento(idAgendamento) {

    Swal.fire({
      title: "Cancelar Agendamento",
      html: "<p style='text-align:justify'><font style='font-weight: bold; color: #a00404ff;'>ATENÇÃO!</font> O registro deste agendamento no sistema mudara para o status de cancelado. <b>Confirma?</b></p>",      
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
				$.ajax({
					url: 'action/atualizar_comunicacao',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoAtualizacao': 'atualizacao-comunicacao-cancelar',
						'idAgendamento': idAgendamento
					}
				}).done(function(resultadoRetorno) {
					filtrarAgendamentos();
					swal("Cancelar Agendamento", "Registro de cancelamento confirmado com sucesso.", "success");
				});
      }
    });

	}

	function imprimirListaLigacao() {

		var dataInicial = $("#dataInicial").val();
		var dataFinal = $("#dataFinal").val();

		if (dataInicial == "" || dataFinal == "") {
			swal("Período Obrigatório", "Você precisa informar o período completo.", "error");
			return false;
		}

		window.open("relatorios/imprimir_listacancelamentos?di=" + dataInicial + "&df=" + dataFinal);

	}


	function devolverParaEntrega(idAgendamento) {

    Swal.fire({
      title: "Encaminhamento",
      html: "<p style='text-align:justify'><font style='font-weight: bold; color: #a00404ff;'>ATENÇÃO!</font> O agendamento será devolvido com status de liberação para entrega no SEA. <b>Confirma?</b></p>",        
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
				$.ajax({
					url: 'action/atualizar_comunicacao',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoAtualizacao': 'atualizacao-devolver-entrega',
						'idAgendamento': idAgendamento
					}
				}).done(function(resultadoRetorno) {
					filtrarAgendamentos();
					swal("Encaminhamento", "Registro encaminhado para tela do setor de entregas.", "success");
				});
      }
    });

	}
</script>