<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php");

$arrayCalssificacao  = array(
  "1" => "EMERGÊNCIA",
  "2" => "URGENTE",
  "3" => "NÃO URGENTE",
	"4" => "ELETIVO",
);

?>

<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header" style="background: url(css/images/bg-title.png); background-repeat: repeat-x; height: 45px !important;">
							<h4 class="card-title" style="font-size: 11pt; margin-top: -8px; color: #fff;">
								<b><i class="fa fa-print"></i>&nbsp;IMPRESSÃO DE RELATÓRIO - DEMANDA REPRIMIDA</b>
							</h4>
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section" style='margin-top:-10px'>
											<i class="ft-filter"></i> <b>Filtros para emissão do relatório.</b>
										</h4>
										<div class="row">

										</div>
										<div class="row">
											<div class="col-md-6">
												<div class="form-group">
													<label for="">Selecione a opção do período da solicitação para geração do relatório:</label>
													<select class="form-control" id="periodoSelecionado">
														<option value='completo'>ANALISAR CADASTRO COMPLETO (PROCESSAMENTO MAIS DEMORADO PARA ANALÍTICO)</option>
														<option value='digitado'>DIGITAR PERÍODO A ANALISAR</option>
													</select>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataInicial">Data Inicial:</label>
													<input type="date" class="form-control text-center" id="dataInicial" disabled>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="">Data Final:</label>
													<input type="date" class="form-control text-center" id="dataFinal" disabled>
												</div>
											</div>
										</div>
									</div>
									<div class="row" style='margin-top:-3px'>
										<div class="col-md-3">
											<div class="form-group">
												<label for="grupoProcedimento">Grupo:</label>
												<select class="form-control" id="grupoProcedimento" onchange="filtrarProcedimentos()">
													<option value="">TODOS...</option>
													<?php
													$stmGrupo	= $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE id_grupo_procedimento!='1' ORDER BY nome_grupo_procedimento");
													$stmGrupo->execute();
													$rsGrupo = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
													$totalGrupo	= $stmGrupo->rowCount();
													if ($totalGrupo > 0) {
														echo "<option value='1'>NÃO AGRUPADOS</option>";
														foreach ($rsGrupo as $fieldGrupo) {
															$idGrupo = $fieldGrupo['id_grupo_procedimento'];
															$nomeGrupo = mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);
															echo "<option value='$idGrupo'>$nomeGrupo</option>";
														}
													}
													?>
												</select>
											</div>
										</div>
										<div class="col-md-4">
											<div class="form-group">
												<label for="nomeProcedimento">Nome de Procedimentos:</label>
												<select class="form-control" id="nomeProcedimento">
													<option value="">TODOS...</option>
												</select>
											</div>
										</div>
										<div class="col-md-3">
											<div class="form-group">
												<label for="classificacaoRisco">Classificação:</label>
												<select class="form-control" id="classificacaoRisco">
													<option value="">TODOS...</option>
													<?php
													$stmClassificacao		= $rsConexao->prepare("SELECT * FROM reg_rl_classificacaorisco ORDER BY nome_classificacaorisco");
													$stmClassificacao		->execute();
													$rsClassificacao 		= $stmClassificacao->fetchAll(PDO::FETCH_ASSOC);
													foreach ($rsClassificacao as $fieldClassificacao) {
														$idClassificacao		= $fieldClassificacao['id_classificacaorisco'];
														$nomeClassificacao	= $arrayCalssificacao[$fieldClassificacao['id_classificacaorisco']];
														echo "<option value='$idClassificacao'>$nomeClassificacao</option>";
													}
													?>
												</select>
											</div>
										</div>										
										<div class="col-md-2">
											<div class="form-group">
												<label for="tipoRelatorio">Tipo:</label>
												<select class="form-control" id="tipoRelatorio">
													<option value='sintetico'>SINTÉTICO</option>
													<option value='detalhado'>DETALHADO</option>
												</select>
											</div>
										</div>
									</div>
									<div class="row" style="margin-top:-30px !important">
										<div class='col-md-12'>
											<div class="form-group">
												<div class="bs-callout-warning callout-square callout-bordered mt-1">
													<div class="media align-items-stretch">
														<div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
															<i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
														</div>
														<div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
															<strong>ATENÇÃO!</strong> <b>É importante que o relatório seja gerando realizando algum tipo de filtro. Relatórios sem filtro pode demorar muito para ser carregado e até causar lentidão ou travamento do sistema</b><br>
															<strong>OBS!</strong><b> Ao informar que o sistema deve consolidar os dados do operadores, o sistema gerará um relatório com os quantitativos de cada operador que tiver registro no relatório selecionado.</b>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-md-12">
											<div class="form-group">
												<button type="button" class="btn btn-dark" onClick="imprimirRelatorio()">
													<i class="ft-printer"></i> Visualizar e Imprimir
												</button>
											</div>
										</div>
									</div>
							</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liRelDemandaReprimida").attr('class', 'active');
	$("#liRelDemandaReprimida").css("border-bottom", "2px solid #c4c8ca");

	function imprimirRelatorio() {

		if (($("#dataInicial").val() != "" && $("#dataFinal").val() != "") && ($("#dataInicial").val() > $("#dataFinal").val())) {
			swal("Período Inváido", "A data inicial não pode ser maior do que a data final", "error");
			return false;
		}

		if ($("#periodoSelecionado").val() == "digitado") {
			if ($("#dataInicial").val() == "" || $("#dataFinal").val() == "") {
				swal("Período Inváido", "Para gerar o relatório por período você deve preencher corretamente os campos de data", "error");
				return false;
			}
		}

		var nomeGrupo 		= $('#grupoProcedimento').find(":selected").text();
		var nomeProced		= $('#nomeProcedimento').find(":selected").text();
		var getRelatorio	= "dti="+$("#dataInicial").val()+"&dtf="+$("#dataFinal").val()+"&grupo="+$("#grupoProcedimento").val()+"&idproc="+$("#nomeProcedimento").val()+"&cfr="+$('#classificacaoRisco').val()+"&tipo="+$("#tipoRelatorio").val()+"&nomegp="+nomeGrupo+"&nomeproced="+nomeProced;
		window.open("relatorios/imprimir_demandareprimida?"+getRelatorio);
	}

	function filtrarProcedimentos() {

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'filtros/filtrar_procedimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoPesquisa': 'consultar-solicitacao',
				'grupoProcedimento': $("#grupoProcedimento").val()
			}
		}).done(function(resultadoRetorno) {
			$("#procedimentoSelecionado").val("");
			$("#nomeProcedimento").html("");
			$("#nomeProcedimento").html(resultadoRetorno);
			$("#embacado").css("display", "none");
		});

	}

	$("#periodoSelecionado").change(function() {

		if (this.value == "completo") {
			$("#dataInicial").val('');
			$("#dataFinal").val('');
			$("#dataInicial").prop("disabled", true);
			$("#dataFinal").prop("disabled", true);
		} else {
			$("#dataInicial").prop("disabled", false);
			$("#dataFinal").prop("disabled", false);
		}

	});
</script>