<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");

$arrayMes  = array(
  "01" => "JANEIRO",
  "02" => "FEVEREIRO",
  "03" => "MARÇO",
  "04" => "ABRIL",
  "05" => "MAIO",
  "06" => "JUNHO",
  "07" => "JULHO",
  "08" => "AGOSTO",
  "09" => "SETEMBRO",
  "10" => "OUTUBRO",
  "11" => "NOVEMBRO",
  "12" => "DEZEMBRO"
)

?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <b><i class="fa fa-print"></i>&nbsp;Impressão de Relatório - Oferta de Serviços</b>
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section" style='margin-top:-10px'>
                      <i class="ft-filter"></i> <b>Filtros para emissão do relatório.</b>
                    </h4>
                    <div class="row">

                    </div>
                    <div class="row">
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="anoRelatorio">Ano:</label>
                          <input type='number' id="anoRelatorio" class="form-control text-center" autofocus value="<?php echo date('Y');?>">
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="anoRelatorio">Mês:</label>
                          <select id="mesRelatorio" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <?php
                              $setMes=0;
                              for($setMes=1;$setMes<=12;$setMes++){
                                $numMes = str_pad($setMes,2,"0",STR_PAD_LEFT);
                                $nomeMes = $arrayMes[$numMes];
                                echo "<option value='$numMes'>$nomeMes</option>";
                              }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="grupoOferta">Grupo:</label>
                          <select class="form-control" id="grupoOferta" onchange="filtrarProcedimentos()">
                            <option value="">TODOS</option>
                            <?php
                            $stmGrupo  = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE id_grupo_procedimento!='1' ORDER BY nome_grupo_procedimento");
                            $stmGrupo->execute();
                            $rsGrupo = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
                            $totalGrupo  = $stmGrupo->rowCount();
                            if ($totalGrupo > 0) {
                              echo "<option value='1'>NÃO AGRUPADOS</option>";
                              foreach ($rsGrupo as $fieldGrupo) {
                                $idGrupo = $fieldGrupo['id_grupo_procedimento'];
                                $nomeGrupo = mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);
                                echo "<option value='$idGrupo'>$nomeGrupo</option>";
                              }
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="procedimentoOferta">Procedimento:</label>
                          <select class="form-control" id="procedimentoOferta">
                            <option value="">SELECIONE O GRUPO...</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-12">
                        <div class="form-group">
                          <button type="button" class="btn btn-dark" onClick="imprimirRelatorio()">
                            <i class="ft-printer"></i> Visualizar e Imprimir
                          </button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
    </section>
  </div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liRelOferta").attr('class', 'active');
  $("#liRelOferta").css("border-bottom", "2px solid #c4c8ca");

  function imprimirRelatorio() {

    var documentoPaciente = $("#documentoPaciente").val();
    var dataInicial = $("#dataInicial").val();
    var dataFinal = $("#dataFinal").val();
    var operadorSistema = $("#operadorSistema").val();
    var grupoProcedimento = $("#grupoProcedimento").val();
    var nomeProcedimento = $("#nomeProcedimento").val();

    if ((dataInicial != "" && dataFinal != "") && (dataInicial > dataFinal)) {
      swal("Período Inváido", "A data inicial não pode ser maior do que a data final", "error");
      return false;
    }

    if ((dataInicial != "" && dataFinal == "") || (dataInicial == "" && dataFinal != "")) {
      swal("Período Inváido", "Para gerar o relatório por período você deve preencher corretamente os campos de data", "error");
      return false;
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gerar_dadosrelatorio',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoRelatorio': "oferta_servico",
        'documentoPaciente': documentoPaciente,
        'dataInicial': dataInicial,
        'dataFinal': dataFinal,
        'operadorSistema': operadorSistema,
        'grupoProcedimento': grupoProcedimento,
        'nomeProcedimento': nomeProcedimento,
        'dadosPaciente': document.getElementById('dadosPaciente').checked == true ? "S" : "N"
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      var urlRelatorio = document.getElementById('consolidarOperador').checked == false ? 'relatorios/imprimir_relatorio' : 'relatorios/imprimir_relatorio_consolidado';
      window.open(urlRelatorio);
    });
  }

  function filtrarProcedimentos() {

    $("#embacado").css("display", "block");

    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'consultar-solicitacao',
        'grupoProcedimento': $("#grupoProcedimento").val()
      }
    }).done(function(resultadoRetorno) {
      $("#procedimentoSelecionado").val("");
      $("#nomeProcedimento").html("");
      $("#nomeProcedimento").html(resultadoRetorno);
      $("#embacado").css("display", "none");
    });

  }
</script>