<?php
session_start();
require("../../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$dataHoraImpressao  = date("d/m/Y H:i");

$dataInicial = $_GET['di'];
$dataFinal = $_GET['df'];

ob_start();

echo "<table class='tabela-dados-relatorio'>
<thead>
  <tr>
    <th scope='col' style='text-align: center' width='80Ppx'>PRAZO RETIRADA</th>
    <th scope='col' style='text-align: left'>NOME DO PACIENTE</th>
    <th scope='col' style='text-align: center' width='90px'>CNS</th>    
    <th scope='col' style='text-align: left'>PROCEDIMENTO</th>
    <th scope='col' style='text-align: center' width='90px'>ORIGEM</th>    
    <th scope='col' style='text-align: center'>TELEFONES</th>
  </tr>
</thead>
<tbody>";

$sqlRelatorio = "SELECT date_format(reg_tb_solicitacoes.dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente, reg_tb_procedimento.nome_procedimento, tb_paciente.celular1,  tb_paciente.celular2, tb_paciente.celular3, ucase(reg_tb_solicitacoes.origem_agendamento) as origemAgendamento 
FROM reg_tb_solicitacoes 
INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente = tb_paciente.id_paciente)
INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento)
WHERE (date_format(reg_tb_solicitacoes.dataprazo_retirada,'%Y-%m-%d') BETWEEN '$dataInicial' AND '$dataFinal')
AND encaminhado_ligacao='S'
AND (status_comunicacao is null or status_comunicacao='')
AND (id_statussolicitacao=3) 
ORDER BY reg_tb_solicitacoes.dataprazo_retirada, tb_paciente.nome_paciente ASC";
$stmRelatorio   = $rsConexao->prepare($sqlRelatorio);
$stmRelatorio   ->execute();  
$rsRelatorio    = $stmRelatorio->fetchAll(PDO::FETCH_ASSOC);
$totalRegistros = $stmRelatorio->rowCount();		

if($totalRegistros>0){

  foreach($rsRelatorio as $fieldRelatorio){
    $dataRetirada       = $fieldRelatorio['dataRetirada'];
    $nomePaciente       = $fieldRelatorio['nome_paciente'];
    $cnsPaciente        = $fieldRelatorio['cns_paciente'];
    $nomeProcedimento   = $fieldRelatorio['nome_procedimento'];
    $origemAgendamento  = $fieldRelatorio['origemAgendamento'];
    $telefonesPaciente  = $fieldRelatorio['celular1'] . " | " . $fieldRelatorio['celular2'] . " | " . $fieldRelatorio['celular3'];
    echo "<tr>
      <td align='center'>$dataRetirada</td>
      <td>$nomePaciente</td>
      <td align='center'>$cnsPaciente</td>
      <td>$nomeProcedimento</td>
      <td>$origemAgendamento</td>
      <td>$telefonesPaciente</td>
    </tr>";
  }

}

echo "</tbody>
</table>";

require_once __DIR__ . '../../../mpdf/autoload.php';
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => 'L',
  'margin_header' => 15,  
  'margin_top' => 35,
  'default_font' => 'tahoma'
]);

$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorio.css');
$mpdf->WriteHTML($stylesheet,1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        CONTROLE DE AGENDAMENTOS<br>
        RELATAÓRIO DE AGENDAMENTOS
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoraImpressao<br>
        IMPRESSO POR : $nomeUsuarioLogado<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$headerE = $header;
$footer = "<div>Regulação Municipal de Lauro de Freitas||Página : {PAGENO} de {nb}";
$footerE = $footer;

$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLHeader($headerE,'E');
$mpdf->SetFooter($footer);
$mpdf->SetFooter($footerE,'E');
$mpdf->SetTitle('Relatório G-SAUDE');
$mpdf->WriteHTML($html);
$mpdf->Output('RelatórioGSaude.pdf','I');
exit;

?>