<?php
session_start();
require("../../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$dataHoraImpressao  = date("d/m/Y H:i");

$totalRegistros               = 0;
$opcaoRelatorio               = $_SESSION['opcaoRelatorio'];
$complementoColunaQuantidade  = mb_strtoupper($opcaoRelatorio);
$subTituloFiltrosRelatorio = $_SESSION['periodoSelecionado'] . "<br>".$_SESSION['funcionarioSelecionado'];
ob_start();

switch($opcaoRelatorio){
  case "agendamentos":
    $tituloRelatorio      = "RELATÓRIO DE AGENDAMENTOS - POR USUÁRIO";
  break;
  case "analises":
    $tituloRelatorio      = "RELATÓRIO DE ANÁLISES REALIZADAS";
  break;
  case "cancelamentos":
    $tituloRelatorio      = "RELATÓRIO DE CANCELAMENTOS - POR USUÁRIO";
  break;
  case "entregas":
    $tituloRelatorio      = "RELATÓRIO DE ENTREGAS DE MARCAÇÃO - POR USUÁRIO";
  break;
  case "solicitacoes":
    $tituloRelatorio      = "RELATÓRIO DE SOLICITAÇÕES - POR USUÁRIO";
  break;  
}

  $htmlTabelaRelatorio  = "<table class='tabela-dados-relatorio'>
  <thead>
    <tr>
      <th scope='col' style='text-align: left'>NOME DO USUÁRIO</th>
      <th scope='col' style='text-align: left'>UNIDADE DE LOTAÇÃO</th>
      <th scope='col' style='text-align: center; width:150px'>QUANDITADE DE $complementoColunaQuantidade</th>
    </tr>
  </thead>
  <tbody>";
  $sqlRelatorio = "SELECT nome_usuario_dados, unidade_lotacao_usuario, COUNT(id_dados_relatorio) AS totalProcedimentos FROM reg_dados_relatorio GROUP BY nome_usuario_dados ORDER BY COUNT(id_dados_relatorio) DESC";
  $stmRelatorio   = $rsConexao->prepare($sqlRelatorio);
  $stmRelatorio   ->execute();  
  
  if($stmRelatorio->rowCount()>0){        
    $rsRelatorio  = $stmRelatorio->fetchAll(PDO::FETCH_ASSOC);
    $calcularTotalGeral = 0;
    foreach($rsRelatorio as $fieldRelatorio){
      $nomeUsuario        = mb_strtoupper($fieldRelatorio['nome_usuario_dados']);
      $nomeUnidade        = mb_strtoupper($fieldRelatorio['unidade_lotacao_usuario']);
      $totalProcedimentos = number_format($fieldRelatorio['totalProcedimentos'],0,'','.');
      $calcularTotalGeral = $calcularTotalGeral + $fieldRelatorio['totalProcedimentos'];
      $htmlTabelaRelatorio .= "<tr>
        <td>$nomeUsuario</td>
        <td>$nomeUnidade</td>
        <td align='center'>$totalProcedimentos</td>
      </tr>";
    }
    $totalGeralProcedimentos = number_format($calcularTotalGeral,0,'','.');
    $htmlTabelaRelatorio .= "<tr>
      <td align='left' colspan='3' style='line-height: 25px; background:#e7e7e7; font-size:10pt'>TOTAL DE PROCEDIMENTOS: $totalGeralProcedimentos</td>
    </tr>";
  }else{
    $htmlTabelaRelatorio .= "<tr>
      <td colspan='5' align='center'><b>NENHUM REGISTRO ENCONTRATO</b></td>
    </tr>";
  }
  $htmlTabelaRelatorio .= "</tbody>
    </table>";     

echo "<font style='font-size:9pt'><b>$subTituloFiltrosRelatorio</b></font><br><br>$htmlTabelaRelatorio";
//require_once('../../../lib_sistemas/mpdf8/autoload.php');
require_once ('../../../lib_sistemas/mpdf8/vendor/autoload.php'); // SERVIDOR
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => 'L',
  'margin_header' => 15,  
  'margin_top' => 35,
  'default_font' => 'tahoma'
]);

$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorio.css');
$mpdf->WriteHTML($stylesheet,1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        SISTEMA DE CONTROLE DE AGENDAMENTOS<br>
        $tituloRelatorio
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoraImpressao<br>
        IMPRESSO POR : $nomeUsuarioLogado<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$headerE = $header;
$footer = "<div>Desenvolvido por: Cláudio Magalhães||Página : {PAGENO} de {nb}";
$footerE = $footer;

$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLHeader($headerE,'E');
$mpdf->SetFooter($footer);
$mpdf->SetFooter($footerE,'E');
$mpdf->SetTitle('Relatório-gSaúde');
$mpdf->WriteHTML($html);
$mpdf->Output('Relatório-gSaúde.pdf','I');
exit;

?>