<?php
session_start();
if(!isset($_SESSION['idUsuarioLogado'])){
	header("location: ./");
}
include_once("header-clean.php");
require("../database/dbConection.php");

$idPerfilLogado = $_SESSION['idPerfilLogado'];

$idPacienteGet  = $_GET['idpac'];
$opcaoTela      = $_GET['op'];

$sqlPaciente	= "SELECT tb_paciente.*, date_format(tb_paciente.datanasc,'%d/%m/%Y') AS nascimentoPaciente, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente	= $rsConexao->prepare($sqlPaciente);
$stmPaciente	-> execute();
$rsPaciente		= $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente 				= $rsPaciente->id_paciente;
$nomePaciente 			= $rsPaciente->nome_paciente;
$idadePaciente			= $rsPaciente->idadePaciente;
$nascimentoPaciente = $rsPaciente->nascimentoPaciente;
$sexoPaciente       = $rsPaciente->sexo;
$cnsPaciente				= $rsPaciente->cns_paciente;
$cpfPaciente				= $rsPaciente->cpf_paciente;
$municipioPaciente	= $rsPaciente->nome_cidade;
$bairrroPaciente		= $rsPaciente->bairro_paciente;
$ibgeCidade					= $rsPaciente->codigocidade;
$telefoneCelular1					= $rsPaciente->celular1;
$telefoneCelular1Whatsapp	= $rsPaciente->celular1_whatsapp == "S" ? " checked" : "";
$telefoneCelular2					= $rsPaciente->celular2;
$telefoneCelular2Whatsapp	= $rsPaciente->celular2_whatsapp == "S" ? " checked" : "";
$telefoneCelular3					= $rsPaciente->celular3;
$telefoneCelular3Whatsapp	= $rsPaciente->celular3_whatsapp == "S" ? " checked" : "";

$formatarOrigem = array(
	'lista_unica'   => 'LISTA ÚNICA',
	'policlinica'   => 'POLICLÍNICA',
	'sisreg'        => 'SISREG',
	'sistema_vida'  => 'VIDA+'
);

  $idSolicitacao    = $_GET['idsol'];
  $sqlSolicitacao	= "SELECT *, date_format(datahora_cadastro,'%d/%m/%Y - %H:%i') AS dataHoraSolicitacao, date_format(datahora_registroagendamento,'%d/%m/%Y - %H:%i') AS dataHoraRegistroAgendamento, reg_tb_solicitacoes.dataprazo_retirada, reg_tb_solicitacoes.origem_agendamento, reg_tb_procedimento.nome_procedimento, reg_tb_procedimento.observacao_procedimento FROM reg_tb_solicitacoes INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes.id_statussolicitacao=reg_rl_statussolicitacao.id_statussolicitacao) INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento) WHERE id_solicitacao='$idSolicitacao'";
  $stmSolicitacao	= $rsConexao->prepare($sqlSolicitacao);
  $stmSolicitacao	-> execute();
  $rsSolicitacao  = $stmSolicitacao->fetch(PDO::FETCH_OBJ); 
  
  $numeroProtocolo        = $rsSolicitacao->numero_procotolo;
  $tokenSolicitacao       = $rsSolicitacao->token_solicitacao;
  $dataHoraSolicitacao    = $rsSolicitacao->dataHoraSolicitacao;
  $nomeProcedimento       = $rsSolicitacao->nome_procedimento;
  $observacoesSolicitacao = $rsSolicitacao->observacoes_solicitacao;
  
  $dataHoraRegistro       = $rsSolicitacao->dataHoraRegistroAgendamento!="" ? $rsSolicitacao->dataHoraRegistroAgendamento : date("d/m/Y H:i");
  $dataPrevisaoRetirada   = $rsSolicitacao->dataprazo_retirada;
  $origemAgendamento      = $rsSolicitacao->origem_agendamento;
  $observacaoAgendamento  = $rsSolicitacao->observacao_agendamento;
  $habilitaClassificacao  = $idPerfilLogado!="7" && $idPerfilLogado!="8"  ? " disabled" : "";
  $observacoesAnalise     = mb_strtoupper($rsSolicitacao->observacoes_analise)=="<BR>" || $rsSolicitacao->observacoes_analise=="" ? "&nbsp;" : mb_strtoupper($rsSolicitacao->observacoes_analise);

  if(isset($_GET['idagdm'])){
    $liberarBotao = "";
  }else{
    $liberarBotao = " disabled";
  }

  /**** ATUALIAR STATUS DA SOLICITAÇÃO INFORMANDO QUE JÁ ESTÁ EM PROCESSO DE AGENDAMENTO ****/
	$stmPegarEmAgendamento    = $rsConexao->prepare("SELECT em_agendamento FROM reg_tb_solicitacoes WHERE id_solicitacao='$idSolicitacao'");
	$stmPegarEmAgendamento    -> execute();  
  $rsPegarEmAgendamento     = $stmPegarEmAgendamento->fetch(PDO::FETCH_OBJ);
  $solicitacaoEmAgendamento = $rsPegarEmAgendamento->em_agendamento;
  $bloqueioEmAgendamento    = $solicitacaoEmAgendamento == "S" ? " disabled" : "";

	$stmAtuaizaEmAgendamento  = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_agendamento='S' WHERE id_solicitacao='$idSolicitacao'");
	$stmAtuaizaEmAgendamento  -> execute();
  /************************************************************************************/
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header" style="background: url(css/images/bg-title.png); background-repeat: repeat-x; height: 45px !important;">
              <h4 class="card-title" style="font-size: 11pt; margin-top: -8px; color: #fff;">
                <b><i class="icofont icofont-checked"></i>&nbsp;REALIZAR AGENDAMENTO</b>
              </h4>
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <ul class="nav nav-tabs nav-topline">
												<li class="nav-item">
													<a class="nav-link active" id="base-dadosSolicitacao" data-toggle="tab" aria-controls="dadosSolicitacao" href="#dadosSolicitacao" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DA SOLICITAÇÃO&nbsp;&nbsp;</b></a>
												</li>
												<li class="nav-item">
													<a class="nav-link" id="base-documentosAnexos" data-toggle="tab" aria-controls="documentosAnexos" href="#documentosAnexos" aria-expanded="true"><b><i class='icofont icofont-files'></i> DOCUMENTOS ANEXOS DA SOLICITAÇÃO&nbsp;&nbsp;</b></a>
												</li>																		
  										</ul>
                      <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                        <div role="tabpanel" class="tab-pane active" id="dadosSolicitacao" aria-expanded="true" aria-labelledby="base-dadosSolicitacao">
                          <form class="form" style='margin-top:-10px'>
                            <div class="form-body">
                              <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                                <input type="hidden" id="idPaciente" value="<?php echo $idPaciente;?>" disabled />
                                <input type="hidden" id="idSolicitacao" value="<?php echo $idSolicitacao;?>"/>
                                <input type="hidden" id="tokenSolicitacao" value="<?php echo $tokenSolicitacao;?>" disabled/>
                              </h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="nomePaciente">Nome:</label>
                                    <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente;?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="nascimentoPaciente">Nascimento:</label>
                                    <input type="text" id="nascimentoPaciente" class="form-control text-center" value="<?php echo $nascimentoPaciente;?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="idadePaciente">Idade:</label>
                                    <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente;?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cpfPaciente">CPF:</label>
                                    <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente;?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cnsPaciente">Cartão SUS:</label>
                                    <input type="text" id="cnsPaciente" class="form-control text-center" value="<?php echo $cnsPaciente;?>" disabled />
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="form-body" style="background-color:#d2e2e9; border: 1px dotted #8c9ca3; margin-top:-10px; padding-left:10px; padding-right:10px">
																<h4 class="form-section"><i class="icofont icofont-phone"></i> <b>Dados de Contato</b></h4>
																<div class="row">
																	<div class="col-md-4">
																		<div class="form-group">
																			<label for="telefoneCelular1"><b>Telefone 1 | (É Whatsapp?):</b></label>
																			<div class="input-group">
																				<input type="text" id="telefoneCelular1" class="form-control fonecelular-inputmask" value="<?php echo $telefoneCelular1;?>">
																				<div class="input-group-append">
																					<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																						<input type="checkbox" class="switch" id="telefoneCelular1Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" <?php echo $telefoneCelular1Whatsapp;?>/>
																					</div>
																				</div>
																			</div>																			
																		</div>	
																	</div>
																	<div class="col-md-4">
																		<div class="form-group">
																			<label for="telefoneCelular2"><b>Telefone 2 | (É Whatsapp?):</b></label>
																			<div class="input-group">
																				<input type="text" id="telefoneCelular2" class="form-control fonecelular-inputmask" value="<?php echo $telefoneCelular2;?>">
																				<div class="input-group-append">
																					<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																						<input type="checkbox" class="switch" id="telefoneCelular2Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" <?php echo $telefoneCelular2Whatsapp;?>/>
																					</div>
																				</div>
																			</div>																			
																		</div>	
																	</div>
																	<div class="col-md-4">
																		<div class="form-group">
																			<label for="telefoneCelular3"><b>Telefone 3 | (É Whatsapp?):</b></label>
																			<div class="input-group">
																				<input type="text" id="telefoneCelular3" class="form-control fonecelular-inputmask" value="<?php echo $telefoneCelular3;?>">
																				<div class="input-group-append">
																					<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																						<input type="checkbox" class="switch" id="telefoneCelular3Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" <?php echo $telefoneCelular3Whatsapp;?>/>
																					</div>
																				</div>
																			</div>
																		</div>	
																	</div>																	
																</div>
														</div><br>
                            <div class="form-body" style="margin-top: -15px;">
                              <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações da Solicitação</b></h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="dataSolicitacao">Data Hora Solicitação:</label>
                                    <input type="text" class="form-control text-center"  id="dataSolicitacao" value="<?php echo $dataHoraSolicitacao;?>" disabled/>
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="numeroProtocolo">Nº Protocolo:</label>
                                    <input type="text" class="form-control text-center"  id="numeroProtocolo" value="<?php echo $numeroProtocolo;?>" disabled/>
                                  </div>
                                </div>
                                <div class="col-md-7">
                                  <div class="form-group">
                                    <label for="nomeProcedimento">Nome de Procedimentos:</label>
                                    <input type="text" id="nomeProcedimento" class="form-control" value="<?php echo $nomeProcedimento;?>" disabled/>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-15px'>
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <label for="observacaoSolicitacao">Observações da Solicitação:</label>
                                    <input type="text" id="observacaoSolicitacao" class="form-control" value="<?php echo $observacoesSolicitacao;?>" disabled/>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-15px'>
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <label for="observacoesAnalise"><b>Observações da Análise:</b></label>
                                    <label class='label-observacoes' style='padding: 10px'><?php echo $observacoesAnalise?></label>
                                  </div>
                                </div>
                              </div>
                              <div class="form-body" style="background-color:#d2e2e9; border: 1px dotted #8c9ca3; margin-top:-20px">
                                <h4 class="form-section"><i class="icofont icofont-checked"></i><b>Dados do Agendamento</b></h4>
                                <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label for="dataHoraRegistro"><b>Data/Hora Registro:</b></label>
                                      <input type='text' class="form-control text-center" id="dataHoraRegistro" value="<?php echo $dataHoraRegistro;?>" disabled>
                                    </div>
                                  </div>
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label for="prazoRetirada"><b>Prazo de Retirada/Impressão:</b></label>
                                      <input type='date' class="form-control text-center" id="prazoRetirada" value="<?php echo $dataPrevisaoRetirada;?>">
                                    </div>
                                  </div>
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label for="origemAgendamento"><b>Origem do Agendamento:</b></label>
                                      <select class="form-control" id="origemAgendamento">
                                        <option value="">SELECIONE....</option>
                                        <option value="SISREG">SISREG</option>
                                        <option value="POLICLÍNICA">POLICLÍNICA</option>
                                      </select>
                                    </div>
                                  </div>
                                </div>
                                <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-12">
                                    <div class="form-group">
                                      <label for="observacaoAgendamento"><b>Observações do Agendamento:</b></label>
                                      <table style='width:100%'>
                                        <tr>
                                          <td style='background:#FFF;'>
                                            <textarea id="observacaoAgendamento" class="form-control" rows=4><?php echo $observacaoAgendamento;?></textarea>
                                          </td>
                                        </tr>
                                      </table>                                      
                                    </div>
                                  </div>
                                </div>
                                <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label for="tipoDocumento"><b>Tipo de Documento Anexado:</b></label>
                                      <select class="form-control" id="tipoDocumento">
                                        <option value="">SELECIONE....</option>
                                        <?php
                                          $stmTipoDocumento = $rsConexao->prepare("SELECT * FROM reg_rl_tipodocumento WHERE onde_exibir='A' ORDER BY nome_tipodocumento");
                                          $stmTipoDocumento -> execute();
                                          $rsTipoDocumento  = $stmTipoDocumento->fetchAll(PDO::FETCH_ASSOC);
                                          foreach($rsTipoDocumento AS $fieldTipoDocumento){
                                            $idTipoDocumento    = $fieldTipoDocumento['id_tipodocumento'];
                                            $nomeTipoDocumento  = $fieldTipoDocumento['nome_tipodocumento'];
                                            echo "<option value='$idTipoDocumento'>$nomeTipoDocumento</option>";
                                          }
                                        ?>
                                      </select>
                                    </div>
                                  </div>
                                  <div class="col-md-8">
                                    <div class="form-group">                                  
                                      <label for="documentoMedico"><b>Anexar Arquivo do Agendamento:</b></label>
                                      <div class="input-group">
                                        <input type="text" id="nomeArquivoDocumento" name="nomeArquivoDocumento" class="form-control upload-fake" disabled style='width:100%;'>
                                        <input type="file" id="arquivoDocumento" name="arquivoDocumento" class="form-control upload-real" accept=".pdf, .PDF">
                                        <div class="input-group-append">
                                          <div class="float-left" style="margin-top:-41px">
                                            <button type="button" class="btn btn-blue" onClick="adicionarArquivo()" <?php echo $bloqueioEmAgendamento;?>>
                                              <i class="fa fa-check-square-o"></i>Adicionar
                                            </button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <div class="row" style="margin-top: -60px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-12">
                                    <div class="form-group">
                                      <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="documentos_agendados">
                                        <thead>
                                          <tr>
                                            <th style='text-align: center !important; width:80px'>OPÇÕES</th>
                                            <th style='display:none'>idtipodoc</th>
                                            <th style='width: 200px; text-align:center'>DATA/HORA INCLUSÃO</th>
                                            <th style='width: 250px;'>TIPO DE DOCUMENTO</th>
                                            <th>NOME DO ARQUIVO</th>
                                            <th style='width: 200px;'>INCLUÍDO POR</th>
                                          </tr>
                                        </thead>
                                        <tbody style="background-color: #ececec;">
                                          <?php
                                            $numeracaoArquivo       = str_pad($idSolicitacao,10,"0");
                                            $diretorioBaseAgendado  = "docagendamentos/";
                                            $sqlDocumentoAgendado = "SELECT reg_tb_solicitacoes_agendado.id_sca_documentoagendado, date_format(reg_tb_solicitacoes_agendado.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, 
                                            date_format(reg_tb_solicitacoes_agendado.datahora_inclusao,'%H:%i') AS horaInclusao, reg_rl_tipodocumento.nome_tipodocumento, reg_tb_solicitacoes_agendado.pasta_documento, 
                                            reg_tb_solicitacoes_agendado.nomearquivo_documento, reg_tb_solicitacoes_agendado.id_tipodocumento, reg_tb_usuario.nome_usuario, reg_tb_unidade_saude.nome_unidade
                                            FROM reg_tb_solicitacoes_agendado 
                                            INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_agendado.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) 
                                            INNER JOIN reg_tb_usuario ON (reg_tb_solicitacoes_agendado.id_usuario_cadastrou = reg_tb_usuario.id_usuario) 
                                            INNER JOIN reg_tb_unidade_saude ON (reg_tb_usuario.id_unidade = reg_tb_unidade_saude.id_unidade) 
                                            WHERE id_sca_solicitacao='$idSolicitacao'";

                                            $stmDocumentoAgendado = $rsConexao->prepare($sqlDocumentoAgendado);
                                            $stmDocumentoAgendado ->execute();
                                            
                                            if($stmDocumentoAgendado->rowCount()>0){
                                              $rsDocumentoAgendado  = $stmDocumentoAgendado->fetchAll(PDO::FETCH_ASSOC);
                                              $contarDocsAgendado   = 0;
                                              foreach($rsDocumentoAgendado AS $fieldDocumentoAgendado){
                                                $contarDocsAgendado       = $contarDocsAgendado+1;
                                                $idDocumentoAgendado      = $fieldDocumentoAgendado['id_sca_documentoagendado'];
                                                $dataHoraInclusaoAgendado = $fieldDocumentoAgendado['dataInclusao'].' ÀS '. $fieldDocumentoAgendado['horaInclusao'];
                                                $tipoDocumentoAgendado    = $fieldDocumentoAgendado['nome_tipodocumento'];
                                                $idTipoDocumentoAgendado  = $fieldDocumentoAgendado['id_tipodocumento'];
                                                $pastaDocumentoAgendado   = $fieldDocumentoAgendado['pasta_documento'];
                                                $incluidoPor              = $fieldDocumentoAgendado['nome_usuario']."<br>(".$fieldDocumentoAgendado['nome_unidade'].")";
                                                $nomeArquivoAgendado      = mb_strtoupper($fieldDocumentoAgendado['nomearquivo_documento']);
                                          
                                                $arquivoAnexoAgendado     = $diretorioBaseAgendado . $pastaDocumentoAgendado . "/$numeracaoArquivo" . "_" . $fieldDocumentoAgendado['nomearquivo_documento'];
                                          
                                                $cliqueBotaoVisualizarDocumentoAg = 'onClick="window.open('."'$arquivoAnexoAgendado')" . '"';
                                                $botaoVisualizarDocumentoAgendado	= "<i class='icofont icofont-search nova_fonte' title='Visualizar documento anexo.' $cliqueBotaoVisualizarDocumentoAg></i>";;
                                          
                                                $cliqueBotaoExcluirAnexoAgendado = 'onClick="excluirAnexo('."'$idDocumentoAgendado','$arquivoAnexoAgendado','$idSolicitacao')" . '"';
                                                $botaoExcluirAnexoAgendado	= "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Excluir documento.' $cliqueBotaoExcluirAnexoAgendado></i>";;
                                                
                                                echo "<tr>
                                                  <td style='text-align: center !important; width:20px !important'>
                                                    $botaoVisualizarDocumentoAgendado
                                                    $botaoExcluirAnexoAgendado
                                                  </td>
                                                  <td style='display:none' id='idTipoDoc$contarDocsAgendado'>$idTipoDocumentoAgendado</td>
                                                  <td style='width: 80px; text-align:center'>$dataHoraInclusaoAgendado</td>
                                                  <td style='width: 200px;'>$tipoDocumentoAgendado</td>
                                                  <td style='width: 50%;'>$nomeArquivoAgendado</td>
                                                  <td style='font-size:7pt;width: 15%;'>$incluidoPor</td>
                                                </tr>";
                                              }
                                            }
                                          ?>
                                        </tbody>
                                      </table>
                                    </div>
                                  </div>
                                </div>
                              </div><br>
                            </div>
                          </form>
                        </div>
                        <div class="tab-pane" id="documentosAnexos" aria-labelledby="base-documentosAnexos">
                          <div class="row">
                            <div class='col-md-12'>
                              <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="documentos_anexos" style='width:100%'>
                                <thead>
                                  <tr>
                                    <th style='text-align: center !important; width:80px'>OPÇÕES</th>
                                    <th style='display:none'>idtipodoc</th>
                                    <th style='width: 200px; text-align:center'>DATA/HORA INCLUSÃO</th>
                                    <th style='width: 250px;'>TIPO DE DOCUMENTO</th>
                                    <th>NOME DO ARQUIVO</th>                                    
                                  </tr>
                                </thead>
                                <tbody style="background-color: #ececec;">
                                  <?php
                                    $diretorioBase  = "docsolicitacoes/";
                                    $diretorioData  = date("Ym");;
                                    $sqlDocumento = "SELECT reg_tb_solicitacoes_anexos.id_sca_documentoanexo, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, 
                                    date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%H:%i') AS horaInclusao, reg_rl_tipodocumento.nome_tipodocumento, 
                                    reg_tb_solicitacoes_anexos.pasta_documento, reg_tb_solicitacoes_anexos.nomearquivo_documento, reg_tb_solicitacoes_anexos.id_tipodocumento 
                                    FROM reg_tb_solicitacoes_anexos INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_anexos.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) 
                                    WHERE reg_tb_solicitacoes_anexos.id_sca_solicitacao='$idSolicitacao'";

                                    $stmDocumento = $rsConexao->prepare($sqlDocumento);
                                    $stmDocumento ->execute();
                                    
                                    if($stmDocumento->rowCount()>0){
                                      $rsDocumento  = $stmDocumento->fetchAll(PDO::FETCH_ASSOC);
                                      $contarDocs   = 0;
                                      foreach($rsDocumento AS $fieldDocumento){
                                        $contarDocs       = $contarDocs+1;
                                        $idDocumento      = $fieldDocumento['id_sca_documentoanexo'];
                                        $dataHoraInclusao = $fieldDocumento['dataInclusao'].' ÀS '. $fieldDocumento['horaInclusao'];
                                        $tipoDocumento    = $fieldDocumento['nome_tipodocumento'];
                                        $idTipoDocumento  = $fieldDocumento['id_tipodocumento'];
                                        $pastaDocumento   = $fieldDocumento['pasta_documento'];
                                        $nomeArquivo      = mb_strtoupper($fieldDocumento['nomearquivo_documento']);
                                  
                                        $arquivoAnexo     = $nomePastaArquivo = $diretorioBase . $pastaDocumento . "/$tokenSolicitacao" . "_" . $fieldDocumento['nomearquivo_documento'];
                                  
                                        $cliqueBotaoVisualizarDocumento = 'onClick="window.open('."'$arquivoAnexo')" . '"';
                                        $botaoVisualizarDocumento	= "<i class='icofont icofont-search nova_fonte' title='Visualizar documento anexo.' $cliqueBotaoVisualizarDocumento></i>";;
                                  
                                        $cliqueBotaoExcluirAnexo = 'onClick="excluirAnexo('."'$idDocumento','../$arquivoAnexo','$tokenSolicitacao')" . '"';
                                        $botaoExcluirAnexo	= "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Excluir documento.' $cliqueBotaoExcluirAnexo></i>";;
                                        
                                        echo "<tr>
                                          <td style='text-align: center !important; width:20px !important'>$botaoVisualizarDocumento</td>
                                          <td style='display:none' id='idTipoDoc$contarDocs'>$idTipoDocumento</td>
                                          <td style='width: 80px; text-align:center'>$dataHoraInclusao</td>
                                          <td style='width: 200px;'>$tipoDocumento</td>
                                          <td style='width: 60%;'>$nomeArquivo</td>
                                        </tr>";
                                      }
                                    }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante" style='margin-left:-150px'>
  <?php
    $conteudoObservacaoExtra  = "'abrir#$idSolicitacao#$nomePaciente#$nomeProcedimento'";
  ?>
  <button type="button" class="btn btn-blue" onClick="gravarAgendamento()" <?php echo $bloqueioEmAgendamento;?>><i class="fa fa-check-square-o"></i> Confirmar</button>
  <button type="button" class="btn btn-warning" onClick="agendamentoObservacaoExtra(<?php echo $conteudoObservacaoExtra;?>)"><i class="icofont icofont-info"></i> Observação Extra</button>
  <button type="button" class="btn btn-danger" id="btnCancelar" onClick="fecharTelaABA('<?php echo $idSolicitacao;?>')"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>

<?php
include_once("footer.php");
include_once("include/box_obs_agendamento.php");

?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>        
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>

  $("#liSolicitacaoAgendar"). attr('class', 'active');
  $("#liSolicitacaoAgendar").css("border-bottom", "2px solid #c4c8ca");	

  new nicEditor({buttonList : ['bold','italic','underline','left','center','right','indent','outdent','ol','ul','hr','forecolor']}).panelInstance('observacaoAgendamento');

  $('#documentos_agendados').DataTable({
    "paging"				: false,
    "filter"				: false,
    "lengthChange"	: false,
    "info"					: false
  });

  $('#documentos_anexos').DataTable({
    "paging"				: false,
    "filter"				: false,
    "lengthChange"	: false,
    "info"					: false
  });

  $("#arquivoDocumento").change(function(){
    var nomeArquivo = this.files[0].name;
    $("#nomeArquivoDocumento").val(nomeArquivo);
  })

  function adicionarArquivo(){
    
    if($("#tipoDocumento").val()=="" || $("#nomeArquivoDocumento").val()==""){
      swal("Documento Obrigatórios","Você deve informar o tipo de documento e anexar o arquivo do agendamento.", "error");
      return false;
    }  

    if($("#nomeArquivoDocumento").val()!=""){
      let extensoesValidas = /(\.pdf)$/i;
      let nomeArquivo = $('#arquivoDocumento')[0].files[0].name;
      if(extensoesValidas.test(nomeArquivo)==false) {
        swal("Arquivo Inválido","Tipo de arquivo inválido. Só são permitidos arquivos em formato PDF.", "error");
        return false;
      }
    }
    $('#embacado').css('display','block');
    var formData = new FormData();
    formData.append( 'idPaciente', $("#idPaciente").val());
    formData.append( 'idSolicitacao', $("#idSolicitacao").val());
    formData.append( 'tipoDocumento', $("#tipoDocumento").val());
    formData.append( 'arquivoDocumento', $('#arquivoDocumento')[0].files[0]);
    $.ajax({
      type: 'POST',
      url: 'action/gravar_solicitacao_agendado',
      data: formData,
      processData: false,
      contentType: false
    }).done(function (resultadoRetorno) {			
      $('#embacado').css('display','none');
      if(resultadoRetorno=="JáExiste"){
        swal("Documento já Adicionado","O tipo de documento informado já foi adicionado à lista.", "error");
        return false;
      }						
      $('#documentos_agendados').DataTable().destroy();
      $('#documentos_agendados tbody').empty().append(resultadoRetorno);
      $('#documentos_agendados').DataTable({
        "paging"				: false,
        "filter"				: false,
        "lengthChange"	: false,
        "info"					: false
      });
      $("#tipoDocumento").val('');
      $("#nomeArquivoDocumento").val('');
    });

  }

  function excluirAnexo(idDocumento,anexoExcluir, idSolicitacao){

    swal({		
      title: "Exclusão de Documento",
      text: "Confirma exclusão do documento selecionado?",
      icon: "../app-assets/images/question.png",
    
      buttons:{
        confirm: {
          text: "Sim, Confirmar!",
          value: true,
          visible: true,
          className: "btn-success",
          closeModal: false
        },
        cancel:{
          text: "Não, Foi engano!",
          value: null,
          visible: true,
          className: "btn-danger",
          closeModal: false,
        }								
      }

    }).then((isConfirm) => {

      if (isConfirm) {	
        $.ajax({				
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao'				: 'documento_agendado',
            'idRegistroExclusao'  : idDocumento,
            'anexoExcluir'        : anexoExcluir,
            'idSolicitacao'       : idSolicitacao,
          }
        }).done(function(resultadoRetorno){   
          $('#documentos_agendados').DataTable().destroy();
          $('#documentos_agendados tbody').empty().append(resultadoRetorno);
          $('#documentos_agendados').DataTable({
            "paging"				: false,
            "filter"				: false,
            "lengthChange"	: false,
            "info"					: false
          });
          $("#embacado").css("display","none");						
          swal("Exclusão de Documento.", "Exclusão de documento realizada com sucesso.", "info");
        });

      } else {
        swal("Operação Cancelada.", "O documento selecionado não foi excluído.", "info");
      }

    });  

  }

  function fecharJanela(){
    window.close;
  }
  function gravarAgendamento(){

    var totalAnexos           = $("#documentos_agendados").dataTable().fnSettings().fnRecordsTotal();
    var linhaAnexo            = 0;
    var observacaoAgendamento = nicEditors.findEditor('observacaoAgendamento').getContent();

    if($("#prazoRetirada").val() == "" || $("#origemAgendamento").val() == ""){
      swal("Dados Obrigatórios","Você deve preencher da data prazo para retirada e informar a origem do agendamento.", "error");
      return false;
    }

    if(totalAnexos==0){
      swal("Documento Obrigatório","Você ainda não anexou o comprovante do agendamento.", "error");
      return false;
    }

    $("#embacado").css("display","block");
    $.ajax({
      url: 'action/gravar_solicitacao',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoGravacao'             : 'agendamento-registro',
        'idPaciente'                : $("#idPaciente").val(),
        'idSolicitacao'             : $("#idSolicitacao").val(),
        'dataHoraRegistro'          : $("#dataHoraRegistro").val(),
        'telefoneCelular1'					: $("#telefoneCelular1").val(),
			  'telefoneCelular1Whatsapp'  : $("#telefoneCelular1Whatsapp").is(':checked') ? "S" : "N",
			  'telefoneCelular2'					: $("#telefoneCelular2").val(),
			  'telefoneCelular2Whatsapp'	: $("#telefoneCelular2Whatsapp").is(':checked') ? "S" : "N",
			  'telefoneCelular3'					: $("#telefoneCelular3").val(),
			  'telefoneCelular3Whatsapp'	: $("#telefoneCelular3Whatsapp").is(':checked') ? "S" : "N",
        'prazoRetirada'             : $("#prazoRetirada").val(),
        'origemAgendamento'         : $("#origemAgendamento").val(),        
        'observacaoAgendamento'     : observacaoAgendamento
      }
    }).done(function(resultadoRetorno){
      $("#embacado").css("display","none");
      var retornoResultado = resultadoRetorno.split("#");
      if(retornoResultado[0]=="diaInvalido"){
        swal("Data Não Autorizada",retornoResultado[1], "error");  
        return false;
      }
      swal("Registro de Agendamento","Agendamento registrado com sucesso e está disponível para impressão!", "success");
      setTimeout(function(){ 
        window.close();
		  }, 3000);
    });

  }

  $("#origemAgendamento").val("<?php echo $origemAgendamento;?>");
  

  // Exibir mensagem de que já está agendamento //
  var solicitacaoEmAgendamento = "<?php echo $solicitacaoEmAgendamento;?>";
  if(solicitacaoEmAgendamento=="S"){
    swal("Solicitação em Agendamento","Esta solicitação já está sendo agendada por outro usuário. Você não poderá realizar alterações.", "info");
  }

  function fecharTelaABA(idSolicitacao){

    $.ajax({
      url: 'action/gravar_solicitacao',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoGravacao' : 'solicitacao-statusagendamento-não',
        'idSolicitacao' : idSolicitacao
      }
    }).done(function(resultadoRetorno){
      window.close();
    });

  }

function agendamentoObservacaoExtra(conteudoExecucao){
  var opcaoExecucao = conteudoExecucao.split("#");

  switch(opcaoExecucao[0]){
    case "abrir":
    $("#idSolicitacaoObservar").val(opcaoExecucao[1]);
    $("#nomePacienteAgendar").html(opcaoExecucao[2]);
    $("#nomeProcedimentoAgendar").html(opcaoExecucao[3]);
    $("#box_obs_agendamento").modal();
    break;    
    case "confirmar":
      if($("#agendamentoObservacaoExtra").val()==""){
        swal("Dados Obrigatórios.", "Você deve preencher a observação para salvar a informação.", "error");
        return false;
      }
      $.ajax({
        url: 'action/gravar_solicitacao',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoGravacao'               : 'solicitacao-agendamento-obsextra',
          'idSolicitacao'               : $("#idSolicitacaoObservar").val(),
          'agendamentoObservacaoExtra'  : $("#agendamentoObservacaoExtra").val()
        }
      }).done(function(resultadoRetorno){
        swal("Registro de Observação.", "Observação registrada com sucesso.", "success");
      });
    break;
  }
}

  $(window).on("unload", function(e) {  
    e.preventDefault();
    var idSolicitacao = "<?php echo $idSolicitacao;?>"
    $.ajax({
        url: 'action/gravar_solicitacao',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoGravacao' : 'solicitacao-statusagendamento-não',
          'idSolicitacao' : idSolicitacao
        }
    }).done(function(resultadoRetorno){});
  });
  
</script>