<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}

if (isset($_GET['view'])) {
  include_once("header-clean.php");
} else {
  include_once("header.php");
}


require("../database/dbConection.php");
$idPerfilLogado = $_SESSION['idPerfilLogado'];
$unidadeLogada  = $_SESSION['unidadeLogada'];

$idPacienteGet  = $_GET['idpac'];
$getOp          = $_GET['op'];
if ($getOp == "cs") {
  $liHeaderMenu  = "liCadastroSolicitacao";
  $opcaoTela    = "paciente_buscar?op=cs";
} else if ($getOp == "sc") {
  $liHeaderMenu  = "liSolicitacaoConsultar";
  $opcaoTela    = "solicitacao_consultar?op=sc";
} else if ($getOp == "as") {
  $liHeaderMenu  = "liSolicitacaoAgendar";
  $opcaoTela    = "solicitacao_consultar?op=as";
}

if (isset($_GET['view'])) {
  include_once("header-clean.php");
  $comandoFechar = "window.close()";
} else {
  include_once("header.php");
  $comandoFechar = "window.location.href='$opcaoTela'";
}

$sqlPaciente  = "SELECT tb_paciente.*, 
TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, 
tb_cidades.nome_cidade 
FROM tb_paciente 
INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) 
WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente               = $rsPaciente->id_paciente;
$nomePaciente             = $rsPaciente->nome_paciente;
$idadePaciente            = $rsPaciente->idadePaciente;
$sexoPacienteExibir       = $rsPaciente->sexo == "M" ? "MASCULINO" : "FEMININO";
$sexoPaciente             = $rsPaciente->sexo;
$cnsPaciente              = $rsPaciente->cns_paciente;
$cpfPaciente              = $rsPaciente->cpf_paciente;
$municipioPaciente        = $rsPaciente->nome_cidade;
$bairrroPaciente          = $rsPaciente->bairro_paciente;
$ibgeCidadePaciente       = $rsPaciente->codigocidade;
$cartoaSUSAutorizado      = $rsPaciente->cataosusdefora_autorizado;
# -- pegar numeros de telefome e informação de whatsapp -- #
$telefoneCelular1Whatsapp = $rsPaciente->celular1_whatsapp;
$telefoneCelular2Whatsapp = $rsPaciente->celular2_whatsapp;
$telefoneCelular3Whatsapp = $rsPaciente->celular3_whatsapp;
$telefoneCelular1         = $rsPaciente->celular1;
$telefoneCelular1         = str_replace("(", "", $telefoneCelular1);
$telefoneCelular1         = str_replace(")", "", $telefoneCelular1);
$telefoneCelular1         = str_replace(" ", "", $telefoneCelular1);
$telefoneCelular1         = "55" . str_replace("-", "", $telefoneCelular1);
$telefoneCelular2         = $rsPaciente->celular2;
$telefoneCelular2         = str_replace("(", "", $telefoneCelular2);
$telefoneCelular2         = str_replace(")", "", $telefoneCelular2);
$telefoneCelular2         = str_replace(" ", "", $telefoneCelular2);
$telefoneCelular2         = "55" . str_replace("-", "", $telefoneCelular2);
$telefoneCelular3         = $rsPaciente->celular3;
$telefoneCelular3         = str_replace("(", "", $telefoneCelular3);
$telefoneCelular3         = str_replace(")", "", $telefoneCelular3);
$telefoneCelular3         = str_replace(" ", "", $telefoneCelular3);
$telefoneCelular3         = "55" . str_replace("-", "", $telefoneCelular3);
$cataoSUSautorizado       = $rsPaciente->cataosusdefora_autorizado == "S"  ? " - AUTORIZADO" : "";
# -------------------------------------------------------- #

# -- dados de condições de saúde do paciente --#
$pacienteOncologico   = $rsPaciente->condicaosaude_oncolocia == "S" ? " checked" : "";
$pacienteDiabetico    = $rsPaciente->condicaosaude_diabetes == "S" ? " checked" : "";
$pacienteHipertenso   = $rsPaciente->condicaosaude_hipertensao == "S" ? " checked" : "";
$pacienteRenalCronico = $rsPaciente->condicaosaude_renalcronico == "S" ? " checked" : "";
$pacientePCD          = $rsPaciente->condicaosaude_pcd == "S" ? " checked" : "";
$descricaoDeficiencia = $rsPaciente->condicaosaude_pcddescricao;
$bloqueioDescricaoDef = $rsPaciente->condicaosaude_pcd == "S" ? "" : " disabled";
$pacienteAlergico     = $rsPaciente->condicaosaude_alergia == "S" ? " checked" : "";
$descricaoAlergia     = $rsPaciente->condicaosaude_alergiadescricao;
$bloqueioDescricaoAle = $rsPaciente->condicaosaude_alergia == "S" ? "" : " disabled";
# -------------------------------------------------------- #

$formatarOrigem = array(
  'lista_unica'   => 'LISTA ÚNICA',
  'policlinica'   => 'POLICLÍNICA',
  'sisreg'        => 'SISREG',
  'sistema_vida'  => 'VIDA+',
);

if (isset($_GET['idsol'])) {

  $idSolicitacao    = $_GET['idsol'];
  $sqlSolicitacao  = "SELECT * FROM reg_tb_solicitacoes WHERE id_solicitacao='$idSolicitacao'";
  $stmSolicitacao  = $rsConexao->prepare($sqlSolicitacao);
  $stmSolicitacao->execute();
  $rsSolicitacao  = $stmSolicitacao->fetch(PDO::FETCH_OBJ);

  $numeroProtocolo        = $rsSolicitacao->numero_procotolo;
  $tokenSolicitacao       = $rsSolicitacao->token_solicitacao;
  $grupoProcedimento      = $rsSolicitacao->id_grupo_procedimento;
  $idProcedimento         = $rsSolicitacao->id_procedimento;
  $observacoesSolicitacao = $rsSolicitacao->observacoes_solicitacao;
  $idStatusSolicitacao      = $rsSolicitacao->id_statussolicitacao;
  $liberarBotao           = "";
  $observacoesAnalise     = $rsSolicitacao->observacoes_analise;
  $cidSolicitacao         = $rsSolicitacao->cid_solicitacao == "" ? "R69" : $rsSolicitacao->cid_solicitacao;
  $profissionalSolicitante  = $rsSolicitacao->codigoprofissional_cnes == "" ? "SELECIONE..." : $rsSolicitacao->codigoprofissional_cnes;
  $retornoSolicitacao       = $rsSolicitacao->solicitacao_retorno == "" ? "N" : $rsSolicitacao->solicitacao_retorno;
  $classificacaoRisco       = $rsSolicitacao->id_classificacaorisco;
  if ($observacoesAnalise != "") {
    $exbirObservacoesAnalise = " display:block";
  } else {
    $exbirObservacoesAnalise = " display:none";
  }
} else {
  $idSolicitacao            = "";
  $numeroProtocolo          = "-------";
  $tokenSolicitacao         = "";
  $grupoProcedimento        = "";
  $idProcedimento           = "";
  $observacoesSolicitacao   = "";
  $tokenSolicitacao         = strtoupper(substr(md5(uniqid(rand(), true)), 0, 20));
  $idStatusSolicitacao        = "";
  $liberarBotao             = " disabled";
  $exbirObservacoesAnalise  = " display:none";
  $observacoesAnalise       = "";
  $cidSolicitacao           = "";
  $retornoSolicitacao       = "";
  $profissionalSolicitante  = "SELECIONE...";
  $classificacaoRisco       = "";
}

if ((isset($_GET['idsol']) && $idPerfilLogado == 3 && $idStatusSolicitacao != 10) || ($idPerfilLogado != 1 && $idPerfilLogado != 3 && $idPerfilLogado != 6 && $idPerfilLogado != 11 && $idPerfilLogado != 12 && $idPerfilLogado != 20 && $idPerfilLogado != 4)) {
  $bloquearControles  = " disabled";
} else {
  $bloquearControles  = "";
}

$esconderNovaSolictacao = "";
if ($idPerfilLogado != 1 && $idPerfilLogado != 4) {
  $esconderNovaSolictacao = " disabled";
}
$bloquearControlesStatus  = $idStatusSolicitacao >= 4 && $idStatusSolicitacao <= 9 ? " disabled" : "";

$dataSolicitacao = date("d/m/Y");
$siteRegulacaoMunicipal = "https://regulacaomunicipal.pmlf.ba.gov.br/";

# -- validar município do ciente X município  -- #
//Cor alerta fora do município!
$ibgeSedeSistema = $_SESSION['ibgeSedeSistema'];
if ($ibgeCidadePaciente != $_SESSION['ibgeSedeSistema']) {
  $setCorCidade = "style='background-color:#ae0000 !important;color:#fff'";
  $nomeMunicipioSede    = $_SESSION['nomeMunicipioSede'];
} else {
  $setCorCidade         =  "";
  $nomeMunicipioSede    = "";
}

# -- validar inclusão de documentos necessários -- #

// PEGAR DADOS DAS CONFIGURAÇÕES 
$stmConfiguracoes = "SELECT reg_tb_configuracoes.*,
  ucase(tb_cidades.nome_cidade) nomeMunicipio,
  tb_cidades.sigla_estado
  FROM tb_cidades
  INNER JOIN reg_tb_configuracoes ON (tb_cidades.codigoibge_cidade = reg_tb_configuracoes.ibge_municipiogestor)";
$stmConfiguracoes  = $rsConexao->prepare($stmConfiguracoes);
$stmConfiguracoes->execute();

$rsConfiguracoes  = $stmConfiguracoes->fetch(PDO::FETCH_OBJ);
$solicitacaoExigeDocumentoAnexo = $rsConfiguracoes->exigirdocumento_identificacao;
$solicitacaoExigeRequisicao     = $rsConfiguracoes->exigir_requisitaoapac;
$usgMaraExigeMamografia         = $rsConfiguracoes->exigirmamografia_parausgmama;
$mamografiaExigeFormulario      = $rsConfiguracoes->exigirformulario_mamografia;
$solicitacaoParaAnalise         = $rsConfiguracoes->solicitacao_paraanalise;
$exigirRelatorioMedico          = $rsConfiguracoes->exigir_relatoriomedico;
$limitacaoCotas                 = $rsConfiguracoes->controlar_cota;

if ($ibgeCidadePaciente != $_SESSION['ibgeSedeSistema']) {
  $bloquearPacienteFora = ($rsConfiguracoes->bloqueio_pacientefora == "S" && $cartoaSUSAutorizado == "N") ? "S" : "N";
} else {
  $bloquearPacienteFora = "N";
}

$_SESSION['idadeControleMamografia'] = 40;
$idadeControleMamografia        = $_SESSION['idadeControleMamografia'];
# ---------------------------------------------- #

# -- verificar se o cartão SUS do paciente é do município -- #
$stmAutorizadorCNS      = $rsConexao->prepare("SELECT * FROM reg_tb_usuario WHERE id_usuario=" . $_SESSION['idUsuarioLogado']);
$stmAutorizadorCNS->execute();
$rsAutorizadorCNS        = $stmAutorizadorCNS->fetch(PDO::FETCH_OBJ);
$autorizadorCNS          = $_SESSION['autorizadorCNS'];
$bloquearAutorizacaoCNS = $autorizadorCNS == "S" ? "" : " disabled";

# -- verifica se o perfil de acesso é do NGC. Se for bloqueia o acesso grupo -- #
$ngcBloqueiaGrupo = $idPerfilLogado == 20 ? " disabled" : "";
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-law-document" style='margin-top:-15px !important'></i>&nbsp;Cadastrar Solicitação
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <ul class="nav nav-tabs nav-topline">
                      <li class="nav-item">
                        <a class="nav-link active" id="base-dadosSolicitacao" data-toggle="tab" aria-controls="dadosSolicitacao" href="#dadosSolicitacao" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DA SOLICITAÇÃO&nbsp;&nbsp;</b></a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link" id="base-solicitacoesExistentes" data-toggle="tab" aria-controls="solicitacoesExistentes" href="#solicitacoesExistentes" aria-expanded="true"><b><i class='icofont icofont-book-alt'></i> SOLICITAÇÕES EXISTENTES&nbsp;&nbsp;</b></a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link" id="base-historicoMovimentacao" data-toggle="tab" aria-controls="historicoMovimentacao" href="#historicoMovimentacao" aria-expanded="true"><b><i class='icofont icofont-book-alt'></i> HISTÓRICO DE MOVIMENTAÇÃO&nbsp;&nbsp;</b></a>
                      </li>
                    </ul>
                    <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                      <div role="tabpanel" class="tab-pane active" id="dadosSolicitacao" aria-expanded="true" aria-labelledby="base-dadosSolicitacao">
                        <form class="form">
                          <div class="form-body" style='margin-top:-10px'>
                            <h4 class="form-section"><i class="ft-user"></i><b>Informações do Paciente</b>
                              <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                              <input type="hidden" id="idSolicitacao" value="<?php echo $idSolicitacao; ?>" />
                              <input type="hidden" id="tokenSolicitacao" value="<?php echo $tokenSolicitacao; ?>" disabled />
                            </h4>
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label for="nomePaciente">Nome:</label>
                                  <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                                </div>
                              </div>
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="cpfPaciente">CPF:</label>
                                  <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                                </div>
                              </div>
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="cnsPaciente">Cartão SUS:</label>
                                  <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente; ?>" disabled />
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="idadePaciente">Idade:</label>
                                  <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente; ?>" disabled />
                                </div>
                              </div>
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="sexoPaciente">Sexo:</label>
                                  <input type="text" id="sexoPaciente" class="form-control text-center" value="<?php echo $sexoPacienteExibir; ?>" disabled />
                                </div>
                              </div>
                              <div class="col-md-4">
                                <div class="form-group">
                                  <label for="municipioPaciente">Município:</label>
                                  <input type="text" id="municipioPaciente" class="form-control" value="<?php echo $municipioPaciente . $cataoSUSautorizado; ?>" <?php echo $setCorCidade; ?> disabled>
                                </div>
                              </div>
                              <div class="col-md-4">
                                <div class="form-group">
                                  <label for="bairroPaciente">Bairro:</label>
                                  <input type="text" id="municipioPaciente" class="form-control" value="<?php echo $bairrroPaciente; ?>" disabled />
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="form-body" style="background-color:#d2e2e9; border: 1px dotted #8c9ca3; margin-top:-10px; padding-left:10px; padding-right:10px">
                            <h4 class="form-section">
                              <i class="icofont icofont-pulse"></i><b>Condição de Saúde do Paciente</b>
                            </h4>
                            <div class="row">
                              <div class="col-md-12">
                                <div class="form-group">
                                  <table style='width:100%'>
                                    <tr>
                                      <td width='5px'>
                                        <input type="checkbox" id="pacienteOncologico" class="form-control checkbox-seleciona-procedimento-grupo" <?php echo $pacienteOncologico; ?>>
                                      </td>
                                      <td style='padding-top:10px; width:30px;'>
                                        <label for="pacienteOncologico" style='margin-top:-20px'>Oncologia</label>
                                      </td>
                                      <td width='10px'>&nbsp;</td>
                                      <td width='5px'>
                                        <input type="checkbox" id="pacienteDiabetico" class="form-control checkbox-seleciona-procedimento-grupo" <?php echo $pacienteDiabetico; ?>>
                                      </td>
                                      <td style='padding-top:10px; width:30px;'>
                                        <label for="pacienteDiabetico" style='margin-top:-20px'>Diabetes</label>
                                      </td>
                                      <td width='10px'>&nbsp;</td>
                                      <td width='5px'>
                                        <input type="checkbox" id="pacienteHipertenso" class="form-control checkbox-seleciona-procedimento-grupo" <?php echo $pacienteHipertenso; ?>>
                                      </td>
                                      <td style='padding-top:10px; width:30px;'>
                                        <label for="pacienteHipertenso" style='margin-top:-20px'>Hipertensão</label>
                                      </td>
                                      <td width='10px'>&nbsp;</td>
                                      <td width='5px'>
                                        <input type="checkbox" id="pacienteRenalCronico" class="form-control checkbox-seleciona-procedimento-grupo" <?php echo $pacienteRenalCronico; ?>>
                                      </td>
                                      <td style='padding-top:10px; width:100px;'>
                                        <label for="pacienteRenalCronico" style='margin-top:-20px'>Renal Crônico</label>
                                      </td>
                                      <td width='10px'>&nbsp;</td>
                                      <td width='5px'>
                                        <input type="checkbox" id="pacientePCD" class="form-control checkbox-seleciona-procedimento-grupo" onchange="habilitaDescricao('pcd',this.checked)" <?php echo $pacientePCD; ?>>
                                      </td>
                                      <td style='padding-top:10px; width:30px;'>
                                        <label for="pacientePCD" style='margin-top:-20px'>PCD</label>
                                      </td>
                                      <td width='5px'>&nbsp;</td>
                                      <td>
                                        <input type="text" id="descricaoDeficiencia" class="form-control" placeholder="DESCREVA A(S) DEFICIÊNCIA(S)" <?php echo $bloqueioDescricaoDef; ?> value="<?php echo $descricaoDeficiencia; ?>">
                                      </td>
                                      <td width='10px'>&nbsp;</td>
                                      <td width='5px'>
                                        <input type="checkbox" id="pacienteAlergico" class="form-control checkbox-seleciona-procedimento-grupo" onchange="habilitaDescricao('alergia',this.checked)" <?php echo $pacienteAlergico; ?>>
                                      </td>
                                      <td style='padding-top:10px; width:30px;'>
                                        <label for="pacienteAlergico" style='margin-top:-20px'>Alergia</label>
                                      </td>
                                      <td width='5px'>&nbsp;</td>
                                      <td>
                                        <input type="text" id="descricaoAlergia" class="form-control" placeholder="DESCREVA A(S) ALERGIA(S)" <?php echo $bloqueioDescricaoAle; ?> value="<?php echo $descricaoAlergia; ?>">
                                      </td>
                                    </tr>
                                  </table>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="form-body" style="margin-top:5px;">
                            <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações da Solicitação</b></h4>
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="numeroProtocolo">Nº Protocolo:</label>
                                  <input type="text" class="form-control text-center" id="numeroProtocolo" value="<?php echo $numeroProtocolo; ?>" disabled />
                                </div>
                              </div>
                              <div class="col-md-8">
                                <div class="form-group">
                                  <label for="profissionalSolicitante">Profissional Solicitante:</label>
                                  <select class="selectivity-input single-select-box" id="profissionalSolicitante" <?php echo $bloquearControles; ?>>
                                    <option value="">SELECIONE...</option>
                                    <option value="<?php echo $ibgeSedeSistema . '0000000000'; ?>">PROFISSIONAL NÃO LISTADO (OU SOLICITAÇÃO EXTERNA)</option>
                                    <option value="<?php echo $ibgeSedeSistema . '0000000001'; ?>">PROFISSIONAL DA POLICLÍNICA REGIONAL</option>
                                    <?php
                                    $sqlProfissional = "SELECT tb_profissional.codigoprofissional_cnes,
                                      ucase(tb_profissional.nome_profissional) AS nomeProfissional,
                                      rl_cbo.codigo_cbo,
                                      ucase(rl_cbo.nome_cbo) AS nomeCBO
                                      FROM tb_profissional_vinculo
                                      INNER JOIN rl_cbo ON (tb_profissional_vinculo.codigo_cbo = rl_cbo.codigo_cbo)
                                      INNER JOIN tb_profissional ON (tb_profissional_vinculo.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
                                      WHERE (ucase(rl_cbo.nome_cbo) LIKE '%MEDICO%')
                                      OR (ucase(rl_cbo.nome_cbo) LIKE '%ENFERMEIRO%')
                                      OR (ucase(rl_cbo.nome_cbo) LIKE '%DENTIS%')
                                      GROUP BY tb_profissional.codigoprofissional_cnes
                                      ORDER BY tb_profissional.nome_profissional ASC";
                                    $stmProfissional = $rsConexao->prepare($sqlProfissional);
                                    $stmProfissional->execute();
                                    if ($stmProfissional->rowCount() > 0) {
                                      $rsProfissional  = $stmProfissional->fetchAll(PDO::FETCH_ASSOC);
                                      foreach ($rsProfissional as $fieldProfissional) {
                                        $codigoProfissional = $fieldProfissional['codigoprofissional_cnes'];
                                        $nomeProfissional   = $fieldProfissional['nomeProfissional'];
                                        $nomeCBO            = $fieldProfissional['nomeCBO'];
                                        echo "<option value='$codigoProfissional'>$nomeProfissional - ( $nomeCBO )</option>";
                                      }
                                    }
                                    ?>
                                  </select>
                                  <input type="hidden" id="procedimentoSelecionado" class="form-control" />
                                </div>
                              </div>
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="cidSolicitacao">CID:</label>                                  
                                  <div class="input-group">
                                    <div class="input-group-append">
                                      <div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
                                        <button type="button" class="btn btn-green" onClick="abrirPesquisaCid()">
                                          <i class="icofont icofont-search"></i>
                                        </button>
                                      </div>
                                    </div>
                                    <input type="text" id="cidSolicitacao" class="form-control text-center" value="<?php echo $cidSolicitacao; ?>" <?php echo $bloquearControles; ?> disabled/>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="grupoProcedimento">Grupo:</label>
                                  <select class="form-control" id="grupoProcedimento" onchange="filtrarProcedimentos()" <?php echo $bloquearControles . $ngcBloqueiaGrupo; ?>>
                                    <option value="">SELECIONE GRUPO...</option>
                                    <option value="1">NÃO AGRUPADOS</option>
                                    <?php
                                      if ($idPerfilLogado == '3') {
                                        $stmGrupo  = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE disponivel_guiche='S' AND id_grupo_procedimento!='1' ORDER BY nome_grupo_procedimento");
                                      } else if ($idPerfilLogado == '4') {
                                        $stmUnidade = $rsConexao->prepare("SELECT perfil_estabelecimento, codigoestabelecimento_cnes FROM tb_estabelecimento WHERE codigoestabelecimento_cnes='$unidadeLogada'");
                                        $stmUnidade->execute();
                                        $rsUnidade  = $stmUnidade->fetch(PDO::FETCH_OBJ);
                                        if ($rsUnidade->perfil_estabelecimento == "A" || $rsUnidade->perfil_estabelecimento == "E") {
                                          $codigoUnidade = $rsUnidade->codigoestabelecimento_cnes;
                                          $sqlGrupos = "SELECT reg_tb_procedimento_grupo.nome_grupo_procedimento, 
                                          reg_tb_procedimento_grupo.id_grupo_procedimento
                                          FROM reg_tb_tetounidade
                                          INNER JOIN reg_tb_procedimento_grupo ON (reg_tb_tetounidade.id_grupo_procedimento = reg_tb_procedimento_grupo.id_grupo_procedimento)
                                          WHERE (reg_tb_tetounidade.codigoestabelecimento_cnes='$codigoUnidade')
                                          AND (reg_tb_procedimento_grupo.id_grupo_procedimento!='1')
                                          GROUP BY reg_tb_procedimento_grupo.nome_grupo_procedimento";
                                          $stmGrupo  = $rsConexao->prepare($sqlGrupos);
                                        }else{
                                          $stmGrupo  = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE id_grupo_procedimento!='1' ORDER BY nome_grupo_procedimento");
                                        }
                                      } else {
                                        $stmGrupo  = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE id_grupo_procedimento!='1' ORDER BY nome_grupo_procedimento");
                                      }
                                    $stmGrupo->execute();
                                    $rsGrupo = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
                                    $totalGrupo  = $stmGrupo->rowCount();
                                    if ($totalGrupo > 0) {
                                      foreach ($rsGrupo as $fieldGrupo) {
                                        $idGrupo = $fieldGrupo['id_grupo_procedimento'];
                                        $nomeGrupo = mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);
                                        echo "<option value='$idGrupo'>$nomeGrupo</option>";
                                      }
                                    }
                                    ?>
                                  </select>
                                </div>
                              </div>
                              <div class="col-md-4">
                                <div class="form-group">
                                  <label for="nomeProcedimento">Nome do Procedimento:</label>
                                  <select class="form-control" id="nomeProcedimento" <?php echo $bloquearControles; ?>>
                                    <option value="">SELECIONE O GRUPO...</option>
                                  </select>
                                  <input type="hidden" id="procedimentoSelecionado" class="form-control" />
                                  <input type="hidden" id="idProcedimentoEditado" class="form-control" value="<?php echo $idProcedimento; ?>" />
                                </div>
                              </div>
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="retornoSolicitacao">Retorno:</label>
                                  <select id="retornoSolicitacao" class="form-control" <?php echo $bloquearControles; ?>>
                                    <option value=''>SELECIONE...</option>
                                    <option value='S'>SIM</option>
                                    <option value='N'>NÃO</option>
                                  </select>
                                </div>
                              </div>
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="classificacaoPrioridade">Classificação:
                                    <i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover"
                                      data-content="Emergência (Prioridade Zero - Necessidade de atendimento imediato.)
                                    | Muito Urgente (Prioridade 1 - Atendimento o mais rápido possível.
                                    | Pouco Urgente (Prioridade 2 - Não urgente, porém prioritário.
                                    | Eletivo (Prioridade 3 - Atendimento eletivo. Respeitar fila.)"
                                      data-trigger="hover" data-original-title="Classificação de Risco"></i>
                                  </label>
                                  <select id="classificacaoPrioridade" class="form-control" <?php echo $bloquearControles; ?>>
                                    <option value=''>SELECIONE...</option>
                                    <?php
                                    $stmClassificacao = $rsConexao->prepare("SELECT * FROM reg_rl_classificacaorisco ORDER BY nome_classificacaorisco");
                                    $stmClassificacao->execute();
                                    $rsClassificacao  = $stmClassificacao->fetchAll(PDO::FETCH_ASSOC);

                                    foreach ($rsClassificacao as $fieldClassificacao) {
                                      $idClassificacao    = $fieldClassificacao['id_classificacaorisco'];
                                      $nomeClassificacao  = $fieldClassificacao['nome_classificacaorisco'];
                                      echo "<option value='$idClassificacao'>$nomeClassificacao</option>";
                                    }
                                    ?>
                                  </select>
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top:-15px !important; display:none" id='div-observacaoProcedimento'>
                              <div class='col-md-12'>
                                <div id="accordionWrap4" role="tablist" aria-multiselectable="true">
                                  <div class="card collapse-icon accordion-icon-rotate">
                                    <div id="heading42" class="card-header bg-danger" style='padding:10px !important'>
                                      <a data-toggle="collapse" data-parent="#accordionWrap4" href="#acordProcedimento" aria-expanded="false" aria-controls="acordProcedimento" class="card-title lead white collapsed">
                                        <i class="icofont icofont-info-square"></i> <b>Observações do Procedimento</b>
                                      </a>
                                    </div>
                                    <div id="acordProcedimento" role="tabpanel" aria-labelledby="heading42" class="border-danger card-collapse collapse" aria-expanded="false">
                                      <div class="card-content">
                                        <div class="card-body" style='padding:10px !important; font-weight: bold;'>
                                          <label id="texto-observacao-procedimento"></label>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="row" style='margin-top:-15px; <?php echo $exbirObservacoesAnalise; ?>'>
                              <div class="col-md-12">
                                <div class="form-group">
                                  <label for="observacoesAnalise" style='margin-top:-10px'><b>Observações da Análise:</b></label>
                                  <label class='label-observacoes' style='padding: 10px'><?php echo $observacoesAnalise ?></label>
                                </div>
                              </div>
                            </div>
                            <div class="row" style='margin-top:-5px'>
                              <div class="col-md-12">
                                <div class="form-group">
                                  <label for="observacaoSolicitacao">Observação/Justificativa:</label>
                                  <input type="text" id="observacaoSolicitacao" class="form-control" value="<?php echo $observacoesSolicitacao; ?>" <?php echo $bloquearControles; ?> />
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="tipoDocumento">Tipo de Documento:</label>
                                  <select class="form-control" id="tipoDocumento" <?php echo $bloquearControles; ?>>
                                    <option value="">SELECIONE....</option>
                                    <?php
                                    $stmTipoDocumento = $rsConexao->prepare("SELECT * FROM reg_rl_tipodocumento WHERE onde_exibir='S' ORDER BY nome_tipodocumento");
                                    $stmTipoDocumento->execute();
                                    $rsTipoDocumento  = $stmTipoDocumento->fetchAll(PDO::FETCH_ASSOC);
                                    foreach ($rsTipoDocumento as $fieldTipoDocumento) {
                                      $idTipoDocumento    = $fieldTipoDocumento['id_tipodocumento'];
                                      $nomeTipoDocumento  = $fieldTipoDocumento['nome_tipodocumento'];
                                      echo "<option value='$idTipoDocumento'>$nomeTipoDocumento</option>";
                                    }
                                    ?>
                                  </select>
                                </div>
                              </div>
                              <div class="col-md-9">
                                <div class="form-group">
                                  <label for="documentoMedico">Anexar Arquivo:</label>
                                  <div class="input-group">
                                    <input type="text" id="nomeArquivoDocumento" name="nomeArquivoDocumento" class="form-control upload-fake" disabled style='width:100%;'>
                                    <input type="file" id="arquivoDocumento" name="arquivoDocumento" class="form-control upload-real" accept=".pdf, .PDF">
                                    <div class="input-group-append">
                                      <div class="float-left" style="margin-top:-41px">
                                        <button type="button" class="btn btn-info" id="btnAdicionarArquivo" onClick="adicionarArquivo()" <?php echo $bloquearControles . $bloquearControlesStatus; ?>>
                                          <i class="fa fa-check-square-o"></i>Adicionar
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top:-72px !important">
                              <div class='col-md-12'>
                                <div class="bs-callout-warning callout-square callout-bordered mt-1">
                                  <div class="media align-items-stretch">
                                    <div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
                                      <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                                    </div>
                                    <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                                      <strong>ATENÇÃO!</strong> <b>São aceitos pelo sistema apenas arquivos em formado PDF. Arquivos aleatórios anexados à solicitação impedirá a realização do agendamento do paciente. Possíveis questionamentos do paciente ou ouvidoria serão direcionados ao responsável pelo registro da solicitação.</b>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top:5px !important">
                              <div class='col-md-12'>
                                <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="documentos_anexos">
                                  <thead>
                                    <tr>
                                      <th style="text-align: center !important;" width="100px">OPÇÕES</th>
                                      <th style='display:none'>idtipodoc</th>
                                      <th style="width: 200px; text-align:center">DATA/HORA INCLUSÃO</th>
                                      <th style="width: 250px;">TIPO DE DOCUMENTO</th>
                                      <th>NOME DO ARQUIVO</th>
                                    </tr>
                                  </thead>
                                  <tbody style="background-color: #ececec;">
                                    <?php
                                    $diretorioBase    = "docsolicitacoes/";
                                    $diretorioData    = date("Ym");
                                    $whereDocumentos  = $idSolicitacao == "" ? " WHERE token_solicitacao='$tokenSolicitacao'" : " WHERE id_sca_solicitacao='$idSolicitacao'";
                                    $sqlDocumento = "SELECT reg_tb_solicitacoes_anexos.id_sca_documentoanexo, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, 
                                      date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%H:%i') AS horaInclusao, reg_rl_tipodocumento.nome_tipodocumento, 
                                      reg_tb_solicitacoes_anexos.pasta_documento, reg_tb_solicitacoes_anexos.nomearquivo_documento, reg_tb_solicitacoes_anexos.id_tipodocumento 
                                      FROM reg_tb_solicitacoes_anexos INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_anexos.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) 
                                      $whereDocumentos";
                                    $stmDocumento = $rsConexao->prepare($sqlDocumento);
                                    $stmDocumento->execute();

                                    if ($stmDocumento->rowCount() > 0) {
                                      $rsDocumento  = $stmDocumento->fetchAll(PDO::FETCH_ASSOC);
                                      $contarDocs   = 0;
                                      foreach ($rsDocumento as $fieldDocumento) {
                                        $contarDocs       = $contarDocs + 1;
                                        $idDocumento      = $fieldDocumento['id_sca_documentoanexo'];
                                        $dataHoraInclusao = $fieldDocumento['dataInclusao'] . ' ÀS ' . $fieldDocumento['horaInclusao'];
                                        $tipoDocumento    = $fieldDocumento['nome_tipodocumento'];
                                        $idTipoDocumento  = $fieldDocumento['id_tipodocumento'];
                                        $pastaDocumento   = $fieldDocumento['pasta_documento'];
                                        $nomeArquivo      = mb_strtoupper($fieldDocumento['nomearquivo_documento']);

                                        $arquivoAnexo     = $nomePastaArquivo = $diretorioBase . $pastaDocumento . "/$tokenSolicitacao" . "_" . $fieldDocumento['nomearquivo_documento'];

                                        $cliqueBotaoVisualizarDocumento = 'onClick="window.open(' . "'$arquivoAnexo')" . '"';
                                        $botaoVisualizarDocumento  = "<i class='icofont icofont-search nova_fonte' title='Visualizar documento anexo.' $cliqueBotaoVisualizarDocumento></i>";;

                                        $cliqueBotaoExcluirAnexo = 'onClick="excluirAnexo(' . "'$idDocumento','../$arquivoAnexo','$tokenSolicitacao')" . '"';
                                        $botaoExcluirAnexo  = "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Excluir documento.' $cliqueBotaoExcluirAnexo></i>";;

                                        echo "<tr>
                                          <td align='center'>
                                            $botaoVisualizarDocumento
                                            $botaoExcluirAnexo
                                          </td>
                                          <td style='display:none' id='idTipoDoc$contarDocs'>$idTipoDocumento</td>
                                          <td align='center'>$dataHoraInclusao</td>
                                          <td>$tipoDocumento</td>
                                          <td id='tdNomeArquivo$contarDocs'>$nomeArquivo</td>
                                        </tr>";
                                      }
                                    }
                                    ?>
                                  </tbody>
                                </table>
                              </div>
                            </div><br><br>
                          </div>
                        </form>
                      </div>
                      <div class="tab-pane" id="solicitacoesExistentes" aria-labelledby="base-solicitacoesExistentes">
                        <div class="row" style="margin-top:-15px !important">
                          <div class='col-md-12'>
                            <div class="bs-callout-blue callout-square callout-bordered mt-1">
                              <div class="media align-items-stretch">
                                <div class="media-left d-flex align-items-center bg-blue p-2" style='padding:7px !important;'>
                                  <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                                </div>
                                <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                                  A tabela abaixo lista todas as solicitações existentes para este paciente.
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="row" style="margin-top:-4px;">
                          <div class="col-md-12">
                            <div class="form-group">
                              <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="lista_solicitacoes">
                                <thead>
                                  <tr>
                                    <th style="text-align:center">DATA/HORA REGISTRO</th>
                                    <th>PROCEDIMENTO</th>
                                    <th>STATUS</th>
                                    <th>PROTOCOLO</th>
                                    <th>PRAZO RETIRADA</th>
                                    <th>REGISTRADO POR</th>
                                  </tr>
                                </thead>
                                <tbody style="background-color: #ececec;">
                                  <?php
                                  $sqlSolicitacoes = "SELECT reg_tb_solicitacoes.id_solicitacao, reg_tb_solicitacoes.numero_procotolo, reg_tb_procedimento.nome_procedimento, 
                                  date_format(reg_tb_solicitacoes.datahora_cadastro,'%d/%m/%Y') AS dataHoraRegistro, date_format(reg_tb_solicitacoes.dataprazo_retirada,'%d/%m/%Y') AS dataPrazoRetirada, 
                                  reg_tb_solicitacoes.id_statussolicitacao, reg_rl_statussolicitacao.nome_statusslicitacao, reg_tb_usuario.nome_usuario, tb_estabelecimento.nfantasia_estabelecimento
                                  FROM reg_tb_solicitacoes
                                  INNER JOIN reg_tb_usuario ON (reg_tb_solicitacoes.id_usuario_cadastrou = reg_tb_usuario.id_usuario)
                                  INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento)
                                  INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes.id_statussolicitacao = reg_rl_statussolicitacao.id_statussolicitacao)
                                  INNER JOIN tb_estabelecimento ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_solicitacoes.id_unidade_cadastrou)
                                  WHERE reg_tb_solicitacoes.id_paciente='$idPaciente'";
                                  $stmSolicitacoes = $rsConexao->prepare($sqlSolicitacoes);
                                  $stmSolicitacoes->execute();
                                  if ($stmSolicitacoes->rowCount() > 0) {
                                    $rsSolicitacao  = $stmSolicitacoes->fetchAll(PDO::FETCH_ASSOC);
                                    foreach ($rsSolicitacao as $fieldSolicitacao) {
                                      $idSolicitacaoImprimir  = $fieldSolicitacao['id_solicitacao'];
                                      $dataHoraRegistro       = $fieldSolicitacao['dataHoraRegistro'];
                                      $nomeProcedimento       = $fieldSolicitacao['nome_procedimento'];
                                      $statusSolicitacao      = $fieldSolicitacao['nome_statusslicitacao'];
                                      $numeroProcotolo        = $fieldSolicitacao['numero_procotolo'];
                                      $dataPrazoRetirada      = $fieldSolicitacao['dataPrazoRetirada'] != "" ? $fieldSolicitacao['dataPrazoRetirada'] : "N/A";
                                      $registradoPor          = mb_strtoupper($fieldSolicitacao['nome_usuario'] . "<br>(" . $fieldSolicitacao['nfantasia_estabelecimento'] . ")");


                                      if ($fieldSolicitacao['id_statussolicitacao'] != 3) {
                                        $comandoImpressao       = 'onClick="window.open(' . "'imprimir_protocolo?idsol=$idSolicitacaoImprimir')" . '"';
                                        $botaoComandoImpressao  = "<i class='icofont icofont-print nova_fonte' title='Imprimir prococolo de solicitação.' $comandoImpressao></i>&nbsp;";
                                      } else {
                                        $botaoComandoImpressao  = "";
                                      }

                                      echo "<tr>
                                          <td align='center' style='width:10%'>$dataHoraRegistro</td>
                                          <td>$nomeProcedimento</td>
                                          <td>$statusSolicitacao</td>
                                          <td align='center'>$numeroProcotolo&nbsp;$botaoComandoImpressao</td>
                                          <td align='center' style='width:10%'>$dataPrazoRetirada</td>
                                          <td>$registradoPor</td>
                                        </tr>";
                                    }
                                  }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="tab-pane" id="historicoMovimentacao" aria-labelledby="base-historicoMovimentacao">
                        <div class="row" style="margin-top:-15px !important">
                          <div class='col-md-12'>
                            <div class="bs-callout-success callout-square callout-bordered mt-1">
                              <div class="media align-items-stretch">
                                <div class="media-left d-flex align-items-center bg-success p-2" style='padding:7px !important;'>
                                  <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                                </div>
                                <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                                  A tabela abaixo mostra todas as movimentações registradas para esta solicitação
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="row" style="margin-top:-4px;">
                          <div class="col-md-12">
                            <div class="form-group">
                              <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="lista_historico">
                                <thead>
                                  <tr>
                                    <th style="text-align:center">DATA/HORA REGISTRO</th>
                                    <th>AÇÃO REALIZADA</th>
                                    <th>STATUS</th>
                                    <th style='width:40%'>OBSERVAÇÕES</th>
                                    <th>REGISTRADO POR</th>
                                  </tr>
                                </thead>
                                <tbody style="background-color: #ececec;">
                                  <?php
                                  $sqlMovimento = "SELECT reg_tb_solicitacoes.*, date_format(reg_tb_solicitacoes_historico.datahora_registro,'%d/%m/%Y %H:%i') AS dataHoraRegistro, 
                                  reg_tb_solicitacoes_historico.texto_movimentacao, reg_rl_statussolicitacao.nome_statusslicitacao, reg_tb_usuario.nome_usuario AS registradoPor, 
                                  reg_tb_solicitacoes_historico.id_statussolicitacao AS statusSolicitacaoHistorico 
                                    FROM reg_tb_solicitacoes_historico 
                                    INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes_historico.id_statussolicitacao=reg_rl_statussolicitacao.id_statussolicitacao)
                                    INNER JOIN reg_tb_solicitacoes ON (reg_tb_solicitacoes_historico.id_solicitacao = reg_tb_solicitacoes.id_solicitacao)
                                    LEFT JOIN reg_tb_usuario ON (reg_tb_solicitacoes_historico.idusuario_registrou = reg_tb_usuario.id_usuario) 
                                    WHERE reg_tb_solicitacoes_historico.id_solicitacao='$idSolicitacao'";
                                  $stmMovimento = $rsConexao->prepare($sqlMovimento);
                                  $stmMovimento->execute();
                                  if ($stmMovimento->rowCount() > 0) {
                                    $textoObservacoes   = "";
                                    $rsMovimento  = $stmMovimento->fetchAll(PDO::FETCH_ASSOC);
                                    foreach ($rsMovimento as $fieldMovimento) {
                                      $dataHoraRegistro   = $fieldMovimento['dataHoraRegistro'];
                                      $statusSolicitacao  = $fieldMovimento['nome_statusslicitacao'];
                                      if ($fieldMovimento['registradoPor'] != "") {
                                        $registradoPor  = mb_strtoupper($fieldMovimento['registradoPor']);
                                        $tipoMovimento  = mb_strtoupper($fieldMovimento['texto_movimentacao']);
                                      } else {
                                        $registradoPor    = "ATENDIMENTO VIRTUAL";
                                        $explodeMovimento = explode("##", $fieldMovimento['texto_movimentacao']);
                                        $tipoMovimento    = mb_strtoupper($explodeMovimento[0]);
                                        $textoObservacoes = mb_strtoupper($explodeMovimento[1]);
                                      }

                                      switch ($fieldMovimento['statusSolicitacaoHistorico']) {
                                        case 1:
                                          $textoObservacoes = mb_strtoupper($fieldMovimento['observacoes_solicitacao']);
                                          break;
                                        case 2:
                                        case 9:
                                        case 10:
                                          $textoObservacoes = mb_strtoupper($fieldMovimento['observacoes_analise']);
                                          break;
                                        case 3:
                                          if ($tipoMovimento == "REALIZOU COMUNICAÇÃO WHATSAPP") {
                                            if ($fieldMovimento['observacoes_comunicacao'] != "") {
                                              $textoObservacoes = mb_strtoupper($fieldMovimento['observacoes_comunicacao']);
                                            } else {
                                              $textoObservacoes = "SEM OBSERVAÇÕES DA COMUNICAÇÃO";
                                            }
                                          } else {
                                            $textoObservacoes = mb_strtoupper($fieldMovimento['observacao_agendamento']);
                                          }
                                          break;
                                        case 4:
                                        case 5:
                                          $textoObservacoes = mb_strtoupper($fieldMovimento['justificativa_solicitacaocancelamento'] . '<br>' . $fieldMovimento['informacoes_cancelamento']);
                                          break;
                                      }


                                      echo "<tr>
                                          <td align='center' style='width:15%'>$dataHoraRegistro</td>
                                          <td>$tipoMovimento</td>
                                          <td>$statusSolicitacao</td>
                                          <td style='width:40%'>$textoObservacoes</td>
                                          <td>$registradoPor</td>
                                        </tr>";
                                    }
                                  }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante" style='left: 38.5%;'>
  <button type="button" class="btn btn-blue" onClick="gravarSolicitacao()" id="salvarSolicitacao" <?php echo $bloquearControles . $bloquearControlesStatus; ?>><i class="fa fa-check-square-o"></i> Confirmar</button>
  <button type="button" class="btn btn-dark" id="imprimirProtocolo" onClick="imprimirProtocolo()" <?php echo $liberarBotao . $bloquearControlesStatus; ?>><i class="icofont icofont-printer"></i> Protocolo</button>
  <button type="button" class="btn btn-green" id="btnNovoPaciente" onClick="novaSolicitacao()" <?php echo $liberarBotao . $esconderNovaSolictacao . $bloquearControlesStatus; ?>><i class="ft-file"></i> Nova Solicitação</button>
  <button type="button" class="btn btn-danger" id="btnCancelar" onClick="<?php echo $comandoFechar;?>"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>

<?php
include_once("footer.php");
include_once("include/box_pesquisa_cid.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#<?php echo $liHeaderMenu; ?>").attr('class', 'active');
  $("#<?php echo $liHeaderMenu; ?>").css("border-bottom", "2px solid #c4c8ca");

  var bloquearPacienteFora = "<?php echo $bloquearPacienteFora; ?>";
  var nomeMunicipioSede = "<?php echo $nomeMunicipioSede; ?>";

  $('#documentos_anexos').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  $('#lista_historico').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  $('#lista_solicitacoes').DataTable({
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  $("#arquivoDocumento").change(function() {
    var nomeArquivo = this.files[0].name;
    $("#nomeArquivoDocumento").val(nomeArquivo);
  })

  function adicionarArquivo() {

    var contadorLinha = 0;
    var totalAnexos = $("#documentos_anexos").dataTable().fnSettings().fnRecordsTotal();


    if ($("#tipoDocumento").val() == "" || $("#nomeArquivoDocumento").val() == "") {
      swal("Documento Obrigatórios", "Você deve selecionar um arquivo para adicionar à lista de documentos.", "error");
      return false;
    }

    if ($("#nomeArquivoDocumento").val() != "") {
      let extensoesValidas = /(\.pdf)$/i;
      let nomeArquivo = $('#arquivoDocumento')[0].files[0].name;
      if (extensoesValidas.test(nomeArquivo) == false) {
        swal("Arquivo Inválido", "Tipo de arquivo inválido. Só são permitidos arquivos em formato PDF.", "error");
        return false;
      }
      if (totalAnexos > 0) {
        for (contadorLinha = 1; contadorLinha <= totalAnexos; contadorLinha++) {
          if ($("#tdNomeArquivo" + contadorLinha).html() == nomeArquivo.toUpperCase()) {
            swal("Arquivo Duplicado", "Já existe um arquivo com o mesmo nome do arquivo selecionado para esta solicitação. Adiciona o arquivo com outro nome!", "error");
            return false;
          }
        }
      }
    }


    $('#embacado').css('display', 'block');
    var formData = new FormData();
    formData.append('idPaciente', $("#idPaciente").val());
    formData.append('idSolicitacao', $("#idSolicitacao").val());
    formData.append('tipoDocumento', $("#tipoDocumento").val());
    formData.append('tokenSolicitacao', $("#tokenSolicitacao").val());
    formData.append('arquivoDocumento', $('#arquivoDocumento')[0].files[0]);

    $.ajax({
      type: 'POST',
      url: 'action/gravar_solicitacao_anexo',
      data: formData,
      processData: false,
      contentType: false
    }).done(function(resultadoRetorno) {
      $('#embacado').css('display', 'none');
      if (resultadoRetorno == "JáExiste") {
        swal("Documento já Adicionado", "O tipo de documento informado já foi adicionado à lista.", "error");
        return false;
      }
      $('#documentos_anexos').DataTable().destroy();
      $('#documentos_anexos tbody').empty().append(resultadoRetorno);
      $('#documentos_anexos').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
      $("#tipoDocumento").val('');
      $("#nomeArquivoDocumento").val('');
      $("#arquivoDocumento").val('');
    });

  }

  function buscarObservacaoProcedimento(idProcedimento) {

    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'buscar_observacao',
        'idProcedimento': idProcedimento
      }
    }).done(function(resultadoRetorno) {
      if (resultadoRetorno != "NãoExiste") {
        $('#texto-observacao-procedimento').html(resultadoRetorno);
        $("#div-observacaoProcedimento").css('display', 'block');
      } else {
        $("#div-observacaoProcedimento").css('display', 'none');
        $('#texto-observacao-procedimento').html('');
      }
    });

  }

  $('#nomeProcedimento').change(function() {

    if (this.value != "") {

      var nomeProcedimento = "";
      if ($("#nomeProcedimento").val() != "") {
        nomeProcedimento = $('#nomeProcedimento').find(":selected").text();
      } else {
        nomeProcedimento = "";
      }
      $("#procedimentoSelecionado").val(nomeProcedimento);

    } else {
      $("#div-observacaoProcedimento").css('display', 'none');
      $('#texto-observacao-procedimento').html('');
    }
  });

  function gravarSolicitacao() {

    var totalAnexos = $("#documentos_anexos").dataTable().fnSettings().fnRecordsTotal();
    var procedimentoSelecionado = $("#procedimentoSelecionado").val();
    var idProcedimentoSelecionado = $("#nomeProcedimento").val();
    var idadePaciente = $("#idadePaciente").val();
    var profissionalSolicitante = $("#profissionalSolicitante").selectivity("value");
    var retornoSolicitacao = $("#retornoSolicitacao").val();
    var classificacaoPrioridade = $("#classificacaoPrioridade").val();
    var validarMamogradia = true;
    var validarRequisicao = false;
    var linhaAnexo = 0;

    var solicitacaoExigeDocumentoAnexo = "<?php echo $solicitacaoExigeDocumentoAnexo; ?>";
    var solicitacaoExigeRequisicao = "<?php echo $solicitacaoExigeRequisicao; ?>";
    var usgMaraExigeMamografia = "<?php echo $usgMaraExigeMamografia; ?>";
    var mamografiaExigeFormulario = "<?php echo $mamografiaExigeFormulario; ?>";
    var solicitacaoParaAnalise = "<?php echo $solicitacaoParaAnalise; ?>";
    var exigirRelatorioMedico = "<?php echo $exigirRelatorioMedico; ?>";

    var idadeControleMamografia = "<?php echo $idadeControleMamografia; ?>";
    var ibgeSedeSistema = "<?php echo $ibgeSedeSistema; ?>";

    if ($("#grupoProcedimento").val() == "" || $("#nomeProcedimento").val() == "" || $("#cidSolicitacao").val() == "" || profissionalSolicitante == "SELECIONE...") {
      swal("Dados Obrigatórios", "Você deve preencher todos os dados do agendamento.", "error");
      return false;
    }

    if (retornoSolicitacao == "S" && (profissionalSolicitante == "SELECIONE..." || profissionalSolicitante == ibgeSedeSistema + "0000000000")) {
      swal("Solicitante Inválido", "Profissional solicitante informado é incompatível com solicitação de retorno.", "error");
      return false;
    }

    if (retornoSolicitacao == "") {
      swal("Registro de Retorno", "Você deve informar se a solicitação é para retorno ou não.", "error");
      return false;
    }

    //#----------------------------VALIDAR DOCUMENTOS ANEXOS SE CONFIGURADO COMO EXIGIDO ----------------------------#//

    // exigir documento de identificação ou cartão SUS
    if (solicitacaoExigeDocumentoAnexo == "S") {
      var exigirDocumento = false;
      for (linhaAnexo = 1; linhaAnexo <= totalAnexos; linhaAnexo++) {
        if (($("#idTipoDoc" + linhaAnexo).html() == "1") || ($("#idTipoDoc" + linhaAnexo).html() == "2")) {
          exigirDocumento = true;
        }
      }
      if (exigirDocumento == false) {
        swal("Documento Obrigatório", "Você deve anexar cópia do cartão SUS ou documento de identificação do paciente.", "error");
        return false;
      }
    }

    // exigir requisição de procedimento / apac
    if (solicitacaoExigeRequisicao == "S") {
      var exigirRequisicao = false;
      for (linhaAnexo = 1; linhaAnexo <= totalAnexos; linhaAnexo++) {
        if ($("#idTipoDoc" + linhaAnexo).html() == "3") {
          exigirRequisicao = true;
        }
      }
      if (exigirRequisicao == false) {
        swal("Anexar Requisição", "Você deve anexar cópia da requisição de procedimento ou APAC da solicitação.", "error");
        return false;
      }
    }

    if (classificacaoPrioridade == "") {
      swal("Classificação de Risco", "Você deve selecionar a classificação de prioridade da solicitação.", "error");
      return false;
    }

    if ((solicitacaoParaAnalise == "emergência" && exigirRelatorioMedico == "S" && classificacaoPrioridade == "1") ||
      (solicitacaoParaAnalise == "emergência-murgente" && exigirRelatorioMedico == "S" && (classificacaoPrioridade == "1" || classificacaoPrioridade == "2"))) {
      var relatorioMedicoAnexado = false;
      for (linhaAnexo = 1; linhaAnexo <= totalAnexos; linhaAnexo++) {
        if ($("#idTipoDoc" + linhaAnexo).html() == "4") {
          relatorioMedicoAnexado = true;
        }
      }
      if (relatorioMedicoAnexado == false) {
        swal("Relatório Médico", "As solicitações de emergêcia requerem relatório médico em anexo para análise do regulador.", "error");
        return false;
      }
    }

    //#----------------------------VALIDAR ULTRASSONOGRAFIA DE MAMA----------------------------#//
    var validarUltrassonMama = true;
    if (idadePaciente > idadeControleMamografia && usgMaraExigeMamografia == "S") {
      if (procedimentoSelecionado.indexOf("ULTRA-SONOGRAFIA DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASONOGRAFIA DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSONOGRAFIA DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRA-SONOGRAFIA DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASONOGRAFIA DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSONOGRAFIA DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRA-SONOGRAFIA MAMARIA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASONOGRAFIA MAMARIA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSONOGRAFIA MAMARIA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASON DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASON DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSON DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSON DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("USG DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("USG DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("USG MAMARIA") != -1) {
        validarUltrassonMama = false;
      }

      if (validarUltrassonMama == false) {
        for (linhaAnexo = 1; linhaAnexo <= totalAnexos; linhaAnexo++) {
          if ($("#idTipoDoc" + linhaAnexo).html() == "5") {
            validarUltrassonMama = true;
          }
        }
      }

      if (validarUltrassonMama == false) {
        swal("Resultado da Mamografia", "Para solicitar " + procedimentoSelecionado + ", você deve anexar o resultado da mamografia, sem isto não é possível realizar a solicitação.", "error");
        return false;
      }

    }
    //#----------------------------------------------------------------------------------------#//  

    //#----------------------------------VALIDAR MAMOGRAFIA------------------------------------#//
    if (mamografiaExigeFormulario == "S") {
      if (procedimentoSelecionado.indexOf("MAMOGRAFIA") != -1) {
        validarMamogradia = false;
      }
      if (validarMamogradia == false) {
        for (linhaAnexo = 1; linhaAnexo <= totalAnexos; linhaAnexo++) {
          if ($("#idTipoDoc" + linhaAnexo).html() == "6") {
            validarMamogradia = true;
          }
        }
      }
      if (validarMamogradia == false) {
        swal("Formulário de Mamografia", "Para solicitar " + procedimentoSelecionado + ", você deve anexar o formulário específico da mamografia, sem isto não é possível realizar a solicitação.", "error");
        return false;
      }
    }



    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_solicitacao',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoGravacao': 'solicitacao-registro',
        'idPaciente': $("#idPaciente").val(),
        'idSolicitacao': $("#idSolicitacao").val(),
        'numeroProtocolo': $("#numeroProtocolo").val(),
        'grupoProcedimento': $("#grupoProcedimento").val(),
        'nomeProcedimento': $("#nomeProcedimento").val(),
        'idProcedimentoEditado': $("#idProcedimentoEditado").val(),
        'observacaoSolicitacao': $("#observacaoSolicitacao").val(),
        'tokenSolicitacao': $("#tokenSolicitacao").val(),
        'cidSolicitacao': $("#cidSolicitacao").val(),
        'profissionalSolicitante': profissionalSolicitante,
        'retornoSolicitacao': retornoSolicitacao,
        'classificacaoPrioridade': classificacaoPrioridade,
        'pacienteOncologico': document.getElementById('pacienteOncologico').checked == true ? "S" : "N",
        'pacienteDiabetico': document.getElementById('pacienteDiabetico').checked == true ? "S" : "N",
        'pacienteHipertenso': document.getElementById('pacienteHipertenso').checked == true ? "S" : "N",
        'pacienteRenalCronico': document.getElementById('pacienteRenalCronico').checked == true ? "S" : "N",
        'pacientePCD': document.getElementById('pacientePCD').checked == true ? "S" : "N",
        'pacienteAlergico': document.getElementById('pacienteAlergico').checked == true ? "S" : "N",
        'descricaoDeficiencia': $("#descricaoDeficiencia").val(),
        'descricaoAlergia': $("#descricaoAlergia").val()
      }
    }).done(function(resultadoRetorno) {
      if (resultadoRetorno == "JáExiste") {
        $("#embacado").css("display", "none");
        swal("Solicitação Duplicada", "Já existe uma solicitação pendente deste paciente para o mesmo procedimento. Consulte na aba solicitações existentes.", "error");
        return false;
      }
      retornoResultado = resultadoRetorno.split("##");
      $("#idSolicitacao").val(retornoResultado[0]);
      $("#numeroProtocolo").val(retornoResultado[1]);
      $("#imprimirProtocolo").prop('disabled', false);
      $("#btnNovoPaciente").prop('disabled', false);
      $("#grupoProcedimento").prop('disabled', true);
      $("#nomeProcedimento").prop('disabled', true);
      //notificarSolicitacao(retornoResultado[1]);
      $("#embacado").css("display", "none");
      swal("Cadastro de Solicitação", "Solicitação cadastrada com sucesso.", "success");
      carregarHistorico(retornoResultado[0]);
    });
  }

  function carregarHistorico(idSolicitacao) {
    $.ajax({
      url: 'filtros/filtrar_solicitacoes',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoBusca': 'historico-movimento',
        'getOp': "<?php echo $getOp; ?>",
        'idSolicitacao': idSolicitacao
      }
    }).done(function(resultadoRetorno) {

      $('#lista_historico').DataTable().destroy();
      $('#lista_historico tbody').empty().append(resultadoRetorno);
      $('#lista_historico').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
      $("#salvarSolicitacao").prop("disabled", true);
      $("#btnAdicionarArquivo").prop("disabled", true);
    });
  }

  function novaSolicitacao() {

    swal({

      title: "Cadastrar Nova Solicitação",
      text: "Informe se a nova solicitação é para o mesmo paciente ou para outro paciente!",
      icon: "warning",

      buttons: {
        confirm: {
          text: "MESMO PACIENTE",
          value: true,
          visible: true,
          className: "btn-blue",
          closeModal: false
        },
        cancel: {
          text: "OUTRO PACIENTE",
          value: null,
          visible: true,
          className: "btn-green",
          closeModal: false,
        },
        cancel: {
          text: "OUTRO PACIENTE",
          value: null,
          visible: true,
          className: "btn-green",
          closeModal: false,
        }
      }

    }).then((isConfirm) => {

      if (isConfirm) {
        window.location.href = "solicitacao_cadastro?idpac=<?php echo $idPaciente; ?>&op=cs";
      } else {
        window.location.href = "paciente_buscar?op=cs";
      }

    });

  }

  function filtrarProcedimentos() {

    $("#nomeProcedimento").html("<option>AGUARDE...</option>");
    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'cadastrar-solicitacao',
        'grupoProcedimento': $("#grupoProcedimento").val(),
        'sexoPaciente': "<?php echo $sexoPaciente; ?>",
        'idadePaciente': $("#idadePaciente").val()
      }
    }).done(function(resultadoRetorno) {
      $("#procedimentoSelecionado").val("");
      $("#nomeProcedimento").html("");
      $("#nomeProcedimento").html(resultadoRetorno);
      $("#div-observacaoProcedimento").css("display", "none");
    });

  }

  function excluirAnexo(idDocumento, anexoExcluir, tokenSolicitacao) {
    var idPerfilLogado = "<?php echo $idPerfilLogado; ?>";
    if ((idPerfilLogado == '5' || idPerfilLogado == '6' || idPerfilLogado == '7') && numeroProtocolo != "") {
      swal("Não Autorizado.", "Esta solicitação já foi salva. Você não pode mais excluir documentos. Entre em contato com a Coordenação da Regulação.", "error");
      return false;
    }

    Swal.fire({
      title: "Exclusão de Documento",
      html: "Confirma exclusão do documento selecionado?",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM! Excluir",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando){
      if (retornoComando.value) {
        $.ajax({
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao': 'documento_anexo',
            'idRegistroExclusao': idDocumento,
            'anexoExcluir': anexoExcluir,
            'tokenSolicitacao': tokenSolicitacao,
          }
        }).done(function(resultadoRetorno) {
          $('#documentos_anexos').DataTable().destroy();
          $('#documentos_anexos tbody').empty().append(resultadoRetorno);
          $('#documentos_anexos').DataTable({
            "paging": false,
            "filter": false,
            "lengthChange": false,
            "info": false
          });
          $("#embacado").css("display", "none");
          swal("Exclusão de Documento.", "Exclusão de procedimento realizada com sucesso.", "info");
        });
      }
    });

  }

  function imprimirProtocolo() {
    window.open("imprimir_protocolo?idsol=" + $("#idSolicitacao").val());
  }

  /* ATRIBUIR VALORES DOS COMBOS */
  $("#grupoProcedimento").val("<?php echo $grupoProcedimento ?>");
  $("#grupoProcedimento").trigger("change");
  setTimeout(function() {
    $("#nomeProcedimento").val("<?php echo $idProcedimento ?>");
    $("#nomeProcedimento").trigger("change");
  }, 1000);


  function notificarSolicitacao(numeroProtocolo) {
    var telefoneCelular1Whatsapp = "<?php echo $telefoneCelular1Whatsapp; ?>";
    var telefoneCelular2Whatsapp = "<?php echo $telefoneCelular2Whatsapp; ?>";
    var telefoneCelular3Whatsapp = "<?php echo $telefoneCelular3Whatsapp; ?>";
    var telefoneCelular1 = "<?php echo $telefoneCelular1; ?>";
    var telefoneCelular2 = "<?php echo $telefoneCelular2; ?>";
    var telefoneCelular3 = "<?php echo $telefoneCelular3; ?>";
    var dataSolicitacao = "<?php echo $dataSolicitacao; ?>";

    /* MENSAGEM A SER ENVIADA */
    mensagemAgendamento = "*REGULAÇÃO MUNICIPAL DE LAURO DE FREITAS*\n\n";
    mensagemAgendamento = mensagemAgendamento + "Prezado(a) " + $("#nomePaciente").val() + "\n";
    mensagemAgendamento = mensagemAgendamento + "Esta é uma confirmação do registro da sua solicitação no sistema da regulação municipal.\n\n";
    mensagemAgendamento = mensagemAgendamento + "*Procedimento:* " + $('#procedimentoSelecionado').val() + "\n";
    mensagemAgendamento = mensagemAgendamento + "*Protocolo:* " + numeroProtocolo + "\n";
    mensagemAgendamento = mensagemAgendamento + "*Data da Solicitação:* " + dataSolicitacao + "\n";
    mensagemAgendamento = mensagemAgendamento + "*Status da Solicitação:* EM ANÁLISE\nVocê será notificado(a) quando a análise for concluída.\n\n";
    mensagemAgendamento = mensagemAgendamento + "💡 *Atenção!*\nVocê também pode utilizar os serviços da nossa *Inteligência Artificial*! Ela se chama Laura. Se desejar conhecer as opções de atendimento da Laura, envie um *oi* para ela aqui neste mesmo contato.";
    mensagemAgendamento = mensagemAgendamento + "💡 *Você também pode acompanhar suas solicitações no site:*\n <?php echo $siteRegulacaoMunicipal; ?>\n\n";
    mensagemAgendamento = mensagemAgendamento + "🚨 *Observação:*\n*Caso você não consiga acompanhar através do Whatsapp e nem pelo site, pode também pode dirigir-se a um posto de regulação mais próximo a sua residência.*\n\n";

    /** configuração dos dados para acesso à api de envio**/
    const linkImagemNonitifcacao = "https://laurodefreitas.portalgsaude.app.br/regulacao/css/images/gSaude-notificacaozap.png";
    const myHeaders = new Headers();
    myHeaders.append("Content-Type", "application/json");
    myHeaders.append("apikey", "zYzP7ocstxh3Sscefew4FZTCu4ehnM8v436");

    /** executar envio da notificação **/
    if (telefoneCelular1Whatsapp == "S") { // telefone 1 se for whatsapp
      const raw = JSON.stringify({
        "number": telefoneCelular1,
        "options": {
          "delay": 600,
          "presence": "composing"
        },
        "mediaMessage": {
          "mediatype": "image",
          "caption": mensagemAgendamento,
          "media": linkImagemNonitifcacao
        }
      });
      const requestOptions = {
        method: "POST",
        headers: myHeaders,
        body: raw,
        redirect: "follow"
      };
      fetch("https://storage.essencialapi.app.br/message/sendMedia/laurodefreitas", requestOptions)
        .then((response) => response.text())
        .then((result) => {
          $("#embacado").css("display", "none");
          swal("Registro de Solicitação", "Solicitação registrada com sucesso.", "success");
        })
        .catch((error) => {
          swal('Notificação não Enviada', "Não foi possível enviar a notificação ao telefone do(a) cidadão(ã).", 'error');
        });
    }

    if ((telefoneCelular2Whatsapp == "S") && (telefoneCelular2 != telefoneCelular1 && telefoneCelular2 != telefoneCelular3)) { // telefone 2 se for whatsapp
      const raw = JSON.stringify({
        "number": telefoneCelular2,
        "options": {
          "delay": 600,
          "presence": "composing"
        },
        "mediaMessage": {
          "mediatype": "image",
          "caption": mensagemAgendamento,
          "media": linkImagemNonitifcacao
        }
      });
      const requestOptions = {
        method: "POST",
        headers: myHeaders,
        body: raw,
        redirect: "follow"
      };
      fetch("https://storage.essencialapi.app.br/message/sendMedia/laurodefreitas", requestOptions)
        .then((response) => response.text())
        .then((result) => {
          $("#embacado").css("display", "none");
          swal("Registro de Solicitação", "Solicitação registrada com sucesso.", "success");
        })
        .catch((error) => {
          swal('Notificação não Enviada', "Não foi possível enviar a notificação ao telefone do(a) cidadão(ã).", 'error');
        });
    }
    if ((telefoneCelular3Whatsapp == "S") && (telefoneCelular3 != telefoneCelular1 && telefoneCelular3 != telefoneCelular2)) { // telefone 3 se for whatsapp
      const raw = JSON.stringify({
        "number": telefoneCelular3,
        "options": {
          "delay": 600,
          "presence": "composing"
        },
        "mediaMessage": {
          "mediatype": "image",
          "caption": mensagemAgendamento,
          "media": linkImagemNonitifcacao
        }
      });
      const requestOptions = {
        method: "POST",
        headers: myHeaders,
        body: raw,
        redirect: "follow"
      };
      fetch("https://storage.essencialapi.app.br/message/sendMedia/laurodefreitas", requestOptions)
        .then((response) => response.text())
        .then((result) => {
          $("#embacado").css("display", "none");
          swal("Registro de Solicitação", "Solicitação registrada com sucesso.", "success");
        })
        .catch((error) => {
          swal('Notificação não Enviada', "Não foi possível enviar a notificação ao telefone do(a) cidadão(ã).", 'error');
        });
    }
  }

  $("#profissionalSolicitante").selectivity('value', '<?php echo $profissionalSolicitante; ?>');
  $("#retornoSolicitacao").val("<?php echo $retornoSolicitacao; ?>");
  $("#classificacaoPrioridade").val("<?php echo $classificacaoRisco; ?>");

  var statusSolicitacao = "<?php echo $idStatusSolicitacao; ?>";
  var autorizadorCNS = "<?php echo $autorizadorCNS; ?>";
  if (bloquearPacienteFora == "S" && $("#idSolicitacao").val() == "" && autorizadorCNS == "N") {
    $("#salvarSolicitacao").prop("disabled", true);
    $("#btnAdicionarArquivo").prop("disabled", true);
    swal('Não Autorizado', "Este cartão SUS não pertente ao município de " + nomeMunicipioSede + " e não está autorizado para solicitação. O paciente deverá solicitar atualização do endeceço do seu cartão.", 'error');
  } else if (statusSolicitacao != "1" && statusSolicitacao != "2" && statusSolicitacao != "10" && $("#idSolicitacao").val() != "") {
    $("#salvarSolicitacao").prop("disabled", true);
    $("#btnAdicionarArquivo").prop("disabled", true);
    swal('Alteração Bloqueada', "O status atual desta solicitação não permite mais alterações.", 'error');
  }

  function habilitaDescricao(opcaoDescricao, valorAssinalado) {

    switch (opcaoDescricao) {
      case "pcd":
        if (valorAssinalado == true) {
          $("#descricaoDeficiencia").prop("disabled", false);
        } else {
          $("#descricaoDeficiencia").prop("disabled", true);
          $("#descricaoDeficiencia").val('');
        }
        break;
      case "alergia":
        if (valorAssinalado == true) {
          $("#descricaoAlergia").prop("disabled", false);
        } else {
          $("#descricaoAlergia").prop("disabled", true);
          $("#descricaoAlergia").val('');
        }
        break;
    }
  }

  function abrirPesquisaCid(){
    $("#box_pesquisa_cid").modal()
		setTimeout(function(){ 
			$("#conteudoPesquisa").focus();
		}, 400);
  }

	function pesquisaCID() {

		if ($("#conteudoPesquisa").val() == "") {
			swal("Informação Obrigatória", "Você deve informar o CID que deseja pesquisar.", 'error');
			return false;
		}
		$("#embacado").css("display", "block");
		$.ajax({
			url: 'filtros/filtrar_cid',
			type: 'post',
			dataType: 'html',
			data: {
				'conteudoPesquisa': $("#conteudoPesquisa").val()
			}
		}).done(function(resultadoRetorno) {
			$("#resultadoRetornoCID").html(resultadoRetorno);
			$("#embacado").css("display", "none");
		});
	}

  /** seleciona o grupo de OCI se for NGC com o campo bloqueado **/
  var idPerfilLogado = "<?php echo $idPerfilLogado;?>";
  if(idPerfilLogado==20){
    $("#grupoProcedimento").val('14');
    $("#grupoProcedimento").trigger("change");
    $("#retornoSolicitacao").val("N");
    $("#retornoSolicitacao").prop("disabled",true);
  }

</script>