<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header-clean.php");
$dataHoje   	= date("Y-m-d");
$idTetoMensal	= $_GET['idteto'];

$sqlDadosTeto = "SELECT ucase(tb_estabelecimento.nfantasia_estabelecimento) AS nomeEstabelecimento,
tb_estabelecimento.cnes_estabelecimento,
tb_estabelecimento.codigoestabelecimento_cnes,
reg_tb_tetounidade.id_grupo_procedimento,
reg_tb_tetounidade.tipo_apuracao,
reg_tb_tetounidade.quantidade_programada,
format(reg_tb_tetounidade.valor_programado, 2, 'de_DE') AS valorProgramado,
ucase(reg_tb_procedimento_grupo.nome_grupo_procedimento) AS nomeGrupoProcedimento
FROM reg_tb_tetounidade
INNER JOIN reg_tb_procedimento_grupo ON (reg_tb_tetounidade.id_grupo_procedimento = reg_tb_procedimento_grupo.id_grupo_procedimento)
INNER JOIN tb_estabelecimento ON (reg_tb_tetounidade.codigoestabelecimento_cnes = tb_estabelecimento.codigoestabelecimento_cnes)
WHERE id_tetounidade='$idTetoMensal'";

$stmDadosTeto						=	$rsConexao->prepare($sqlDadosTeto);
$stmDadosTeto->execute();
$rsDadosTeto						= $stmDadosTeto->fetch(PDO::FETCH_OBJ);
$nomeEstabelecimento		= $rsDadosTeto->nomeEstabelecimento;
$cnesEstabelecimento		= $rsDadosTeto->cnes_estabelecimento;
$idGrupoProcedimento		= $rsDadosTeto->id_grupo_procedimento;
$nomeGrupoProcedimento	= $rsDadosTeto->nomeGrupoProcedimento;
$codigoEstabelecimento	= $rsDadosTeto->codigoestabelecimento_cnes;
$quantidadeProgramada		= $rsDadosTeto->quantidade_programada;
$valorProgramado				= $rsDadosTeto->valorProgramado;
$tipoApuracao						= $rsDadosTeto->tipo_apuracao=="fisico" ? "Teto Físico:" : "Teto Financeiro:";

if($rsDadosTeto->tipo_apuracao=="fisico"){
	$typeFisico			= "text";
	$typeFinanceiro	= "hidden";
}else{
	$typeFisico			= "hidden";
	$typeFinanceiro	= "text";	
}
# --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --#

$bloquearSelecao = "";
$checkedTodosProcedimentos = "";
$selecionarGrupo = "";

//carregar lista de procedimentos do grupo

$resultadoHTML  = "";
$stmProcedimentosGrupo  = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento WHERE id_grupo_procedimento='$idGrupoProcedimento' ORDER BY nome_procedimento");
$stmProcedimentosGrupo->execute();
$bloquearSelecao        = $stmProcedimentosGrupo->rowCount() < 1 ? "disabled" : "";
$contaProcedimentos     = 0;
if ($stmProcedimentosGrupo->rowCount() > 0) {
	$rsProcedimentosGrupo   = $stmProcedimentosGrupo->fetchAll(PDO::FETCH_ASSOC);
	foreach ($rsProcedimentosGrupo as $fiedProcedimentosGrupo) {
		$contaProcedimentos = $contaProcedimentos + 1;
		$idProcedimento     = $fiedProcedimentosGrupo['id_procedimento'];
		$codigoSUS					= $fiedProcedimentosGrupo['codigo_sus'];
		$nomeProcedimento   = $fiedProcedimentosGrupo['nome_procedimento'];
		$onChangeSelecionar = 'onchange="selecionaProcedimentosTodos(this.checked,' . "'individual')" . '"';

		#selecionar procedimentos adicionados --#
		if ($idTetoMensal != 0 && $idTetoMensal != "") {
			$sqlProcedimentoAdicionado = "SELECT id_procedimento
				FROM reg_tb_tetounidade_grupoprocedimento
				WHERE id_tetounidade='$idTetoMensal'
				AND id_procedimento='$idProcedimento'";
			$stmProcedimentos = $rsConexao->prepare($sqlProcedimentoAdicionado);
			$stmProcedimentos->execute();
			if ($stmProcedimentos->rowCount() > 0) {
				$selecionaProcedimento  = " checked";
			} else {
				$selecionaProcedimento  = "";
			}
		} else {
			$selecionaProcedimento  = "";
		}
		$resultadoHTML    .= "<tr>
          <td align='center'>
            <input type='checkbox' id='procedimentoGrupo$contaProcedimentos' name='procedimentoGrupo[]' class='form-control checkbox-seleciona-procedimento-grupo' $onChangeSelecionar $selecionaProcedimento>
          </td>
          <td id='td-procedimentoGrupo$contaProcedimentos' style='display:none'>
            $idProcedimento
          </td>
          <td>
            $codigoSUS - $nomeProcedimento
          </td>
        </tr>";
	}
}

# -- selecionar o campo que indica seleção de todos os procedimentos do grupo --#
$sqlProcedimentoAdicionado = "";
if ($idTetoMensal != 0 && $idTetoMensal != "") {
	$sqlProcedimentoAdicionado = "SELECT COUNT(id_procedimento) as totalProcedimentos 
		FROM reg_tb_tetounidade_grupoprocedimento
		WHERE id_tetounidade='$idTetoMensal'";
	$stmProcedimentos = $rsConexao->prepare($sqlProcedimentoAdicionado);
	$stmProcedimentos->execute();
	$rsProcedimentos  = $stmProcedimentos->fetch(PDO::FETCH_OBJ);
	if ($rsProcedimentos->totalProcedimentos == $contaProcedimentos) {
		$checkedTodosProcedimentos  = " checked";
	} else {
		$checkedTodosProcedimentos  = "";
	}
} else {
	$checkedTodosProcedimentos  = "";
}

?>

<div class="app-content content" style="background-color: #e1e9e7;">
	<div class="content-wrapper" style="padding: 10px;">
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style="border: gray 1px solid;" id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-prescription" style='margin-top:-15px !important'></i>&nbsp;Atribuir procedimentos ao teto da unidade
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section" style='margin-top:-10px'>
											<i class="icofont icofont-checked"></i><b>Unidade de grupo selecionados.</b>
										</h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-4">
												<div class="form-group">
													<label for="nomeEstabelecimento">Estabelecimento de Saúde:</label>
													<input type="text" id="nomeEstabelecimento" class="form-control" value="<?php echo $nomeEstabelecimento; ?>" disabled />
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="cnesEstabelecimento">CNES:</label>
													<input type="text" id="cnesEstabelecimento" class="form-control text-center" value="<?php echo $cnesEstabelecimento; ?>" disabled />
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="nomeGrupo">Nome do Grupo:</label>
													<input type="text" id="nomeGrupo" class="form-control" value="<?php echo $nomeGrupoProcedimento; ?>" disabled />
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="labelTipoTeto"><?php echo $tipoApuracao;?></label>
													<input type="<?php echo $typeFisico;?>" id="quantidadeTeto" class="form-control text-center" value="<?php echo $quantidadeProgramada;?>" disabled>
													<input type="<?php echo $typeFinanceiro;?>" id="valorTeto" class="form-control text-right" value="<?php echo $valorProgramado;?>" disabled>
												</div>
											</div>
										</div>
										<div class="form-body" style='margin-top:-10px'>
											<h4 class="form-section"><i class="icofont icofont-info-circle"></i><b>Procedimentos relacionados ao grupo.</b></h4>
											<table style='margin-top:-10px'>
												<tr>
													<td>
														<label style='color:#046B97; font-weight:bold'>Selecionar todos os procedimentos:</label>&nbsp;&nbsp;
													</td>
													<td>
														<input type="checkbox" id="chkProcedimentoTodos" class="form-control checkbox-seleciona-procedimento-grupo" style='margin-top:-5px' <?php echo $bloquearSelecao . ' ' . $checkedTodosProcedimentos; ?> onchange="selecionaProcedimentosTodos(this.checked,'todos')">
														<input type="checkbox" id="temProcedimentoSelecionado" style='display:none' <?php echo $selecionarGrupo; ?>>
													</td>
												</tr>
											</table>
										</div><br>
										<div class="row" style="margin-top:-4px;">
											<div class="col-md-12">
												<div class="form-group">
													<table class='table table-striped table-bordered' style='width:100%; margin-top:-13px' id="lista_procedimentos">
														<thead style='background-color:#046B97; color:#fff'>
															<tr>
																<th style="text-align:center; width:5%">SELECIONAR</th>
																<th style="text-align:center; width:5px; display:none">IDP</th>
																<th>NOME DO PROCEDIMENTO</th>
															</tr>
														</thead>
														<tbody style="background-color: #ececec;">
															<?php
															echo $resultadoHTML;
															?>
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>
<div class="barra-flutuante">
	<button type='button' class='btn btn-blue' id='btnConfirmar' onClick='gravarProcedimentosGrupo()'>
		<i class='icofont icofont-checked'></i> Salvar
	</button>
	<button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
		<i class='icofont icofont-exit'></i> Fechar
	</button>
</div>
<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	function selecionaProcedimentosTodos(selecionarTodos, OpValidador) {

		var contaProcedimentos = "<?php echo $contaProcedimentos; ?>";
		var itemSelecao = 0;
		switch (OpValidador) {
			case "todos":
				for (itemSelecao = 1; itemSelecao <= contaProcedimentos; itemSelecao++) {
					$("#procedimentoGrupo" + itemSelecao).prop("checked", selecionarTodos);
					$("#temProcedimentoSelecionado").prop("checked", selecionarTodos);
				}
				break;
			case "individual":
				var temProcedimentoSel = false;
				var totalSelecionado = 0;

				$("#temProcedimentoSelecionado").prop("checked", false);
				for (itemSelecao = 1; itemSelecao <= contaProcedimentos; itemSelecao++) {
					temProcedimentoSel = $("#procedimentoGrupo" + itemSelecao).is(":checked");
					if (temProcedimentoSel == true) {
						totalSelecionado = totalSelecionado + 1;
						$("#temProcedimentoSelecionado").prop("checked", temProcedimentoSel);
					}
				}
				if (parseInt(totalSelecionado) == parseInt(contaProcedimentos)) {
					$("#chkProcedimentoTodos").prop("checked", true);
				} else {
					$("#chkProcedimentoTodos").prop("checked", false);
				}
				break;
		}
	}

	function gravarProcedimentosGrupo() {

		var itemSelecao = 0;
		var temProcedimentoSel = false;
		var arrayProcedimento = new Array();
		var contaProcedimentos = parseInt("<?php echo $contaProcedimentos; ?>");
		for (itemSelecao = 1; itemSelecao <= contaProcedimentos; itemSelecao++) {
			temProcedimentoSel = $("#procedimentoGrupo" + itemSelecao).is(":checked");
			if (temProcedimentoSel == true) {
				arrayProcedimento.push(parseInt($("#td-procedimentoGrupo" + itemSelecao).html()));
			}
			temProcedimentoSel = false;
		}

		$('#embacado').css('display', 'block');
		$.ajax({
			url: 'action/gravar_tetomensal',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoGravacao' : 'registro-procedimento-grupo',
				'idTetoMensal': "<?php echo $idTetoMensal;?>",
				'unidadeSaude': "<?php echo $codigoEstabelecimento;?>",
				'grupoProcedimento': "<?php echo $idGrupoProcedimento;?>",
				'arrayProcedimento': arrayProcedimento
			}
		}).done(function(resultadoRetorno) {

			$("#embacado").css("display", "none");
			swal("Grupo de Procedimentos", "Procedimentos associados ao grupo com sucesso.", "success");
		});
	}
</script>