<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
$idPerfilLogado   = $_SESSION['idPerfilLogado'];
$idUnidadeLogada  = $_SESSION['unidadeLogada'];
$setDisabled      = $idPerfilLogado == 13 ? " disabled" : "";

include_once("header.php");
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
  <div class="content-wrapper" style='padding:10px;'>
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style='border:gray 1px solid;' id="card-tela">
            <div class="card-header titulo-telas">
              <h4 class="card-title" style="font-size: 11pt; margin-top: -8px; color: #fff;">
                <b><i class="icofont icofont-file-text"></i>&nbsp;VAGAS DISPONÍVEIS</b>
              </h4>
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form" style='margin-top:-10px'>
                  <div class="form-body">
                    <h4 class="form-section"><i class="icofont icofont-filter"></i> <b>Filtro de dados do relatório</b></h4>
                    <div class="row" style="margin-top:-10px;">
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="grupoProcedimento">Grupo:</label>
                          <select class="form-control" id="grupoProcedimento" onchange="filtrarProcedimentos()">
                            <option value="">TODOS...</option>
                            <?php
                            $stmGrupoProcedimento = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE nome_grupo_procedimento='NÃO AGRUPADOS'");
                            $stmGrupoProcedimento->execute();
                            $rsGrupoProcedimento  = $stmGrupoProcedimento->fetch(PDO::FETCH_OBJ);
                            echo "<option value='$rsGrupoProcedimento->id_grupo_procedimento'>$rsGrupoProcedimento->nome_grupo_procedimento</option>";
                            $stmGrupoProcedimento->closeCursor();
                            $stmGrupoProcedimento = $rsConexao->prepare('SELECT * FROM reg_tb_procedimento_grupo ORDER BY nome_grupo_procedimento');
                            $stmGrupoProcedimento->execute();
                            $rsGrupoProcedimento  = $stmGrupoProcedimento->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($rsGrupoProcedimento as $fieldGrupoProcedimento) {
                              $idGrupoProcedimento    = $fieldGrupoProcedimento['id_grupo_procedimento'];
                              $nomeGrupoProcedimento  = $fieldGrupoProcedimento['nome_grupo_procedimento'];
                              if ($nomeGrupoProcedimento != "NÃO AGRUPADOS") {
                                echo "<option value='$idGrupoProcedimento'>GRUPO - $nomeGrupoProcedimento</option>";
                              }
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-7">
                        <div class="form-group">
                          <label for="nomeProcedimento">Nome do Procedimento:</label>
                          <select class="form-control" id="nomeProcedimento">
                            <option value="">TODOS...</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-10px;">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="dataInicioVaga">Data Inicial da Análise:</label>
                          <input type='date' id='dataInicioVaga' class='form-control text-center' value="<?php echo date('Y-m-d'); ?>" disabled>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="dataFinalVaga">Data Final da Análise:</label>
                          <input type='date' id='dataFinalVaga' class='form-control text-center'>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-17px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <div class="bs-callout-warning callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                            <div class="media align-items-stretch">
                              <div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
                                <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                              </div>
                              <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                                <strong>
                                  INFORMAÇÃO! Para exibição do relatório, o sistema sempre considerará as vagas não ocupadas a partir da data de hoje (<?php echo date("d/m/Y") ?>).
                                </strong>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-body">
                    <div class="form-actions" style="margin-top:-15px !important"></div>
                    <div class="row" style="margin-top:-17px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <button type="button" class="btn btn-blue" onClick="imprimirRelatorio('visualizar-relatorio')">
                            <i class="icofont icofont-printer"></i> Visualizar e Imprimir
                          </button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
    </section>
  </div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liRelVagasDisponiveis").attr('class', 'active');
  $("#liRelVagasDisponiveis").css("border-bottom", "2px solid #c4c8ca");

  function filtrarProcedimentos() {

    var itemSelecionado = $('#grupoProcedimento').find(":selected").text();
    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'consultar-solicitacao',
        'grupoProcedimento': $("#grupoProcedimento").val()
      }
    }).done(function(resultadoRetorno) {
      $("#procedimentoSelecionado").val("");
      $("#nomeProcedimento").html("");
      $("#nomeProcedimento").html(resultadoRetorno);
      
      if (itemSelecionado.substr(0, 5) == "TODOS") {
        $("#nomeProcedimento").html("<option value=''>TODOS...</option>");
      }

    });

  }

  function imprimirRelatorio() {

    if ($("#grupoProcedimento").val() == "") {
      swal("Grupo Obrigatório", "Selecione um grupo de procedimentos para impressão do relatório.", "error");
      return false;
    }

    if ($("#dataFinalVaga").val() == "") {
      swal("Data Obrigatória", "A data limite para impressão do relatório é obrigatória.", "error");
      return false;
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gerar_relatoriovagas',
      type: 'post',
      dataType: 'html',
      data: {
        'grupoProcedimento': $("#grupoProcedimento").val(),
        'nomeProcedimento': $('#nomeProcedimento').val(),
        'dataInicioVaga': $("#dataInicioVaga").val(),
        'dataFinalVaga': $('#dataFinalVaga').val()
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      window.open("relatorios/relatoriovagas_disponiveis");
    });

  }

  /** SETAR UNIDADE LOGADA */
  var idPerfilLogado = "<?php echo $idPerfilLogado; ?>";
  var idUnidadeLogada = "<?php echo $idUnidadeLogada; ?>";
  if (idPerfilLogado == 13) {
    $("#unidadeSaude").val(idUnidadeLogada)
    $("#unidadeSaude").trigger("change");
  }


  /*
  SELECT reg_tb_procedimento.nome_procedimento,
  CONCAT(LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0'),'/',reg_tb_agenda_sub.mes_agenda,'/',reg_tb_agenda_sub.ano_agenda) AS dataVaga,
           SUM(reg_tb_agenda_sub.quantidadevagas_pvez)- SUM(reg_tb_agenda_sub.quantidadegendada_pvez)AS saldoVagas,       
          tb_estabelecimento.nfantasia_estabelecimento,
          tb_profissional.nome_profissional
  FROM (((gsaude_lfreitas.reg_tb_agenda reg_tb_agenda
          INNER JOIN gsaude_lfreitas.tb_estabelecimento tb_estabelecimento
             ON (reg_tb_agenda.codigoestabelecimento_cnes =
                 tb_estabelecimento.codigoestabelecimento_cnes))
         INNER JOIN gsaude_lfreitas.reg_tb_procedimento reg_tb_procedimento
            ON (reg_tb_agenda.id_procedimento =
                reg_tb_procedimento.id_procedimento))
        INNER JOIN gsaude_lfreitas.reg_tb_agenda_sub reg_tb_agenda_sub
           ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda))
       INNER JOIN gsaude_lfreitas.tb_profissional tb_profissional
          ON (reg_tb_agenda.codigoprofissional_cnes =
              tb_profissional.codigoprofissional_cnes)
  WHERE (    (    reg_tb_agenda_sub.status_agenda = 'A'
              AND reg_tb_agenda_sub.quantidadevagas_pvez IS NOT NULL)
         AND CONCAT(reg_tb_agenda_sub.ano_agenda,
                    '-',
                    reg_tb_agenda_sub.mes_agenda,
                    '-',
                    LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0')) >= '2024-08-04')
  AND (reg_tb_agenda_sub.profissional_afastado = 'N')
        AND (reg_tb_agenda_sub.unidade_afastada = 'N')                  
  GROUP BY reg_tb_agenda_sub.status_agenda,
           reg_tb_agenda_sub.mes_agenda,
           reg_tb_agenda_sub.quantidadevagas_pvez,
           reg_tb_agenda_sub.quantidadegendada_pvez,
           reg_tb_agenda_sub.ano_agenda,
           reg_tb_agenda_sub.dia_agenda,
           reg_tb_agenda_sub.id_procedimento,
           tb_estabelecimento.nfantasia_estabelecimento,
           tb_profissional.nome_profissional
  HAVING (  SUM(reg_tb_agenda_sub.quantidadevagas_pvez)
          - SUM(reg_tb_agenda_sub.quantidadegendada_pvez) >
          0)
  ORDER BY reg_tb_procedimento.nome_procedimento,
  CONCAT(reg_tb_agenda_sub.ano_agenda,'-',reg_tb_agenda_sub.mes_agenda,'-',LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0')), 
  tb_estabelecimento.nfantasia_estabelecimento,
  tb_profissional.nome_profissional
  */
</script>