<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['error' => 'Método não permitido']);
    exit;
}

$operacao = $_POST['operacao'] ?? null;
$instancia = $_POST['instancia'] ?? '';

// GROBAL ESSA
$API_KEY = 'zYzP7ocstxh3Sscefew4FZTCu4ehnM8v436';

function executarCurl($url, $metodo = 'GET', $customRequest = null)
{
    global $API_KEY;

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => $customRequest ?? $metodo,
        CURLOPT_HTTPHEADER => array(
            "apikey: $API_KEY"
        ),
    ));

    $resposta = curl_exec($curl);
    curl_close($curl);

    return json_decode($resposta, true);
}

if ($operacao === 'fetchInstances') {
    $url = 'https://storage.essencialapi.app.br/instance/fetchInstances';
    $resultado = executarCurl($url);
    echo json_encode($resultado);
    exit;
} elseif ($operacao === 'connect' && !empty($instancia)) {
    $url = "https://storage.essencialapi.app.br/instance/connect/$instancia";
    $resultado = executarCurl($url);
    echo json_encode($resultado);
    exit;
} elseif ($operacao === 'logout' && !empty($instancia)) {
    $url = "https://storage.essencialapi.app.br/instance/logout/$instancia";
    $resultado = executarCurl($url, 'DELETE');
    echo json_encode($resultado);
    exit;
} elseif ($operacao === 'restart' && !empty($instancia)) { 
    $url = "https://storage.essencialapi.app.br/instance/restart/$instancia";
    $resultado = executarCurl($url, 'PUT');
    echo json_encode($resultado);
    exit;
}

echo json_encode(['error' => 'Operação inválida ou dados ausentes']);
exit;
