<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
$instanciaWhatsapp = "";
switch($_SESSION['nomeMunicipioSede']){
  case "CANDEIAS":
    $instanciaWhatsapp = "GSaudeCandeias";
    break;
  case "LAURO DE FREITAS":
    $instanciaWhatsapp = "laurodefreitas";
    break;
}

?>

<style>
  .status {
    padding: 10px;
    text-align: center;
    color: white;
    border-radius: 5px;
    font-weight: bold;
  }

  .status-conectado {
    background: linear-gradient(to right, #005186,#79d9ff);
  }

  .status-desconectado {
    background: linear-gradient(to right, #9b0c18, #fc7984);
  }
</style>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding-left: 10px; padding-right: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid; margin-top: -20px;" id="card-tela">
            <div class="card-header" style="background: url(css/images/bg-title.png); background-repeat: repeat-x; height: 45px !important;">
              <h4 class="card-title" style="font-size: 11pt; margin-top: -8px; color: #fff;">
                <b><i class="icofont icofont-brand-whatsapp"></i>&nbsp;Integrar Sistema com Whatsapp</b>
              </h4>
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -8px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form" id="formTipoContrato">
                  <div class="form-body">
                    <div class="row">
                      <div class="col-md-12">
                        <div class="form-group">
                          <div class="bs-callout-success callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                            <div class="media align-items-stretch">
                              <div class="media-left d-flex align-items-center bg-success p-2" style='padding:7px !important;'>
                                <i class="icofont icofont-info-circle white font-medium-5"></i>
                              </div>
                              <div class="media-body p-1" style="padding:7px !important; padding-left:10px !important; font-family:Arial, Helvetica, sans-serif; font-size:13pt">
                                <strong>Esta funcionalidade deve ser utilizada para realizar a leitura do QRCode para integração com o Whatsapp.</strong>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group" style='padding-top:15px'>&nbsp;</div>
                      </div>
                      <div class="col-md-4" style='border:#005186 2px dotted'>
                        <div class="form-group">
                          <table align='center' style='width:100%'>
                            <tr>
                              <td align='center'>
                                <div class="card shadow-lg p-4" style="width: 100%; max-width: 400px; border-radius: 10px;">
                                  <div class="text-center">
                                    <b><i class="icofont icofont-brand-whatsapp" style='font-size:40pt; color:#007c0b'></i>
                                      <h3 class="fw-bold"><b>Integração Whatsapp<br>G-SAÚDE Regulação</b></h3>
                                  </div>
                                  <div id="status" class="mb-3 text-center status">Carregando status...</div>
                                  <div class="mb-3" id="detalhes" style="display: none; font-size:16pt">
                                    <p><strong>:: Telefone ::</strong><br><span id="telefoneDono">Carregando...</span></p>
                                  </div>
                                  <div class="d-flex justify-content-center gap-3">
                                    <button type="button" class="btn btn-blue" id="botaoQrCode" style="display: none;">
                                      <i class="icofont icofont-qr-code"></i>&nbsp;&nbsp;Gerar QR Code
                                    </button>
                                  </div>
                                </div>
                              </td>
                            </tr>
                          </table>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">&nbsp;</div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-12">
                        <div class="form-group">
                          <div class="modal fade" id="modalQrCode" tabindex="-1" aria-labelledby="modalQrCodeLabel" aria-hidden="true">
                            <div class="modal-dialog">
                              <div class="modal-content">
                                <div class="modal-header" style='background-color:#005186;'>
                                  <h5 class="modal-title" id="modalQrCodeLabel" style='color:#fff; font-size:13pt'>
                                    <i class='icofont icofont-qr-code'></i>&nbsp;&nbsp;<b>QR Code - Integração</b>
                                  </h5>
                                </div>
                                <div class="modal-body text-center">

                                  <div id="loadingGif" style="display: none;">
                                    <img src="https://i.imgur.com/stBQKH0.gif"
                                      alt="Carregando..."
                                      style="width: 348px; height: 348px;" />
                                  </div>

                                  <img id="imagemQrCode" src="" alt="QR Code" class="img-fluid" style="display: none;">
                                </div>
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-blue" id="botaoAtualizarQrCode"><i class='icofont icofont-refresh'></i> Atualizar</button>
                                  <button type='button' class='btn btn-danger' onclick="$('#modalQrCode').modal('hide');">                                  
                                    <i class='icofont icofont-exit'></i> Fechar
                                  </button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<?php
include_once("footer.php");
?>

<script src="app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liIntegrarWhatsapp").addClass('active');
  $("#liIntegrarWhatsapp").css("border-bottom", "2px solid #494949");

  $(document).ready(function() {

    carregarDados();
    setInterval(carregarDados, 5000);

    $('#botaoQrCode').on('click', gerarQrCode);
    $('#botaoAtualizarQrCode').on('click', gerarQrCode);

  });

  const instanciaNome = "<?php echo $instanciaWhatsapp;?>"; //Colocar o nome da instancia aqui e ja foi 

  function chamarAPI(operacao, instancia = '') {
    return $.ajax({
      url: 'whatsapp_api.php',
      method: 'POST',
      data: {
        operacao,
        instancia
      },
      dataType: 'json'
    });
  }

  function carregarDados() {
    chamarAPI('fetchInstances').done(function(dados) {
      const instancia = dados.find(item => item.instance.instanceName === instanciaNome)?.instance || {};
      const statusDiv = $('#status');
      const detalhesDiv = $('#detalhes');

      if (instancia.status === 'open') {
        // Conectado
        statusDiv.removeClass('status-desconectado').addClass('status-conectado').text('Conectado');
        detalhesDiv.show();
        $('#telefoneDono').text(instancia.owner?.split('@')[0] || 'Não disponível');
        $('#nomePerfil').text("Lauro de Freitas");
        $('#botaoQrCode').hide();
      } else {
        // Desconectado
        statusDiv.removeClass('status-conectado').addClass('status-desconectado').text('Desconectado');
        detalhesDiv.hide();
        $('#botaoQrCode').show();
      }
    });
  }

  function gerarQrCode() {

    $('#loadingGif').show();
    $('#imagemQrCode').hide();

    chamarAPI('connect', instanciaNome).done(function(dados) {

      $('#imagemQrCode').attr('src', dados.base64 || '').show();
      $('#loadingGif').hide();

      $('#modalQrCode').modal('show');


      const intervaloConexao = setInterval(function() {
        chamarAPI('fetchInstances').done(function(dados) {
          const instancia = dados.find(item => item.instance.instanceName === instanciaNome)?.instance || {};
          if (instancia.status === 'open') {
            clearInterval(intervaloConexao);
            $('#botaoAtualizarQrCode').prop('disabled', true);
            $('#modalQrCode').modal('hide');
          }
        });
      }, 5000);
    });
  }


  function desconectar() {
    chamarAPI('logout', instanciaNome).done(function() {
      alert('Desconectado com sucesso!');
      carregarDados();
    });
  }

  $(document).ready(function() {
    carregarDados();
    $('#botaoQrCode').on('click', gerarQrCode);
    $('#botaoAtualizarQrCode').on('click', gerarQrCode);
  });
</script>